/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;

final class ContainerStateMonitor {
    private final ServiceRegistry serviceRegistry;
    private final StabilityMonitor monitor;
    private final Set<ServiceController<?>> failed = new HashSet();
    private final Set<ServiceController<?>> problems = new HashSet();
    private Set<ServiceName> previousMissingDepSet = new HashSet<ServiceName>();
    private Set<ServiceController<?>> previousFailedSet = new HashSet();

    ContainerStateMonitor(ServiceRegistry registry, StabilityMonitor stabilityMonitor) {
        this.serviceRegistry = registry;
        this.monitor = stabilityMonitor;
    }

    void logContainerStateChangesAndReset() {
        ContainerStateChangeReport changeReport = this.createContainerStateChangeReport(true);
        if (changeReport != null) {
            String msg = ContainerStateMonitor.createChangeReportLogMessage(changeReport, false);
            ControllerLogger.ROOT_LOGGER.info(msg);
        }
    }

    StabilityMonitor getStabilityMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitStabilityUninterruptibly(long timeout, TimeUnit timeUnit) throws TimeoutException {
        boolean interrupted = false;
        try {
            long toWait = timeUnit.toMillis(timeout);
            long msTimeout = System.currentTimeMillis() + toWait;
            while (true) {
                if (interrupted) {
                    toWait = msTimeout - System.currentTimeMillis();
                }
                try {
                    if (toWait <= 0L || !this.monitor.awaitStability(toWait, TimeUnit.MILLISECONDS, this.failed, this.problems)) {
                        throw new TimeoutException();
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void awaitStability(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (!this.monitor.awaitStability(timeout, timeUnit, this.failed, this.problems)) {
            throw new TimeoutException();
        }
    }

    ContainerStateChangeReport awaitContainerStateChangeReport(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (this.monitor.awaitStability(timeout, timeUnit, this.failed, this.problems)) {
            return this.createContainerStateChangeReport(false);
        }
        throw new TimeoutException();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized ContainerStateChangeReport createContainerStateChangeReport(boolean resetHistory) {
        void var7_16;
        Set currentFailedControllers;
        Map<Object, MissingDependencyInfo> missingServices;
        Map<ServiceName, Boolean> noLongerMissingServices;
        Map missingDeps;
        if (this.problems.isEmpty()) {
            missingDeps = Collections.emptyMap();
        } else {
            missingDeps = new HashMap(this.problems.size());
            for (ServiceController<?> controller : this.problems) {
                if (controller.getState() == ServiceController.State.REMOVED) continue;
                for (ServiceName missing : controller.getImmediateUnavailableDependencies()) {
                    void var7_7;
                    Set set = (Set)missingDeps.get(missing);
                    if (set == null) {
                        HashSet hashSet = new HashSet();
                        missingDeps.put(missing, hashSet);
                    }
                    var7_7.add(controller.getName());
                }
            }
        }
        Set<ServiceName> previousMissing = this.previousMissingDepSet;
        if (previousMissing.isEmpty()) {
            noLongerMissingServices = Collections.emptyMap();
        } else {
            noLongerMissingServices = new TreeMap();
            for (ServiceName name : previousMissing) {
                if (missingDeps.containsKey(name)) continue;
                ServiceController serviceController = this.serviceRegistry.getService(name);
                noLongerMissingServices.put(name, serviceController != null);
            }
        }
        if (missingDeps.isEmpty()) {
            missingServices = Collections.emptyMap();
        } else {
            missingServices = new TreeMap();
            for (Map.Entry entry : missingDeps.entrySet()) {
                ServiceName name = (ServiceName)entry.getKey();
                if (previousMissing.contains(name)) continue;
                ServiceController serviceController = this.serviceRegistry.getService(name);
                boolean unavailable = serviceController != null && serviceController.getMode() != ServiceController.Mode.NEVER;
                missingServices.put(name, new MissingDependencyInfo(name, unavailable, (Set)entry.getValue()));
            }
        }
        if (this.failed.isEmpty()) {
            Set set;
            currentFailedControllers = set = Collections.emptySet();
        } else {
            currentFailedControllers = new HashSet(this.failed.size());
            HashSet<ServiceController> hashSet = new HashSet<ServiceController>(this.failed.size());
            for (ServiceController serviceController : this.failed) {
                if (serviceController.getState() == ServiceController.State.REMOVED) continue;
                currentFailedControllers.add(serviceController);
                if (this.previousFailedSet.contains(serviceController)) continue;
                hashSet.add(serviceController);
            }
        }
        if (resetHistory) {
            this.previousMissingDepSet = new HashSet(missingDeps.keySet());
            this.previousFailedSet = new HashSet(currentFailedControllers);
            this.failed.clear();
            this.problems.clear();
        }
        boolean needReport = !missingServices.isEmpty() || !currentFailedControllers.isEmpty() || !noLongerMissingServices.isEmpty();
        return needReport ? new ContainerStateChangeReport(missingServices, currentFailedControllers, (Set)var7_16, noLongerMissingServices) : null;
    }

    static String createChangeReportLogMessage(ContainerStateChangeReport changeReport, boolean forException) {
        Set<ServiceController<?>> failedSet;
        StringBuilder msg = new StringBuilder();
        msg.append(forException ? ControllerLogger.ROOT_LOGGER.serviceStatusReportFailureHeader() : ControllerLogger.ROOT_LOGGER.serviceStatusReportHeader());
        int transitiveDownCount = 0;
        if (!changeReport.getMissingServices().isEmpty()) {
            boolean first = true;
            for (Map.Entry<ServiceName, MissingDependencyInfo> entry : changeReport.getMissingServices().entrySet()) {
                if (!entry.getValue().isUnavailable()) {
                    if (first) {
                        msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportDependencies());
                        first = false;
                    }
                    msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportMissing(entry.getKey(), ContainerStateMonitor.createDependentsString(entry.getValue().getDependents())));
                    continue;
                }
                ++transitiveDownCount;
            }
        }
        if (!forException && !changeReport.getNoLongerMissingServices().isEmpty()) {
            msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportCorrected());
            for (Map.Entry<ServiceName, Boolean> entry : changeReport.getNoLongerMissingServices().entrySet()) {
                if (entry.getValue().booleanValue()) {
                    msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportAvailable(entry.getKey()));
                    continue;
                }
                msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportNoLongerRequired(entry.getKey()));
            }
        }
        Set<ServiceController<?>> set = failedSet = forException ? changeReport.getNewFailedControllers() : changeReport.getFailedControllers();
        if (!failedSet.isEmpty()) {
            msg.append(ControllerLogger.ROOT_LOGGER.serviceStatusReportFailed());
            for (ServiceController serviceController : failedSet) {
                msg.append("      ").append(serviceController.getName());
                StartException startException = serviceController.getStartException();
                if (startException != null) {
                    String exMsg = startException.getLocalizedMessage();
                    if (exMsg == null || exMsg.length() == 0) {
                        exMsg = startException.toString();
                    }
                    msg.append(": ").append(exMsg);
                }
                msg.append('\n');
            }
        }
        if (transitiveDownCount > 0) {
            msg.append(ControllerLogger.ROOT_LOGGER.servicesWithTransitiveUnavailability(transitiveDownCount));
        }
        return msg.toString();
    }

    private static String createDependentsString(Set<ServiceName> serviceNames) {
        if (serviceNames.size() <= 4) {
            return serviceNames.toString();
        }
        StringBuilder ret = new StringBuilder("[");
        Iterator<ServiceName> it = serviceNames.iterator();
        for (int count = 0; count < 4; ++count) {
            ServiceName val = it.next();
            ret.append(val);
            ret.append(", ");
        }
        ret.append(ControllerLogger.ROOT_LOGGER.andNMore(serviceNames.size() - 3));
        ret.append(" ]");
        return ret.toString();
    }

    static class MissingDependencyInfo {
        private final ServiceName serviceName;
        private final boolean unavailable;
        private final Set<ServiceName> dependents;

        private MissingDependencyInfo(ServiceName serviceName, boolean unavailable, Set<ServiceName> dependents) {
            this.serviceName = serviceName;
            this.unavailable = unavailable;
            this.dependents = dependents;
        }

        ServiceName getServiceName() {
            return this.serviceName;
        }

        boolean isUnavailable() {
            return this.unavailable;
        }

        Set<ServiceName> getDependents() {
            return Collections.unmodifiableSet(this.dependents);
        }
    }

    static class ContainerStateChangeReport {
        private final Map<ServiceName, MissingDependencyInfo> missingServices;
        private final Set<ServiceController<?>> failedControllers;
        private final Set<ServiceController<?>> newFailedControllers;
        private final Map<ServiceName, Boolean> noLongerMissingServices;

        private ContainerStateChangeReport(Map<ServiceName, MissingDependencyInfo> missingServices, Set<ServiceController<?>> failedControllers, Set<ServiceController<?>> newFailedControllers, Map<ServiceName, Boolean> noLongerMissingServices) {
            this.missingServices = missingServices;
            this.failedControllers = failedControllers;
            this.newFailedControllers = newFailedControllers;
            this.noLongerMissingServices = noLongerMissingServices;
        }

        final Set<ServiceController<?>> getFailedControllers() {
            return this.failedControllers;
        }

        final Set<ServiceController<?>> getNewFailedControllers() {
            return this.newFailedControllers;
        }

        Map<ServiceName, MissingDependencyInfo> getMissingServices() {
            return this.missingServices;
        }

        Map<ServiceName, Boolean> getNoLongerMissingServices() {
            return this.noLongerMissingServices;
        }

        boolean hasNewProblems() {
            return !this.newFailedControllers.isEmpty() || !this.missingServices.isEmpty();
        }
    }
}

