/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.AdvancedUserSearchResourceDefintion;
import org.jboss.as.domain.management.security.GroupToPrincipalResourceDefinition;
import org.jboss.as.domain.management.security.LdapResourceDefinition;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.PrincipalToGroupResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmChildAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmChildRemoveHandler;
import org.jboss.as.domain.management.security.SecurityRealmChildWriteAttributeHandler;
import org.jboss.as.domain.management.security.UserIsDnResourceDefintion;
import org.jboss.as.domain.management.security.UserSearchResourceDefintion;
import org.jboss.dmr.ModelNode;

public class LdapAuthorizationResourceDefinition
extends LdapResourceDefinition {
    private static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{CONNECTION};
    private static final LdapAuthorizationValidatingHandler VALIDATION_INSTANCE = new LdapAuthorizationValidatingHandler();
    static final LdapAuthorizationChildRemoveHandler REMOVE_INSTANCE = new LdapAuthorizationChildRemoveHandler();

    public LdapAuthorizationResourceDefinition() {
        super(PathElement.pathElement((String)"authorization", (String)"ldap"), ControllerResolver.getResolver((String[])new String[]{"core.management.security-realm.authorization.ldap"}), (OperationStepHandler)new LdapAuthorizationChildAddHandler(true, ATTRIBUTE_DEFINITIONS), (OperationStepHandler)new SecurityRealmChildRemoveHandler(true), OperationEntry.Flag.RESTART_RESOURCE_SERVICES, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel(UserIsDnResourceDefintion.INSTANCE);
        resourceRegistration.registerSubModel(UserSearchResourceDefintion.INSTANCE);
        resourceRegistration.registerSubModel(AdvancedUserSearchResourceDefintion.INSTANCE);
        resourceRegistration.registerSubModel(GroupToPrincipalResourceDefinition.INSTANCE);
        resourceRegistration.registerSubModel(PrincipalToGroupResourceDefinition.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        SecurityRealmChildWriteAttributeHandler handler = new SecurityRealmChildWriteAttributeHandler(ATTRIBUTE_DEFINITIONS);
        handler.registerAttributes(resourceRegistration);
    }

    private static ModelNode createOperation(ModelNode operationToValidate) {
        PathAddress pa = PathAddress.pathAddress((ModelNode)operationToValidate.require("address"));
        PathAddress realmPA = null;
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"authorization".equals(pe.getKey()) || !"ldap".equals(pe.getValue())) continue;
            realmPA = pa.subAddress(0, i + 1);
            break;
        }
        assert (realmPA != null) : "operationToValidate did not have an address that included a authorization=ldap";
        return Util.getEmptyOperation((String)"validate-authorization", (ModelNode)realmPA.toModelNode());
    }

    private static class LdapAuthorizationValidatingHandler
    implements OperationStepHandler {
        private LdapAuthorizationValidatingHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            Set children = resource.getChildrenNames("username-to-dn");
            if (children.size() > 1) {
                String realmName = ManagementUtil.getSecurityRealmName(operation);
                HashSet<String> invalid = new HashSet<String>(children);
                throw DomainManagementLogger.ROOT_LOGGER.multipleUsernameToDnConfigurationsDefined(realmName, invalid);
            }
            children = resource.getChildrenNames("group-search");
            if (children.size() == 0) {
                String realmName = ManagementUtil.getSecurityRealmName(operation);
                throw DomainManagementLogger.ROOT_LOGGER.noGroupSearchDefined(realmName);
            }
            if (children.size() > 1) {
                String realmName = ManagementUtil.getSecurityRealmName(operation);
                HashSet<String> invalid = new HashSet<String>(children);
                throw DomainManagementLogger.ROOT_LOGGER.multipleGroupSearchConfigurationsDefined(realmName, invalid);
            }
        }
    }

    static class LdapAuthorizationChildRemoveHandler
    implements OperationStepHandler {
        private LdapAuthorizationChildRemoveHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
            ModelNode validateOp = LdapAuthorizationResourceDefinition.createOperation(operation);
            context.addStep(validateOp, (OperationStepHandler)VALIDATION_INSTANCE, OperationContext.Stage.MODEL);
        }
    }

    static class LdapAuthorizationChildAddHandler
    extends SecurityRealmChildAddHandler {
        public LdapAuthorizationChildAddHandler(boolean validateAuthorization, AttributeDefinition[] attributeDefinitions) {
            super(false, validateAuthorization, attributeDefinitions);
        }

        @Override
        protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.updateModel(context, operation);
            ModelNode validateOp = LdapAuthorizationResourceDefinition.createOperation(operation);
            context.addStep(validateOp, (OperationStepHandler)VALIDATION_INSTANCE, OperationContext.Stage.MODEL);
        }
    }
}

