/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.domain.management.access.PrincipalResourceDefinition;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

public class PrincipalRemove
implements OperationStepHandler {
    private final WritableAuthorizerConfiguration authorizerConfiguration;
    private final WritableAuthorizerConfiguration.MatchType matchType;

    private PrincipalRemove(WritableAuthorizerConfiguration authorizerConfiguration, WritableAuthorizerConfiguration.MatchType matchType) {
        this.authorizerConfiguration = authorizerConfiguration;
        this.matchType = matchType;
    }

    public static OperationStepHandler createForInclude(WritableAuthorizerConfiguration authorizerConfiguration) {
        return new PrincipalRemove(authorizerConfiguration, WritableAuthorizerConfiguration.MatchType.INCLUDE);
    }

    public static OperationStepHandler createForExclude(WritableAuthorizerConfiguration authorizerConfiguration) {
        return new PrincipalRemove(authorizerConfiguration, WritableAuthorizerConfiguration.MatchType.EXCLUDE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        String roleName = RoleMappingResourceDefinition.getRoleName(operation);
        AuthorizerConfiguration.PrincipalType principalType = PrincipalResourceDefinition.getPrincipalType(context, model);
        String realm = PrincipalResourceDefinition.getRealm(context, model);
        String name = PrincipalResourceDefinition.getName(context, model);
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        if (this.matchType == WritableAuthorizerConfiguration.MatchType.INCLUDE) {
            RbacSanityCheckOperation.addOperation(context);
        }
        this.registerRuntimeRemove(context, roleName.toUpperCase(Locale.ENGLISH), principalType, name, realm);
        context.stepCompleted();
    }

    private void registerRuntimeRemove(OperationContext context, final String roleName, final AuthorizerConfiguration.PrincipalType principalType, final String name, final String realm) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (!PrincipalRemove.this.authorizerConfiguration.removeRoleMappingPrincipal(roleName, principalType, PrincipalRemove.this.matchType, name, realm)) {
                    context.restartRequired();
                    throw DomainManagementLogger.ROOT_LOGGER.inconsistentRbacRuntimeState();
                }
                PrincipalRemove.this.registerRollbackHandler(context, roleName, principalType, name, realm);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final String roleName, final AuthorizerConfiguration.PrincipalType principalType, final String name, final String realm) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!PrincipalRemove.this.authorizerConfiguration.addRoleMappingPrincipal(roleName, principalType, PrincipalRemove.this.matchType, name, realm, false)) {
                    context.restartRequired();
                }
            }
        });
    }
}

