/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.as.domain.management.access.ScopedRoleRequiredHandler;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

public class RoleMappingAdd
implements OperationStepHandler {
    private final WritableAuthorizerConfiguration authorizerConfiguration;
    private final boolean domainMode;

    private RoleMappingAdd(WritableAuthorizerConfiguration authorizerConfiguration, boolean domainMode) {
        this.authorizerConfiguration = authorizerConfiguration;
        this.domainMode = domainMode;
    }

    public static OperationStepHandler create(WritableAuthorizerConfiguration authorizerConfiguration, boolean domainMode) {
        return new RoleMappingAdd(authorizerConfiguration, domainMode);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String roleName = address.getLastElement().getValue();
        if (!this.authorizerConfiguration.getStandardRoles().contains(roleName)) {
            if (this.domainMode) {
                ScopedRoleRequiredHandler.addOperation(context, roleName);
            } else {
                throw DomainManagementLogger.ROOT_LOGGER.invalidRoleName(roleName);
            }
        }
        ModelNode model = resource.getModel();
        RoleMappingResourceDefinition.INCLUDE_ALL.validateAndSet(operation, model);
        this.registerRuntimeAdd(context, roleName.toUpperCase(Locale.ENGLISH));
        context.stepCompleted();
    }

    private void registerRuntimeAdd(OperationContext context, final String roleName) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (context.isBooting()) {
                    RoleMappingAdd.this.authorizerConfiguration.addRoleMappingImmediate(roleName);
                } else {
                    RoleMappingAdd.this.authorizerConfiguration.addRoleMapping(roleName);
                }
                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                boolean includeAll = RoleMappingResourceDefinition.INCLUDE_ALL.resolveModelAttribute(context, model).asBoolean();
                if (includeAll) {
                    RoleMappingAdd.this.authorizerConfiguration.setRoleMappingIncludeAll(roleName, includeAll);
                }
                RoleMappingAdd.this.registerRollbackHandler(context, roleName);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final String roleName) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                Object undoKey = RoleMappingAdd.this.authorizerConfiguration.removeRoleMapping(roleName);
                if (undoKey == null) {
                    context.restartRequired();
                }
            }
        });
    }
}

