/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.operations.validation.URIValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionAddHandler;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionPropertyResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionRemoveHandler;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LdapConnectionResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"ldap-connection");
    private static final String DEFAULT_INITIAL_CONTEXT = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    public static final SimpleAttributeDefinition SEARCH_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-dn", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    public static final SimpleAttributeDefinition SEARCH_CREDENTIAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-credential", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(0, Integer.MAX_VALUE, true, true))).build();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setAllowExpression(false)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    public static final SimpleAttributeDefinition INITIAL_CONTEXT_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("initial-context-factory", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("com.sun.jndi.ldap.LdapCtxFactory"))).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    public static final SimpleAttributeDefinition REFERRALS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("referrals", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode(ReferralHandling.IGNORE.toString()))).setValidator((ParameterValidator)new EnumValidator(ReferralHandling.class, true, true))).build();
    public static final StringListAttributeDefinition HANDLES_REFERRALS_FOR = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("handles-referrals-for").setAllowExpression(true)).setAllowNull(true)).setValidator((ParameterValidator)new URIValidator(true, true))).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && (list = resourceModel.get(attribute.getName()).asList()).size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (ModelNode child : list) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(child.asString());
                }
                writer.writeAttribute(Attribute.HANDLES_REFERRALS_FOR.getLocalName(), sb.toString());
            }
        }
    })).build();
    public static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{URL, SEARCH_DN, SEARCH_CREDENTIAL, SECURITY_REALM, INITIAL_CONTEXT_FACTORY, REFERRALS, HANDLES_REFERRALS_FOR};

    private LdapConnectionResourceDefinition(OperationStepHandler add, OperationStepHandler remove) {
        super(RESOURCE_PATH, ControllerResolver.getResolver((String[])new String[]{"core.management.ldap-connection"}), add, remove, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
    }

    public static LdapConnectionResourceDefinition newInstance() {
        LdapConnectionAddHandler add = LdapConnectionAddHandler.newInstance();
        LdapConnectionRemoveHandler remove = LdapConnectionRemoveHandler.newInstance(add);
        return new LdapConnectionResourceDefinition((OperationStepHandler)add, (OperationStepHandler)remove);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel(LdapConnectionPropertyResourceDefinition.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        LdapConnectionWriteAttributeHandler writeHandler = new LdapConnectionWriteAttributeHandler();
        writeHandler.registerAttributes(resourceRegistration);
    }

    public static enum ReferralHandling {
        FOLLOW("follow"),
        IGNORE("ignore"),
        THROW("throw");

        private final String value;

        private ReferralHandling(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

