/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.SecurityRealmAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class SecurityRealmRemoveHandler
implements OperationStepHandler {
    public static final SecurityRealmRemoveHandler INSTANCE = new SecurityRealmRemoveHandler();

    private SecurityRealmRemoveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final boolean reloadRequired = ManagementUtil.isSecurityRealmReloadRequired(context, operation);
                final String realmName = ManagementUtil.getSecurityRealmName(operation);
                if (reloadRequired) {
                    context.reloadRequired();
                } else {
                    SecurityRealmRemoveHandler.this.removeServices(context, realmName, model);
                }
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        if (reloadRequired) {
                            context.revertReloadRequired();
                        } else {
                            SecurityRealmRemoveHandler.this.recoverServices(context, realmName, model);
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void removeServices(OperationContext context, String realmName, ModelNode model) throws OperationFailedException {
        ServiceName realmServiceName = SecurityRealm.ServiceUtil.createServiceName(realmName);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        List allNames = serviceRegistry.getServiceNames();
        for (ServiceName current : allNames) {
            if (!realmServiceName.isParentOf(current)) continue;
            context.removeService(current);
        }
    }

    protected void recoverServices(OperationContext context, String realmName, ModelNode model) {
        try {
            SecurityRealmAddHandler.INSTANCE.installServices(context, realmName, model, null, null);
        }
        catch (OperationFailedException e) {
            throw ControllerLogger.ROOT_LOGGER.failedToRecoverServices(e);
        }
    }
}

