/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerRegistry;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class LdapConnectionAddHandler
extends AbstractAddStepHandler {
    private final LdapConnectionManagerRegistry connectionManagerRegistry = new LdapConnectionManagerRegistry();

    static LdapConnectionAddHandler newInstance() {
        return new LdapConnectionAddHandler();
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        LdapConnectionManagerService connectionManagerService = new LdapConnectionManagerService(name, this.connectionManagerRegistry);
        LdapConnectionAddHandler.updateRuntime(context, model, connectionManagerService);
        ServiceBuilder sb = serviceTarget.addService(LdapConnectionManagerService.ServiceUtil.createServiceName(name), (Service)connectionManagerService).setInitialMode(ServiceController.Mode.ACTIVE);
        ModelNode securityRealm = LdapConnectionResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        if (securityRealm.isDefined()) {
            String realmName = securityRealm.asString();
            SSLContextService.ServiceUtil.addDependency(sb, connectionManagerService.getFullSSLContextInjector(), SecurityRealm.ServiceUtil.createServiceName(realmName), false);
            SSLContextService.ServiceUtil.addDependency(sb, connectionManagerService.getTrustOnlySSLContextInjector(), SecurityRealm.ServiceUtil.createServiceName(realmName), true);
        }
        sb.install();
    }

    static LdapConnectionManagerService.Config updateRuntime(OperationContext context, ModelNode model, LdapConnectionManagerService connectionManagerService) throws OperationFailedException {
        Set<URI> handlesReferralsForSet;
        String initialContextFactory = LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.resolveModelAttribute(context, model).asString();
        String url = LdapConnectionResourceDefinition.URL.resolveModelAttribute(context, model).asString();
        ModelNode searchDnNode = LdapConnectionResourceDefinition.SEARCH_DN.resolveModelAttribute(context, model);
        String searchDn = searchDnNode.isDefined() ? searchDnNode.asString() : null;
        ModelNode searchCredentialNode = LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.resolveModelAttribute(context, model);
        String searchCredential = searchCredentialNode.isDefined() ? searchCredentialNode.asString() : null;
        LdapConnectionResourceDefinition.ReferralHandling referralHandling = LdapConnectionResourceDefinition.ReferralHandling.valueOf(LdapConnectionResourceDefinition.REFERRALS.resolveModelAttribute(context, model).asString());
        ModelNode handlesReferralsFor = LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR.resolveModelAttribute(context, model);
        if (handlesReferralsFor.isDefined()) {
            List list = handlesReferralsFor.asList();
            handlesReferralsForSet = new HashSet(list.size());
            for (ModelNode current : list) {
                try {
                    handlesReferralsForSet.add(new URI(current.asString()));
                }
                catch (URISyntaxException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
        } else {
            handlesReferralsForSet = Collections.emptySet();
        }
        return connectionManagerService.setConfiguration(initialContextFactory, url, searchDn, searchCredential, referralHandling, handlesReferralsForSet);
    }
}

