/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.WrapperSSLContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SSLContextService
implements Service<SSLContext> {
    private InjectedValue<KeyManager[]> injectedKeyManagers = new InjectedValue();
    private InjectedValue<TrustManager[]> injectedtrustManagers = new InjectedValue();
    private volatile String protocol;
    private volatile Set<String> enabledCipherSuites;
    private volatile Set<String> enabledProtocols;
    private volatile SSLContext theSSLContext;

    SSLContextService(String protocol, Set<String> enabledCipherSuites, Set<String> enabledProtocols) {
        this.protocol = protocol;
        this.enabledCipherSuites = enabledCipherSuites;
        this.enabledProtocols = enabledProtocols;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void start(StartContext context) throws StartException {
        KeyManager[] keyManagers = (KeyManager[])this.injectedKeyManagers.getOptionalValue();
        TrustManager[] trustManagers = (TrustManager[])this.injectedtrustManagers.getOptionalValue();
        try {
            SSLContext sslContext = SSLContext.getInstance(this.protocol);
            sslContext.init(keyManagers, trustManagers, null);
            if (!this.enabledCipherSuites.isEmpty() || !this.enabledProtocols.isEmpty()) {
                String[] commonProtocols;
                String[] commonCiphers;
                SSLParameters parameters = sslContext.getSupportedSSLParameters();
                if (this.enabledCipherSuites.isEmpty()) {
                    commonCiphers = new String[]{};
                } else {
                    commonCiphers = this.calculateCommon(parameters.getCipherSuites(), this.enabledCipherSuites);
                    if (commonCiphers.length == 0) {
                        throw DomainManagementLogger.ROOT_LOGGER.noCipherSuitesInCommon(Arrays.asList(parameters.getCipherSuites()).toString(), this.enabledCipherSuites.toString());
                    }
                }
                if (this.enabledProtocols.isEmpty()) {
                    commonProtocols = new String[]{};
                } else {
                    commonProtocols = this.calculateCommon(parameters.getProtocols(), this.enabledProtocols);
                    if (commonProtocols.length == 0) {
                        throw DomainManagementLogger.ROOT_LOGGER.noProtocolsInCommon(Arrays.asList(parameters.getProtocols()).toString(), this.enabledProtocols.toString());
                    }
                }
                sslContext = new WrapperSSLContext(sslContext, commonCiphers, commonProtocols);
            }
            this.theSSLContext = sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (KeyManagementException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
    }

    private String[] calculateCommon(String[] supported, Set<String> configured) {
        ArrayList<String> matched = new ArrayList<String>();
        for (String current : supported) {
            if (!configured.contains(current)) continue;
            matched.add(current);
        }
        return matched.toArray(new String[matched.size()]);
    }

    public void stop(StopContext context) {
        this.theSSLContext = null;
    }

    public SSLContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.theSSLContext;
    }

    public InjectedValue<KeyManager[]> getKeyManagerInjector() {
        return this.injectedKeyManagers;
    }

    public InjectedValue<TrustManager[]> getTrustManagerInjector() {
        return this.injectedtrustManagers;
    }

    public static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "ssl-context";
        private static final String TRUST_ONLY_SERVICE_SUFFIX = "ssl-context-trust-only";

        public static ServiceName createServiceName(ServiceName parentService, boolean trustOnly) {
            return parentService.append(new String[]{trustOnly ? TRUST_ONLY_SERVICE_SUFFIX : SERVICE_SUFFIX});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<SSLContext> injector, ServiceName parentService, boolean trustOnly) {
            sb.addDependency(ServiceUtil.createServiceName(parentService, trustOnly), SSLContext.class, injector);
            return sb;
        }
    }
}

