/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

abstract class AbstractKeyManagerService
implements Service<AbstractKeyManagerService> {
    private volatile char[] keystorePassword;
    private volatile char[] keyPassword;
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> keyCredentialSourceSupplier = new InjectedValue();
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> keystoreCredentialSourceSupplier = new InjectedValue();

    AbstractKeyManagerService(char[] keystorePassword, char[] keyPassword) {
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.createKeyManagers(true);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
    }

    public void stop(StopContext context) {
    }

    public AbstractKeyManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public KeyManager[] getKeyManagers() {
        try {
            return this.createKeyManagers(false);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean isLazy();

    protected KeyManager[] createKeyManagers(boolean startup) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyStore keyStore = this.loadKeyStore(startup);
        if (keyStore == null && startup) {
            return null;
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keyPassword == null ? this.keystorePassword : this.keyPassword);
        return keyManagerFactory.getKeyManagers();
    }

    protected abstract KeyStore loadKeyStore(boolean var1);

    Injector<ExceptionSupplier<CredentialSource, Exception>> getKeyCredentialSourceSupplierInjector() {
        return this.keyCredentialSourceSupplier;
    }

    Injector<ExceptionSupplier<CredentialSource, Exception>> getKeystoreCredentialSourceSupplierInjector() {
        return this.keystoreCredentialSourceSupplier;
    }

    protected char[] resolveKeyPassword() {
        return this.resolvePassword((ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)this.keyCredentialSourceSupplier.getOptionalValue()), this.keyPassword);
    }

    protected char[] resolveKeystorePassword() {
        return this.resolvePassword((ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)this.keystoreCredentialSourceSupplier.getOptionalValue()), this.keystorePassword);
    }

    private char[] resolvePassword(ExceptionSupplier<CredentialSource, Exception> sourceSupplier, char[] legacyPassword) {
        try {
            if (sourceSupplier == null) {
                return legacyPassword;
            }
            CredentialSource cs = (CredentialSource)sourceSupplier.get();
            if (cs == null) {
                return legacyPassword;
            }
            PasswordCredential credential = (PasswordCredential)cs.getCredential(PasswordCredential.class);
            if (credential == null) {
                return legacyPassword;
            }
            ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
            if (password == null) {
                return legacyPassword;
            }
            return password.getPassword();
        }
        catch (Exception ex) {
            return legacyPassword;
        }
    }

    static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "key-manager";

        ServiceUtil() {
        }

        public static ServiceName createServiceName(ServiceName parentService) {
            return parentService.append(new String[]{SERVICE_SUFFIX});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<AbstractKeyManagerService> injector, ServiceName parentService) {
            sb.addDependency(ServiceUtil.createServiceName(parentService), AbstractKeyManagerService.class, injector);
            return sb;
        }
    }
}

