/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;

public class UserDomainCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    private static final String SERVICE_SUFFIX = "users";
    private final String realm;
    private volatile ModelNode userDomain;
    private final InjectedValue<Map<String, ExceptionSupplier<CredentialSource, Exception>>> credentialSourceSupplier = new InjectedValue();

    public UserDomainCallbackHandler(String realm, ModelNode userDomain) {
        this.realm = realm;
        this.setUserDomain(userDomain);
    }

    void setUserDomain(ModelNode userDomain) {
        this.userDomain = userDomain == null || !userDomain.isDefined() ? new ModelNode().setEmptyObject() : userDomain.clone();
    }

    Injector<Map<String, ExceptionSupplier<CredentialSource, Exception>>> getCredentialSourceSupplierInjector() {
        return this.credentialSourceSupplier;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.DIGEST;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.singleton(AuthMechanism.PLAIN);
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.singletonMap("org.jboss.as.domain.management.digest.plain_text", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new SecurityRealmImpl();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public UserDomainCallbackHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        ModelNode userMap = this.userDomain;
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        ModelNode user = null;
        ExceptionSupplier userCredentialSourceSupplier = null;
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                if (userMap.get("user").hasDefined(userName)) {
                    user = userMap.get(new String[]{"user", userName});
                }
                if (this.credentialSourceSupplier.getOptionalValue() == null || !((Map)this.credentialSourceSupplier.getValue()).containsKey(userName)) continue;
                userCredentialSourceSupplier = (ExceptionSupplier)((Map)this.credentialSourceSupplier.getValue()).get(userName);
                continue;
            }
            if (current instanceof PasswordCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw DomainManagementLogger.ROOT_LOGGER.invalidRealm(realm, this.realm);
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : toRespondTo) {
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback acb = (AuthorizeCallback)current;
                boolean authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                }
                acb.setAuthorized(authorized);
                continue;
            }
            if (!(current instanceof PasswordCallback)) continue;
            if (user == null) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found.", userName);
                throw new UserNotFoundException(userName);
            }
            char[] password = new char[]{};
            if (user.hasDefined("password")) {
                password = user.require("password").asString().toCharArray();
            }
            ((PasswordCallback)current).setPassword(this.resolvePassword(userCredentialSourceSupplier, password));
        }
    }

    private char[] resolvePassword(ExceptionSupplier<CredentialSource, Exception> userCredentialSourceSupplier, char[] password) {
        try {
            ClearPassword clearPassword;
            PasswordCredential credential;
            CredentialSource cs;
            if (userCredentialSourceSupplier != null && (cs = (CredentialSource)userCredentialSourceSupplier.get()) != null && (credential = (PasswordCredential)cs.getCredential(PasswordCredential.class)) != null && (clearPassword = (ClearPassword)credential.getPassword(ClearPassword.class)) != null) {
                return clearPassword.getPassword();
            }
        }
        catch (Exception ex) {
            return password;
        }
        return password;
    }

    private static PasswordFactory getPasswordFactory(String algorithm) {
        try {
            return PasswordFactory.getInstance((String)algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{UserDomainCallbackHandler.SERVICE_SUFFIX});
        }
    }

    private class SecurityRealmImpl
    implements SecurityRealm {
        private SecurityRealmImpl() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            ModelNode userMap = UserDomainCallbackHandler.this.userDomain;
            String name = principal.getName();
            ModelNode user = userMap.get("user").hasDefined(name) ? userMap.get(new String[]{"user", name}) : null;
            return new RealmIdentityImpl(principal, user);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return PasswordCredential.class.isAssignableFrom(credentialType) && (algorithmName == null || algorithmName.equals("clear") || algorithmName.equals("digest-md5")) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        private class RealmIdentityImpl
        implements RealmIdentity {
            private final Principal principal;
            private final ModelNode user;

            private RealmIdentityImpl(Principal principal, ModelNode user) {
                this.principal = principal;
                this.user = user;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getCredentialAcquireSupport(credentialType, algorithmName);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return this.getCredential(credentialType, null);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
                ClearPasswordSpec passwordSpec;
                PasswordFactory passwordFactory;
                boolean clear;
                if (this.user == null || !PasswordCredential.class.isAssignableFrom(credentialType)) {
                    return null;
                }
                if (algorithmName == null || "clear".equals(algorithmName)) {
                    clear = true;
                } else if ("digest-md5".equals(algorithmName)) {
                    clear = false;
                } else {
                    return null;
                }
                String password = this.user.require("password").asString();
                if (clear) {
                    passwordFactory = UserDomainCallbackHandler.getPasswordFactory("clear");
                    passwordSpec = new ClearPasswordSpec(password.toCharArray());
                } else {
                    passwordFactory = UserDomainCallbackHandler.getPasswordFactory("digest-md5");
                    DigestPasswordAlgorithmSpec algorithmParameterSpec = new DigestPasswordAlgorithmSpec(this.principal.getName(), UserDomainCallbackHandler.this.realm);
                    passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)algorithmParameterSpec);
                }
                try {
                    return (C)((Credential)credentialType.cast(new PasswordCredential(passwordFactory.generatePassword((KeySpec)passwordSpec))));
                }
                catch (InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                if (this.user == null || !(evidence instanceof PasswordGuessEvidence)) {
                    return false;
                }
                char[] guess = ((PasswordGuessEvidence)evidence).getGuess();
                String password = this.user.require("password").asString();
                PasswordFactory passwordFactory = UserDomainCallbackHandler.getPasswordFactory("clear");
                ClearPasswordSpec passwordSpec = new ClearPasswordSpec(password.toCharArray());
                try {
                    Password actualPassword = passwordFactory.generatePassword((KeySpec)passwordSpec);
                    return passwordFactory.verify(actualPassword, guess);
                }
                catch (IllegalStateException | InvalidKeyException | InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            public boolean exists() throws RealmUnavailableException {
                return this.user != null;
            }
        }
    }
}

