package org.wildfly.core.embedded.logging;

import org.jboss.vfs.VirtualFile;
import java.lang.IllegalStateException;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import java.io.Serializable;
import org.jboss.modules.ModuleLoader;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import java.lang.NoSuchMethodException;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import java.io.File;
import java.lang.ClassNotFoundException;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-04-23T11:24:00+0100")
public class EmbeddedLogger_$logger extends DelegatingBasicLogger implements EmbeddedLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EmbeddedLogger_$logger.class.getName();
    public EmbeddedLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void cannotCloseFile(final Throwable cause, final VirtualFile file) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, cannotCloseFile$str(), file);
    }
    private static final String cannotCloseFile = "WFLYEMB0001: Could not close handle to mounted %s";
    protected String cannotCloseFile$str() {
        return cannotCloseFile;
    }
    @Override
    public final void cannotLoadClassFile(final Throwable cause, final VirtualFile file) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, cannotLoadClassFile$str(), file);
    }
    private static final String cannotLoadClassFile = "WFLYEMB0002: Could not load class file %s";
    protected String cannotLoadClassFile$str() {
        return cannotLoadClassFile;
    }
    @Override
    public final void errorClosingFile(final Throwable cause, final VirtualFile file) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, errorClosingFile$str(), file);
    }
    private static final String errorClosingFile = "WFLYEMB0003: Exception closing file %s";
    protected String errorClosingFile$str() {
        return errorClosingFile;
    }
    @Override
    public final void failedToUndeploy(final Throwable cause, final File file) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, failedToUndeploy$str(), file);
    }
    private static final String failedToUndeploy = "WFLYEMB0004: Failed to undeploy %s";
    protected String failedToUndeploy$str() {
        return failedToUndeploy;
    }
    @Override
    public final void fileNotFound(final VirtualFile file) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, fileNotFound$str(), file);
    }
    private static final String fileNotFound = "WFLYEMB0005: File on ClassPath could not be found: %s";
    protected String fileNotFound$str() {
        return fileNotFound;
    }
    @Override
    public final void skippingUnknownFileType(final VirtualFile file) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, skippingUnknownFileType$str(), file);
    }
    private static final String skippingUnknownFileType = "WFLYEMB0006: Encountered unknown file type, skipping: %s";
    protected String skippingUnknownFileType$str() {
        return skippingUnknownFileType;
    }
    private static final String cannotMountFile = "WFLYEMB0007: Could not mount file '%s'";
    protected String cannotMountFile$str() {
        return cannotMountFile;
    }
    @Override
    public final RuntimeException cannotMountFile(final Throwable cause, final String fileName) {
        final RuntimeException result = new RuntimeException(String.format(cannotMountFile$str(), fileName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReadContent = "WFLYEMB0008: Could not read contents of %s";
    protected String cannotReadContent$str() {
        return cannotReadContent;
    }
    @Override
    public final RuntimeException cannotReadContent(final Throwable cause, final VirtualFile file) {
        final RuntimeException result = new RuntimeException(String.format(cannotReadContent$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exclusionValuesRequired = "WFLYEMB0009: One or more exclusion values must be specified";
    protected String exclusionValuesRequired$str() {
        return exclusionValuesRequired;
    }
    @Override
    public final IllegalArgumentException exclusionValuesRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(exclusionValuesRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidJBossHome = "WFLYEMB0011: Invalid JBoss home directory: %s";
    protected String invalidJBossHome$str() {
        return invalidJBossHome;
    }
    @Override
    public final IllegalStateException invalidJBossHome(final String jbossHome) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidJBossHome$str(), jbossHome));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidModulePath = "WFLYEMB0012: Invalid module path: %s";
    protected String invalidModulePath$str() {
        return invalidModulePath;
    }
    @Override
    public final IllegalArgumentException invalidModulePath(final String file) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidModulePath$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidModuleType = "WFLYEMB0013: %s was not of type File[], File, String[] or String, but of type %s";
    protected String invalidModuleType$str() {
        return invalidModuleType;
    }
    @Override
    public final RuntimeException invalidModuleType(final String moduleName, final Class<? extends Object> type) {
        final RuntimeException result = new RuntimeException(String.format(invalidModuleType$str(), moduleName, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moduleLoaderError = "WFLYEMB0014: Cannot load module %s from: %s";
    protected String moduleLoaderError$str() {
        return moduleLoaderError;
    }
    @Override
    public final RuntimeException moduleLoaderError(final Throwable cause, final String msg, final ModuleLoader moduleLoader) {
        final RuntimeException result = new RuntimeException(String.format(moduleLoaderError$str(), msg, moduleLoader), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String systemPropertyNotFound = "WFLYEMB0016: Cannot find system property: %s";
    protected String systemPropertyNotFound$str() {
        return systemPropertyNotFound;
    }
    @Override
    public final IllegalStateException systemPropertyNotFound(final String key) {
        final IllegalStateException result = new IllegalStateException(String.format(systemPropertyNotFound$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadEmbeddedServerFactory = "WFLYEMB0017: Cannot load embedded server factory: %s";
    protected String cannotLoadEmbeddedServerFactory$str() {
        return cannotLoadEmbeddedServerFactory;
    }
    @Override
    public final IllegalStateException cannotLoadEmbeddedServerFactory(final ClassNotFoundException cause, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(cannotLoadEmbeddedServerFactory$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotGetReflectiveMethod = "WFLYEMB0018: Cannot get reflective method '%s' for: %s";
    protected String cannotGetReflectiveMethod$str() {
        return cannotGetReflectiveMethod;
    }
    @Override
    public final IllegalStateException cannotGetReflectiveMethod(final NoSuchMethodException cause, final String method, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(cannotGetReflectiveMethod$str(), method, className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateStandaloneServer = "WFLYEMB0019: Cannot create standalone server using factory: %s";
    protected String cannotCreateStandaloneServer$str() {
        return cannotCreateStandaloneServer;
    }
    @Override
    public final IllegalStateException cannotCreateStandaloneServer(final Throwable cause, final Method createMethod) {
        final IllegalStateException result = new IllegalStateException(String.format(cannotCreateStandaloneServer$str(), createMethod), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSetupEmbeddedServer = "WFLYEMB0020: Cannot setup embedded process";
    protected String cannotSetupEmbeddedServer$str() {
        return cannotSetupEmbeddedServer;
    }
    @Override
    public final IllegalStateException cannotSetupEmbeddedServer(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(cannotSetupEmbeddedServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotStartEmbeddedServer = "WFLYEMB0021: Cannot start embedded process";
    protected String cannotStartEmbeddedServer$str() {
        return cannotStartEmbeddedServer;
    }
    @Override
    public final EmbeddedProcessStartException cannotStartEmbeddedServer(final Throwable cause) {
        final EmbeddedProcessStartException result = new EmbeddedProcessStartException(String.format(cannotStartEmbeddedServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInvokeStandaloneServer = "WFLYEMB0022: Cannot invoke '%s' on embedded process";
    protected String cannotInvokeStandaloneServer$str() {
        return cannotInvokeStandaloneServer;
    }
    @Override
    public final IllegalStateException cannotInvokeStandaloneServer(final Throwable cause, final String methodName) {
        final IllegalStateException result = new IllegalStateException(String.format(cannotInvokeStandaloneServer$str(), methodName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String processIsStopping = "WFLYEMB0023: The embedded server is stopping and invocations on the ModelControllerClient are not available";
    protected String processIsStopping$str() {
        return processIsStopping;
    }
    @Override
    public final IllegalStateException processIsStopping() {
        final IllegalStateException result = new IllegalStateException(String.format(processIsStopping$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String processIsReloading = "WFLYEMB0024: The embedded server is reloading and invocations on the ModelControllerClient are not yet available";
    protected String processIsReloading$str() {
        return processIsReloading;
    }
    @Override
    public final IllegalStateException processIsReloading() {
        final IllegalStateException result = new IllegalStateException(String.format(processIsReloading$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotConfigureBootLogging(final File loggingProperties) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, cannotConfigureBootLogging$str(), loggingProperties);
    }
    private static final String cannotConfigureBootLogging = "WFLYEMB0025: Unable to configure embedded server logging from %s";
    protected String cannotConfigureBootLogging$str() {
        return cannotConfigureBootLogging;
    }
    private static final String cannotCreateHostController = "WFLYEMB0026: Cannot create host controller using factory: %s";
    protected String cannotCreateHostController$str() {
        return cannotCreateHostController;
    }
    @Override
    public final IllegalStateException cannotCreateHostController(final Throwable cause, final Method createMethod) {
        final IllegalStateException result = new IllegalStateException(String.format(cannotCreateHostController$str(), createMethod), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String processIsStopped = "WFLYEMB0027: The embedded server is stopped and invocations on the ModelControllerClient are not available";
    protected String processIsStopped$str() {
        return processIsStopped;
    }
    @Override
    public final IllegalStateException processIsStopped() {
        final IllegalStateException result = new IllegalStateException(String.format(processIsStopped$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
