/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Map;
import java.util.Properties;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.embedded.ChainedContext;
import org.wildfly.core.embedded.Configuration;
import org.wildfly.core.embedded.EmbeddedManagedProcessImpl;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.HostControllerSystemPropertyContext;
import org.wildfly.core.embedded.LoggerContext;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.StandaloneSystemPropertyContext;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

public class EmbeddedProcessFactory {
    private static final String MODULE_ID_EMBEDDED = "org.wildfly.embedded";
    private static final String MODULE_ID_VFS = "org.jboss.vfs";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    static final String[] DOMAIN_KEYS = new String[]{"jboss.domain.base.dir", "jboss.domain.config.dir", "jboss.domain.deployment.dir", "jboss.domain.temp.dir", "jboss.domain.log.dir", "jboss.domain.config.dir"};
    private static final String JBOSS_MODULES_DIR_NAME = "modules";
    private static final String HOST_FACTORY = "org.wildfly.core.embedded.EmbeddedHostControllerFactory";
    private static final String SERVER_FACTORY = "org.wildfly.core.embedded.EmbeddedStandaloneServerFactory";

    EmbeddedProcessFactory() {
    }

    public static StandaloneServer createStandaloneServer(String jbossHomePath, String modulePath, String ... systemPackages) {
        return EmbeddedProcessFactory.createStandaloneServer(jbossHomePath, modulePath, systemPackages, null);
    }

    public static StandaloneServer createStandaloneServer(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        return EmbeddedProcessFactory.createStandaloneServer(Configuration.Builder.of(jbossHomeDir).setModulePath(modulePath).setSystemPackages(systemPackages).setCommandArguments(cmdargs).build());
    }

    public static StandaloneServer createStandaloneServer(ModuleLoader moduleLoader, File jbossHomeDir, String ... cmdargs) {
        return EmbeddedProcessFactory.createStandaloneServer(Configuration.Builder.of(jbossHomeDir).setCommandArguments(cmdargs).setModuleLoader(moduleLoader).build());
    }

    public static StandaloneServer createStandaloneServer(Configuration configuration) {
        Method createServerMethod;
        Class standaloneServerClass;
        Class embeddedServerFactoryClass;
        Module embeddedModule;
        ChainedContext context = new ChainedContext();
        context.add(new StandaloneSystemPropertyContext(configuration.getJBossHome()));
        context.add(new LoggerContext(configuration.getModuleLoader()));
        ModuleLoader moduleLoader = configuration.getModuleLoader();
        EmbeddedProcessFactory.setupVfsModule(moduleLoader);
        try {
            embeddedModule = moduleLoader.loadModule(MODULE_ID_EMBEDDED);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedServerFactoryClass = embeddedModuleCL.loadClass(SERVER_FACTORY);
            standaloneServerClass = embeddedModuleCL.loadClass(StandaloneServer.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, SERVER_FACTORY);
        }
        try {
            createServerMethod = embeddedServerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedServerFactoryClass.getName());
        }
        Object standaloneServerImpl = EmbeddedProcessFactory.createManagedProcess(ProcessType.STANDALONE_SERVER, createServerMethod, configuration);
        return new EmbeddedManagedProcessImpl(standaloneServerClass, standaloneServerImpl, context);
    }

    public static HostController createHostController(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        return EmbeddedProcessFactory.createHostController(Configuration.Builder.of(jbossHomeDir).setModulePath(modulePath).setSystemPackages(systemPackages).setCommandArguments(cmdargs).build());
    }

    public static HostController createHostController(ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        return EmbeddedProcessFactory.createHostController(Configuration.Builder.of(jbossHomeDir).setModuleLoader(moduleLoader).setCommandArguments(cmdargs).build());
    }

    public static HostController createHostController(Configuration configuration) {
        Method createServerMethod;
        Class hostControllerClass;
        Class embeddedHostControllerFactoryClass;
        Module embeddedModule;
        ChainedContext context = new ChainedContext();
        context.add(new HostControllerSystemPropertyContext(configuration.getJBossHome()));
        context.add(new LoggerContext(configuration.getModuleLoader()));
        ModuleLoader moduleLoader = configuration.getModuleLoader();
        EmbeddedProcessFactory.setupVfsModule(moduleLoader);
        try {
            embeddedModule = moduleLoader.loadModule(MODULE_ID_EMBEDDED);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedHostControllerFactoryClass = embeddedModuleCL.loadClass(HOST_FACTORY);
            hostControllerClass = embeddedModuleCL.loadClass(HostController.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, HOST_FACTORY);
        }
        try {
            createServerMethod = embeddedHostControllerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedHostControllerFactoryClass.getName());
        }
        Object hostControllerImpl = EmbeddedProcessFactory.createManagedProcess(ProcessType.HOST_CONTROLLER, createServerMethod, configuration);
        return new EmbeddedManagedProcessImpl(hostControllerClass, hostControllerImpl, context);
    }

    private static void setupVfsModule(ModuleLoader moduleLoader) {
        Module vfsModule;
        ModuleIdentifier vfsModuleID = ModuleIdentifier.create((String)MODULE_ID_VFS);
        try {
            vfsModule = moduleLoader.loadModule(vfsModuleID);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_VFS, moduleLoader);
        }
        Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
    }

    private static Object createManagedProcess(ProcessType embeddedType, Method createServerMethod, Configuration configuration) {
        Object serverImpl;
        try {
            Properties sysprops = EmbeddedProcessFactory.getSystemPropertiesPrivileged();
            Map<String, String> sysenv = EmbeddedProcessFactory.getSystemEnvironmentPrivileged();
            String[] args = configuration.getCommandArguments();
            serverImpl = createServerMethod.invoke(null, configuration.getJBossHome().toFile(), configuration.getModuleLoader(), sysprops, sysenv, args);
        }
        catch (InvocationTargetException ite) {
            if (embeddedType == ProcessType.HOST_CONTROLLER) {
                throw EmbeddedLogger.ROOT_LOGGER.cannotCreateHostController(ite.getCause(), createServerMethod);
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(ite.getCause(), createServerMethod);
        }
        catch (IllegalAccessException iae) {
            if (embeddedType == ProcessType.HOST_CONTROLLER) {
                throw EmbeddedLogger.ROOT_LOGGER.cannotCreateHostController(iae, createServerMethod);
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(iae, createServerMethod);
        }
        return serverImpl;
    }

    private static Properties getSystemPropertiesPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(System::getProperties);
    }

    private static Map<String, String> getSystemEnvironmentPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getenv();
        }
        return AccessController.doPrivileged(System::getenv);
    }

    static enum ProcessType {
        STANDALONE_SERVER,
        HOST_CONTROLLER;

    }
}

