/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.domain.controller.operations.DomainServerLifecycleHandlers;
import org.jboss.as.domain.controller.resources.ProfileResourceDefinition;
import org.jboss.as.domain.controller.transformers.ManagementTransformers;
import org.jboss.as.domain.controller.transformers.ServerGroupTransformers;
import org.jboss.as.domain.controller.transformers.SocketBindingGroupTransformers;

public class DomainTransformers {
    static final ModelVersion IGNORED_SUBSYSTEMS = ModelVersion.create((int)-1);
    static final ModelVersion VERSION_1_5 = ModelVersion.create((int)1, (int)5, (int)0);
    static final ModelVersion VERSION_1_6 = ModelVersion.create((int)1, (int)6, (int)0);
    static final ModelVersion VERSION_1_7 = ModelVersion.create((int)1, (int)7, (int)0);
    static final ModelVersion VERSION_2_0 = ModelVersion.create((int)2, (int)0, (int)0);
    static final ModelVersion VERSION_2_1 = ModelVersion.create((int)2, (int)1, (int)0);
    static final ModelVersion CURRENT = ModelVersion.create((int)4, (int)0, (int)0);

    public static void initializeDomainRegistry(TransformerRegistry registry) {
        DomainTransformers.initializeChainedDomainRegistry(registry);
    }

    private static void initializeChainedDomainRegistry(TransformerRegistry registry) {
        DomainTransformers.registerRootTransformers(registry);
        DomainTransformers.registerChainedManagementTransformers(registry, CURRENT);
        DomainTransformers.registerChainedServerGroupTransformers(registry, CURRENT);
        DomainTransformers.registerProfileTransformers(registry, CURRENT);
        DomainTransformers.registerSocketBindingGroupTransformers(registry, CURRENT);
    }

    private static void registerRootTransformers(TransformerRegistry registry) {
        ModelVersion[] versions;
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createInstance(null);
        DomainServerLifecycleHandlers.registerServerLifeCycleOperationsTransformers(builder);
        for (ModelVersion version : versions = new ModelVersion[]{VERSION_1_5, VERSION_1_6, VERSION_1_7}) {
            TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)version);
            TransformationDescription.Tools.register((TransformationDescription)builder.build(), (TransformersSubRegistration)domain);
        }
    }

    private static void registerChainedManagementTransformers(TransformerRegistry registry, ModelVersion currentVersion) {
        ChainedTransformationDescriptionBuilder builder = ManagementTransformers.buildTransformerChain(currentVersion);
        DomainTransformers.registerChainedTransformer(registry, builder, VERSION_1_5, VERSION_1_6, VERSION_1_7);
    }

    private static void registerChainedServerGroupTransformers(TransformerRegistry registry, ModelVersion currentVersion) {
        ChainedTransformationDescriptionBuilder builder = ServerGroupTransformers.buildTransformerChain(currentVersion);
        DomainTransformers.registerChainedTransformer(registry, builder, VERSION_1_5, VERSION_1_6, VERSION_1_7);
    }

    private static void registerProfileTransformers(TransformerRegistry registry, ModelVersion currentVersion) {
        ModelVersion[] versions;
        for (ModelVersion version : versions = new ModelVersion[]{VERSION_1_7, VERSION_1_6, VERSION_1_5}) {
            ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createInstance((PathElement)ProfileResourceDefinition.PATH);
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ProfileResourceDefinition.INCLUDES})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ProfileResourceDefinition.INCLUDES})).end();
            TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)version);
            TransformationDescription.Tools.register((TransformationDescription)builder.build(), (TransformersSubRegistration)domain);
        }
    }

    private static void registerSocketBindingGroupTransformers(TransformerRegistry registry, ModelVersion currentVersion) {
        ChainedTransformationDescriptionBuilder builder = SocketBindingGroupTransformers.buildTransformerChain(currentVersion);
        DomainTransformers.registerChainedTransformer(registry, builder, VERSION_1_7, VERSION_1_6, VERSION_1_5);
    }

    private static void registerChainedTransformer(TransformerRegistry registry, ChainedTransformationDescriptionBuilder builder, ModelVersion ... versions) {
        for (Map.Entry entry : builder.build(versions).entrySet()) {
            TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)entry.getKey());
            TransformationDescription.Tools.register((TransformationDescription)((TransformationDescription)entry.getValue()), (TransformersSubRegistration)domain);
        }
    }
}

