package org.jboss.as.domain.controller.logging;

import java.util.Locale;
import org.jboss.modules.ModuleLoadException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.domain.controller.ServerIdentity;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import org.jboss.as.controller.ModelVersion;
import org.jboss.dmr.ModelNode;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-08-13T18:03:00+0000")
public class DomainControllerLogger_$logger extends DelegatingBasicLogger implements DomainControllerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DomainControllerLogger_$logger.class.getName();
    public DomainControllerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void warnIgnoringSocketBindingGroupInclude(final Location location) {
        super.log.logf(FQCN, WARN, null, warnIgnoringSocketBindingGroupInclude$str(), location);
    }
    private static final String warnIgnoringSocketBindingGroupInclude = "WFLYDC0001: Ignoring 'include' child of 'socket-binding-group' %s";
    protected String warnIgnoringSocketBindingGroupInclude$str() {
        return warnIgnoringSocketBindingGroupInclude;
    }
    @Override
    public final void warnIgnoringProfileInclude(final Location location) {
        super.log.logf(FQCN, WARN, null, warnIgnoringProfileInclude$str(), location);
    }
    private static final String warnIgnoringProfileInclude = "WFLYDC0002: Ignoring 'include' child of 'profile' %s";
    protected String warnIgnoringProfileInclude$str() {
        return warnIgnoringProfileInclude;
    }
    @Override
    public final void interruptedAwaitingFinalResponse(final String serverName, final String hostName) {
        super.log.logf(FQCN, INFO, null, interruptedAwaitingFinalResponse2$str(), serverName, hostName);
    }
    private static final String interruptedAwaitingFinalResponse2 = "WFLYDC0003: Interrupted awaiting final response from server %s on host %s; remote process has been notified to cancel operation";
    protected String interruptedAwaitingFinalResponse2$str() {
        return interruptedAwaitingFinalResponse2;
    }
    @Override
    public final void caughtExceptionAwaitingFinalResponse(final Throwable cause, final String serverName, final String hostName) {
        super.log.logf(FQCN, WARN, cause, caughtExceptionAwaitingFinalResponse2$str(), serverName, hostName);
    }
    private static final String caughtExceptionAwaitingFinalResponse2 = "WFLYDC0004: Caught exception awaiting final response from server %s on host %s";
    protected String caughtExceptionAwaitingFinalResponse2$str() {
        return caughtExceptionAwaitingFinalResponse2;
    }
    @Override
    public final void interruptedAwaitingFinalResponse(final String hostName) {
        super.log.logf(FQCN, INFO, null, interruptedAwaitingFinalResponse1$str(), hostName);
    }
    private static final String interruptedAwaitingFinalResponse1 = "WFLYDC0005: Interrupted awaiting final response from host %s; remote process has been notified to cancel operation";
    protected String interruptedAwaitingFinalResponse1$str() {
        return interruptedAwaitingFinalResponse1;
    }
    @Override
    public final void caughtExceptionAwaitingFinalResponse(final Throwable cause, final String hostName) {
        super.log.logf(FQCN, WARN, cause, caughtExceptionAwaitingFinalResponse1$str(), hostName);
    }
    private static final String caughtExceptionAwaitingFinalResponse1 = "WFLYDC0006: Caught exception awaiting final response from host %s";
    protected String caughtExceptionAwaitingFinalResponse1$str() {
        return caughtExceptionAwaitingFinalResponse1;
    }
    @Override
    public final void caughtExceptionClosingInputStream(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, caughtExceptionClosingInputStream$str());
    }
    private static final String caughtExceptionClosingInputStream = "WFLYDC0007: Caught exception closing input stream";
    protected String caughtExceptionClosingInputStream$str() {
        return caughtExceptionClosingInputStream;
    }
    @Override
    public final void domainModelChangedOnReConnect(final java.util.Set<ServerIdentity> servers) {
        super.log.logf(FQCN, INFO, null, domainModelChangedOnReConnect$str(), servers);
    }
    private static final String domainModelChangedOnReConnect = "WFLYDC0008: Domain model has changed on re-connect. The following servers will need to be restarted for changes to take affect: %s";
    protected String domainModelChangedOnReConnect$str() {
        return domainModelChangedOnReConnect;
    }
    @Override
    public final void caughtExceptionWaitingForTask(final String className, final String exceptionName, final String task) {
        super.log.logf(FQCN, ERROR, null, caughtExceptionWaitingForTask$str(), className, exceptionName, task);
    }
    private static final String caughtExceptionWaitingForTask = "WFLYDC0009: %s caught %s waiting for task %s. Cancelling task";
    protected String caughtExceptionWaitingForTask$str() {
        return caughtExceptionWaitingForTask;
    }
    @Override
    public final void reportAdminOnlyMissingDeploymentContent(final String contentHash, final String deploymentName) {
        super.log.logf(FQCN, ERROR, null, reportAdminOnlyMissingDeploymentContent$str(), contentHash, deploymentName);
    }
    private static final String reportAdminOnlyMissingDeploymentContent = "WFLYDC0011: No deployment content with hash %s is available in the deployment content repository for deployment %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.";
    protected String reportAdminOnlyMissingDeploymentContent$str() {
        return reportAdminOnlyMissingDeploymentContent;
    }
    @Override
    public final void failedToSetServerInRestartRequireState(final String serverName) {
        super.log.logf(FQCN, WARN, null, failedToSetServerInRestartRequireState$str(), serverName);
    }
    private static final String failedToSetServerInRestartRequireState = "WFLYDC0012: failed to set server (%s) into a restart required state";
    protected String failedToSetServerInRestartRequireState$str() {
        return failedToSetServerInRestartRequireState;
    }
    private static final String slaveControllerCannotAcceptOtherSlaves = "WFLYDC0013: Registration of remote hosts is not supported on slave host controllers";
    protected String slaveControllerCannotAcceptOtherSlaves$str() {
        return slaveControllerCannotAcceptOtherSlaves;
    }
    @Override
    public final String slaveControllerCannotAcceptOtherSlaves() {
        return String.format(getLoggingLocale(), slaveControllerCannotAcceptOtherSlaves$str());
    }
    private static final String adminOnlyModeCannotAcceptSlaves = "WFLYDC0014: The master host controller cannot register slave host controllers as it's current running mode is '%s'";
    protected String adminOnlyModeCannotAcceptSlaves$str() {
        return adminOnlyModeCannotAcceptSlaves;
    }
    @Override
    public final String adminOnlyModeCannotAcceptSlaves(final RunningMode runningMode) {
        return String.format(getLoggingLocale(), adminOnlyModeCannotAcceptSlaves$str(), runningMode);
    }
    private static final String slaveAlreadyRegistered = "WFLYDC0015: There is already a registered host named '%s'";
    protected String slaveAlreadyRegistered$str() {
        return slaveAlreadyRegistered;
    }
    @Override
    public final String slaveAlreadyRegistered(final String slaveName) {
        return String.format(getLoggingLocale(), slaveAlreadyRegistered$str(), slaveName);
    }
    private static final String requiredChildIsMissing = "WFLYDC0016: %s is missing %s: %s";
    protected String requiredChildIsMissing$str() {
        return requiredChildIsMissing;
    }
    @Override
    public final String requiredChildIsMissing(final String parent, final String child, final String parentSpec) {
        return String.format(getLoggingLocale(), requiredChildIsMissing$str(), parent, child, parentSpec);
    }
    private static final String unrecognizedChildren = "WFLYDC0017: %s recognizes only %s as children: %s";
    protected String unrecognizedChildren$str() {
        return unrecognizedChildren;
    }
    @Override
    public final String unrecognizedChildren(final String parent, final String children, final String parentSpec) {
        return String.format(getLoggingLocale(), unrecognizedChildren$str(), parent, children, parentSpec);
    }
    private static final String inSeriesIsMissingGroups = "WFLYDC0018: in-series is missing groups: %s";
    protected String inSeriesIsMissingGroups$str() {
        return inSeriesIsMissingGroups;
    }
    @Override
    public final String inSeriesIsMissingGroups(final String rolloutPlan) {
        return String.format(getLoggingLocale(), inSeriesIsMissingGroups$str(), rolloutPlan);
    }
    private static final String serverGroupExpectsSingleChild = "WFLYDC0019: server-group expects one and only one child: %s";
    protected String serverGroupExpectsSingleChild$str() {
        return serverGroupExpectsSingleChild;
    }
    @Override
    public final String serverGroupExpectsSingleChild(final String rolloutPlan) {
        return String.format(getLoggingLocale(), serverGroupExpectsSingleChild$str(), rolloutPlan);
    }
    private static final String unexpectedInSeriesGroup = "WFLYDC0020: One of the groups does not define neither server-group nor concurrent-groups: %s";
    protected String unexpectedInSeriesGroup$str() {
        return unexpectedInSeriesGroup;
    }
    @Override
    public final String unexpectedInSeriesGroup(final String rolloutPlan) {
        return String.format(getLoggingLocale(), unexpectedInSeriesGroup$str(), rolloutPlan);
    }
    private static final String unexplainedFailure = "WFLYDC0021: Unexplained failure";
    protected String unexplainedFailure$str() {
        return unexplainedFailure;
    }
    @Override
    public final String unexplainedFailure() {
        return String.format(getLoggingLocale(), unexplainedFailure$str());
    }
    private static final String operationFailedOrRolledBack = "WFLYDC0022: Operation failed or was rolled back on all servers.";
    protected String operationFailedOrRolledBack$str() {
        return operationFailedOrRolledBack;
    }
    @Override
    public final String operationFailedOrRolledBack() {
        return String.format(getLoggingLocale(), operationFailedOrRolledBack$str());
    }
    private static final String interruptedAwaitingResultFromServer = "WFLYDC0023: Interrupted waiting for result from server %s";
    protected String interruptedAwaitingResultFromServer$str() {
        return interruptedAwaitingResultFromServer;
    }
    @Override
    public final String interruptedAwaitingResultFromServer(final ServerIdentity server) {
        return String.format(getLoggingLocale(), interruptedAwaitingResultFromServer$str(), server);
    }
    private static final String exceptionAwaitingResultFromServer = "WFLYDC0024: Exception getting result from server %s: %s";
    protected String exceptionAwaitingResultFromServer$str() {
        return exceptionAwaitingResultFromServer;
    }
    @Override
    public final String exceptionAwaitingResultFromServer(final ServerIdentity server, final String message) {
        return String.format(getLoggingLocale(), exceptionAwaitingResultFromServer$str(), server, message);
    }
    private static final String invalidRolloutPlan2 = "WFLYDC0025: Invalid rollout plan. %s is not a valid child of node %s";
    protected String invalidRolloutPlan2$str() {
        return invalidRolloutPlan2;
    }
    @Override
    public final String invalidRolloutPlan(final ModelNode modelNode, final String nodeName) {
        return String.format(getLoggingLocale(), invalidRolloutPlan2$str(), modelNode, nodeName);
    }
    private static final String invalidRolloutPlan1 = "WFLYDC0026: Invalid rollout plan. Plan operations affect server groups %s that are not reflected in the rollout plan";
    protected String invalidRolloutPlan1$str() {
        return invalidRolloutPlan1;
    }
    @Override
    public final String invalidRolloutPlan(final java.util.Set<String> groups) {
        return String.format(getLoggingLocale(), invalidRolloutPlan1$str(), groups);
    }
    private static final String invalidRolloutPlanGroupAlreadyExists = "WFLYDC0027: Invalid rollout plan. Server group %s appears more than once in the plan.";
    protected String invalidRolloutPlanGroupAlreadyExists$str() {
        return invalidRolloutPlanGroupAlreadyExists;
    }
    @Override
    public final String invalidRolloutPlanGroupAlreadyExists(final String group) {
        return String.format(getLoggingLocale(), invalidRolloutPlanGroupAlreadyExists$str(), group);
    }
    private static final String invalidRolloutPlanRange = "WFLYDC0028: Invalid rollout plan. Server group %s has a %s value of %s; must be between 0 and 100.";
    protected String invalidRolloutPlanRange$str() {
        return invalidRolloutPlanRange;
    }
    @Override
    public final String invalidRolloutPlanRange(final String name, final String propertyName, final int value) {
        return String.format(getLoggingLocale(), invalidRolloutPlanRange$str(), name, propertyName, value);
    }
    private static final String invalidRolloutPlanLess = "WFLYDC0029: Invalid rollout plan. Server group %s has a %s value of %s; cannot be less than 0.";
    protected String invalidRolloutPlanLess$str() {
        return invalidRolloutPlanLess;
    }
    @Override
    public final String invalidRolloutPlanLess(final String name, final String propertyName, final int value) {
        return String.format(getLoggingLocale(), invalidRolloutPlanLess$str(), name, propertyName, value);
    }
    private static final String interruptedAwaitingResultFromHost = "WFLYDC0030: Interrupted waiting for result from host %s";
    protected String interruptedAwaitingResultFromHost$str() {
        return interruptedAwaitingResultFromHost;
    }
    @Override
    public final String interruptedAwaitingResultFromHost(final String name) {
        return String.format(getLoggingLocale(), interruptedAwaitingResultFromHost$str(), name);
    }
    private static final String masterDomainControllerOnlyOperation = "WFLYDC0032: Operation %s for address %s can only be handled by the master Domain Controller; this host is not the master Domain Controller";
    protected String masterDomainControllerOnlyOperation$str() {
        return masterDomainControllerOnlyOperation;
    }
    @Override
    public final String masterDomainControllerOnlyOperation(final String operation, final PathAddress address) {
        return String.format(getLoggingLocale(), masterDomainControllerOnlyOperation$str(), operation, address);
    }
    private static final String invalidOperationTargetHost = "WFLYDC0033: Operation targets host %s but that host is not registered";
    protected String invalidOperationTargetHost$str() {
        return invalidOperationTargetHost;
    }
    @Override
    public final OperationFailedException invalidOperationTargetHost(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidOperationTargetHost$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String caughtExceptionStoringDeploymentContent = "WFLYDC0034: Caught %s storing deployment content -- %s";
    protected String caughtExceptionStoringDeploymentContent$str() {
        return caughtExceptionStoringDeploymentContent;
    }
    @Override
    public final OperationFailedException caughtExceptionStoringDeploymentContent(final String exceptionName, final Throwable exception) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), caughtExceptionStoringDeploymentContent$str(), exceptionName, exception));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedInitialPathKey = "WFLYDC0035: Unexpected initial path key %s";
    protected String unexpectedInitialPathKey$str() {
        return unexpectedInitialPathKey;
    }
    @Override
    public final IllegalStateException unexpectedInitialPathKey(final String key) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedInitialPathKey$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullStream = "WFLYDC0036: Null stream at index %d";
    protected String nullStream$str() {
        return nullStream;
    }
    @Override
    public final String nullStream(final int index) {
        return String.format(getLoggingLocale(), nullStream$str(), index);
    }
    private static final String invalidByteStream = "WFLYDC0037: Invalid byte stream.";
    protected String invalidByteStream$str() {
        return invalidByteStream;
    }
    @Override
    public final String invalidByteStream() {
        return String.format(getLoggingLocale(), invalidByteStream$str());
    }
    private static final String invalidUrlStream = "WFLYDC0038: Invalid url stream.";
    protected String invalidUrlStream$str() {
        return invalidUrlStream;
    }
    @Override
    public final String invalidUrlStream() {
        return String.format(getLoggingLocale(), invalidUrlStream$str());
    }
    private static final String as7431 = "WFLYDC0039: Only 1 piece of content is currently supported (AS7-431)";
    protected String as7431$str() {
        return as7431;
    }
    @Override
    public final String as7431() {
        return String.format(getLoggingLocale(), as7431$str());
    }
    private static final String noDeploymentContentWithHash = "WFLYDC0040: No deployment content with hash %s is available in the deployment content repository.";
    protected String noDeploymentContentWithHash$str() {
        return noDeploymentContentWithHash;
    }
    @Override
    public final String noDeploymentContentWithHash(final String hash) {
        return String.format(getLoggingLocale(), noDeploymentContentWithHash$str(), hash);
    }
    private static final String slaveCannotAcceptUploads = "WFLYDC0041: A slave domain controller cannot accept deployment content uploads";
    protected String slaveCannotAcceptUploads$str() {
        return slaveCannotAcceptUploads;
    }
    @Override
    public final String slaveCannotAcceptUploads() {
        return String.format(getLoggingLocale(), slaveCannotAcceptUploads$str());
    }
    private static final String noDeploymentContentWithName = "WFLYDC0042: No deployment with name %s found";
    protected String noDeploymentContentWithName$str() {
        return noDeploymentContentWithName;
    }
    @Override
    public final String noDeploymentContentWithName(final String name) {
        return String.format(getLoggingLocale(), noDeploymentContentWithName$str(), name);
    }
    private static final String cannotRemoveDeploymentInUse = "WFLYDC0043: Cannot remove deployment %s from the domain as it is still used by server groups %s";
    protected String cannotRemoveDeploymentInUse$str() {
        return cannotRemoveDeploymentInUse;
    }
    @Override
    public final String cannotRemoveDeploymentInUse(final String name, final java.util.List<String> groups) {
        return String.format(getLoggingLocale(), cannotRemoveDeploymentInUse$str(), name, groups);
    }
    private static final String invalidValue = "WFLYDC0044: Invalid '%s' value: %d, the maximum index is %d";
    protected String invalidValue$str() {
        return invalidValue;
    }
    @Override
    public final String invalidValue(final String name, final int value, final int maxIndex) {
        return String.format(getLoggingLocale(), invalidValue$str(), name, value, maxIndex);
    }
    private static final String invalidUrl = "WFLYDC0045: %s is not a valid URL -- %s";
    protected String invalidUrl$str() {
        return invalidUrl;
    }
    @Override
    public final String invalidUrl(final String url, final String message) {
        return String.format(getLoggingLocale(), invalidUrl$str(), url, message);
    }
    private static final String errorObtainingUrlStream = "WFLYDC0046: Error obtaining input stream from URL %s -- %s";
    protected String errorObtainingUrlStream$str() {
        return errorObtainingUrlStream;
    }
    @Override
    public final String errorObtainingUrlStream(final String url, final String message) {
        return String.format(getLoggingLocale(), errorObtainingUrlStream$str(), url, message);
    }
    private static final String invalidContentDeclaration = "WFLYDC0047: Invalid content declaration";
    protected String invalidContentDeclaration$str() {
        return invalidContentDeclaration;
    }
    @Override
    public final String invalidContentDeclaration() {
        return String.format(getLoggingLocale(), invalidContentDeclaration$str());
    }
    private static final String cannotUseSameValueForParameters = "WFLYDC0049: Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.";
    protected String cannotUseSameValueForParameters$str() {
        return cannotUseSameValueForParameters;
    }
    @Override
    public final String cannotUseSameValueForParameters(final String opName, final String param1, final String param2, final String redeployOpName, final String replaceOpName) {
        return String.format(getLoggingLocale(), cannotUseSameValueForParameters$str(), opName, param1, param2, redeployOpName, replaceOpName);
    }
    private static final String deploymentAlreadyStarted = "WFLYDC0050: Deployment %s is already started";
    protected String deploymentAlreadyStarted$str() {
        return deploymentAlreadyStarted;
    }
    @Override
    public final String deploymentAlreadyStarted(final String name) {
        return String.format(getLoggingLocale(), deploymentAlreadyStarted$str(), name);
    }
    private static final String unknown = "WFLYDC0051: Unknown %s %s";
    protected String unknown$str() {
        return unknown;
    }
    @Override
    public final String unknown(final String name, final String value) {
        return String.format(getLoggingLocale(), unknown$str(), name, value);
    }
    private static final String unknownServerGroup = "WFLYDC0052: Unknown server group %s";
    protected String unknownServerGroup$str() {
        return unknownServerGroup;
    }
    @Override
    public final IllegalStateException unknownServerGroup(final String serverGroup) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownServerGroup$str(), serverGroup));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownServer = "WFLYDC0053: Unknown server %s";
    protected String unknownServer$str() {
        return unknownServer;
    }
    @Override
    public final IllegalStateException unknownServer(final ServerIdentity server) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownServer$str(), server));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCode = "WFLYDC0054: Invalid code %d";
    protected String invalidCode$str() {
        return invalidCode;
    }
    @Override
    public final IllegalArgumentException invalidCode(final int code) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCode$str(), code));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentHashNotFoundInRepository = "WFLYDC0055: Repository does not contain any deployment with hash %s";
    protected String deploymentHashNotFoundInRepository$str() {
        return deploymentHashNotFoundInRepository;
    }
    @Override
    public final IllegalStateException deploymentHashNotFoundInRepository(final String hash) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), deploymentHashNotFoundInRepository$str(), hash));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedOnlyOneDeployment = "WFLYDC0056: Expected only one deployment, found %d";
    protected String expectedOnlyOneDeployment$str() {
        return expectedOnlyOneDeployment;
    }
    @Override
    public final IllegalStateException expectedOnlyOneDeployment(final int i) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), expectedOnlyOneDeployment$str(), i));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noProfileCalled = "WFLYDC0057: No profile called: %s";
    protected String noProfileCalled$str() {
        return noProfileCalled;
    }
    @Override
    public final OperationFailedException noProfileCalled(final String profile) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noProfileCalled$str(), profile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDeploymentContentWithHashAtBoot = "WFLYDC0058: No deployment content with hash %s is available in the deployment content repository for deployment '%s'. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment from the xml configuraiton file and restart.";
    protected String noDeploymentContentWithHashAtBoot$str() {
        return noDeploymentContentWithHashAtBoot;
    }
    @Override
    public final String noDeploymentContentWithHashAtBoot(final String contentHash, final String deploymentName) {
        return String.format(getLoggingLocale(), noDeploymentContentWithHashAtBoot$str(), contentHash, deploymentName);
    }
    private static final String failedToLoadModule = "WFLYDC0059: Failed to load module '%s'.";
    protected String failedToLoadModule$str() {
        return failedToLoadModule;
    }
    @Override
    public final OperationFailedException failedToLoadModule(final ModuleLoadException e, final String module) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToLoadModule$str(), module), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidJSFSlotValue = "WFLYDC0060: Invalid JSF slot value: '%s'. The host controller is not able to use a JSF slot value different from its default. This resource will be ignored on that host";
    protected String invalidJSFSlotValue$str() {
        return invalidJSFSlotValue;
    }
    @Override
    public final String invalidJSFSlotValue(final String slot) {
        return String.format(getLoggingLocale(), invalidJSFSlotValue$str(), slot);
    }
    private static final String unknownAttributesFromSubsystemVersion = "WFLYDC0061: Operation '%s' fails because the attributes are not known from the subsytem '%s' model version '%s': %s";
    protected String unknownAttributesFromSubsystemVersion$str() {
        return unknownAttributesFromSubsystemVersion;
    }
    @Override
    public final String unknownAttributesFromSubsystemVersion(final String operationName, final String subsystemName, final ModelVersion version, final java.util.Collection<String> attributes) {
        return String.format(getLoggingLocale(), unknownAttributesFromSubsystemVersion$str(), operationName, subsystemName, version, attributes);
    }
    private static final String noSocketBindingGroupCalled = "WFLYDC0062: No socket-binding-group named: %s";
    protected String noSocketBindingGroupCalled$str() {
        return noSocketBindingGroupCalled;
    }
    @Override
    public final OperationFailedException noSocketBindingGroupCalled(final String socketBindingGroup) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noSocketBindingGroupCalled$str(), socketBindingGroup));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String runtimeNameMustBeUnique = "WFLYDC0063: There is already a deployment called %s with the same runtime name %s on server group %s";
    protected String runtimeNameMustBeUnique$str() {
        return runtimeNameMustBeUnique;
    }
    @Override
    public final OperationFailedException runtimeNameMustBeUnique(final String existingDeployment, final String runtimeName, final String serverGroup) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), runtimeNameMustBeUnique$str(), existingDeployment, runtimeName, serverGroup));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveUsedServerGroup = "WFLYDC0064: Cannot remove server-group '%s' since it's still in use by servers %s";
    protected String cannotRemoveUsedServerGroup$str() {
        return cannotRemoveUsedServerGroup;
    }
    @Override
    public final OperationFailedException cannotRemoveUsedServerGroup(final String group, final java.util.Set<String> servers) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemoveUsedServerGroup$str(), group, servers));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedWildcardOperation = "WFLYDC0065: Wildcard operations are not supported as part of composite operations";
    protected String unsupportedWildcardOperation$str() {
        return unsupportedWildcardOperation;
    }
    @Override
    public final OperationFailedException unsupportedWildcardOperation() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unsupportedWildcardOperation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToSendMessage = "WFLYDC0066: Failed to send message: %s";
    protected String failedToSendMessage$str() {
        return failedToSendMessage;
    }
    @Override
    public final String failedToSendMessage(final String cause) {
        return String.format(getLoggingLocale(), failedToSendMessage$str(), cause);
    }
    private static final String failedToSendResponseHeader = "WFLYDC0067: Failed to send response header: %s";
    protected String failedToSendResponseHeader$str() {
        return failedToSendResponseHeader;
    }
    @Override
    public final String failedToSendResponseHeader(final String cause) {
        return String.format(getLoggingLocale(), failedToSendResponseHeader$str(), cause);
    }
    private static final String registrationTaskGotInterrupted = "WFLYDC0068: Host registration task got interrupted";
    protected String registrationTaskGotInterrupted$str() {
        return registrationTaskGotInterrupted;
    }
    @Override
    public final String registrationTaskGotInterrupted() {
        return String.format(getLoggingLocale(), registrationTaskGotInterrupted$str());
    }
    private static final String registrationTaskFailed = "WFLYDC0069: Host registration task failed: %s";
    protected String registrationTaskFailed$str() {
        return registrationTaskFailed;
    }
    @Override
    public final String registrationTaskFailed(final String cause) {
        return String.format(getLoggingLocale(), registrationTaskFailed$str(), cause);
    }
    @Override
    public final void interruptedAwaitingPreparedResponse(final String callerClass, final java.util.Set<ServerIdentity> servers) {
        super.log.logf(FQCN, INFO, null, interruptedAwaitingPreparedResponse$str(), callerClass, servers);
    }
    private static final String interruptedAwaitingPreparedResponse = "WFLYDC0070: %s interrupted awaiting server prepared response(s) -- cancelling updates for servers %s";
    protected String interruptedAwaitingPreparedResponse$str() {
        return interruptedAwaitingPreparedResponse;
    }
    @Override
    public final void interruptedAwaitingHostPreparedResponse(final java.util.Set<String> hosts) {
        super.log.logf(FQCN, INFO, null, interruptedAwaitingHostPreparedResponse$str(), hosts);
    }
    private static final String interruptedAwaitingHostPreparedResponse = "WFLYDC0071: Interrupted awaiting host prepared response(s) -- cancelling updates for hosts %s";
    protected String interruptedAwaitingHostPreparedResponse$str() {
        return interruptedAwaitingHostPreparedResponse;
    }
    private static final String caughtIOExceptionUploadingContent = "WFLYDC0072: Caught IOException reading uploaded deployment content";
    protected String caughtIOExceptionUploadingContent$str() {
        return caughtIOExceptionUploadingContent;
    }
    @Override
    public final OperationFailedException caughtIOExceptionUploadingContent(final IOException cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), caughtIOExceptionUploadingContent$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void undeployingDeploymentHasBeenRedeployed(final String deploymentName) {
        super.log.logf(FQCN, WARN, null, undeployingDeploymentHasBeenRedeployed$str(), deploymentName);
    }
    private static final String undeployingDeploymentHasBeenRedeployed = "WFLYDC0073: %s deployment has been re-deployed, its content will not be removed. You will need to restart it.";
    protected String undeployingDeploymentHasBeenRedeployed$str() {
        return undeployingDeploymentHasBeenRedeployed;
    }
    private static final String operationFailedOrRolledBackWithCause = "WFLYDC0074: Operation failed or was rolled back on all servers. Server failures:";
    protected String operationFailedOrRolledBackWithCause$str() {
        return operationFailedOrRolledBackWithCause;
    }
    @Override
    public final String operationFailedOrRolledBackWithCause() {
        return String.format(getLoggingLocale(), operationFailedOrRolledBackWithCause$str());
    }
    private static final String missingExtensions = "WFLYDC0075: Cannot synchronize the model due to missing extensions: %s";
    protected String missingExtensions$str() {
        return missingExtensions;
    }
    @Override
    public final OperationFailedException missingExtensions(final java.util.Set<String> missingExtensions) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), missingExtensions$str(), missingExtensions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateProfileInclude = "WFLYDC0076: Duplicate included profile '%s'";
    protected String duplicateProfileInclude$str() {
        return duplicateProfileInclude;
    }
    @Override
    public final XMLStreamException duplicateProfileInclude(final String name) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateProfileInclude$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateSocketBindingGroupInclude = "WFLYDC0077: Duplicate included socket binding group '%s'";
    protected String duplicateSocketBindingGroupInclude$str() {
        return duplicateSocketBindingGroupInclude;
    }
    @Override
    public final XMLStreamException duplicateSocketBindingGroupInclude(final String s) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateSocketBindingGroupInclude$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cloneOperationNotSupportedOnHost = "WFLYDC0078: The profile clone operation is not available on the host '%s'. To be able to use it in a domain containing older slaves which do not support the profile clone operation, you need to either: a) Make sure that all older slaves with a model version smaller than 4.0.0 ignore the cloned profile and the profile specified in the 'to-profile' parameter. b) Reload the domain controller into admin-only mode, perform the clone, then reload the domain controller into normal mode again, and check whether the slaves need reloading.";
    protected String cloneOperationNotSupportedOnHost$str() {
        return cloneOperationNotSupportedOnHost;
    }
    @Override
    public final String cloneOperationNotSupportedOnHost(final String hostName) {
        return String.format(getLoggingLocale(), cloneOperationNotSupportedOnHost$str(), hostName);
    }
    @Override
    public final void timedOutAwaitingHostPreparedResponses(final long timeout, final java.util.Set<String> timeoutHosts, final java.util.Set<String> allHosts) {
        super.log.logf(FQCN, INFO, null, timedOutAwaitingHostPreparedResponses$str(), timeout, timeoutHosts, allHosts);
    }
    private static final String timedOutAwaitingHostPreparedResponses = "WFLYDC0079: Timed out after %d ms awaiting host prepared response(s) from hosts %s -- cancelling updates for hosts %s";
    protected String timedOutAwaitingHostPreparedResponses$str() {
        return timedOutAwaitingHostPreparedResponses;
    }
    private static final String timedOutAwaitingHostPreparedResponse = "WFLYDC0080: Timed out after %d ms awaiting host prepared response(s) -- remote host %s has been notified to cancel operation";
    protected String timedOutAwaitingHostPreparedResponse$str() {
        return timedOutAwaitingHostPreparedResponse;
    }
    @Override
    public final String timedOutAwaitingHostPreparedResponse(final long timeout, final String host) {
        return String.format(getLoggingLocale(), timedOutAwaitingHostPreparedResponse$str(), timeout, host);
    }
    @Override
    public final void timedOutAwaitingFinalResponse(final long timeout, final String hostName) {
        super.log.logf(FQCN, INFO, null, timedOutAwaitingFinalResponse2$str(), timeout, hostName);
    }
    private static final String timedOutAwaitingFinalResponse2 = "WFLYDC0081: Timed out after %d ms awaiting final response from host %s; remote process has been notified to cancel operation";
    protected String timedOutAwaitingFinalResponse2$str() {
        return timedOutAwaitingFinalResponse2;
    }
    @Override
    public final void timedOutAwaitingPreparedResponse(final String callerClass, final long timeout, final java.util.Set<ServerIdentity> servers) {
        super.log.logf(FQCN, INFO, null, timedOutAwaitingPreparedResponse$str(), callerClass, timeout, servers);
    }
    private static final String timedOutAwaitingPreparedResponse = "WFLYDC0082: %s timed out after %d ms awaiting server prepared response(s) -- cancelling updates for servers %s";
    protected String timedOutAwaitingPreparedResponse$str() {
        return timedOutAwaitingPreparedResponse;
    }
    @Override
    public final void timedOutAwaitingFinalResponse(final int patient, final String serverName, final String hostName) {
        super.log.logf(FQCN, INFO, null, timedOutAwaitingFinalResponse3$str(), patient, serverName, hostName);
    }
    private static final String timedOutAwaitingFinalResponse3 = "WFLYDC0083: Timed out after %d ms awaiting final response from server %s on host %s; remote process has been notified to cancel operation";
    protected String timedOutAwaitingFinalResponse3$str() {
        return timedOutAwaitingFinalResponse3;
    }
    private static final String cannotExplodeDeploymentOfSelfContainedServer = "WFLYDC0084: Cannot explode a deployment in a self-contained server";
    protected String cannotExplodeDeploymentOfSelfContainedServer$str() {
        return cannotExplodeDeploymentOfSelfContainedServer;
    }
    @Override
    public final OperationFailedException cannotExplodeDeploymentOfSelfContainedServer() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeDeploymentOfSelfContainedServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExplodeUnmanagedDeployment = "WFLYDC0085: Cannot explode an unmanaged deployment";
    protected String cannotExplodeUnmanagedDeployment$str() {
        return cannotExplodeUnmanagedDeployment;
    }
    @Override
    public final OperationFailedException cannotExplodeUnmanagedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeUnmanagedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExplodeAlreadyExplodedDeployment = "WFLYDC0086: Cannot explode an already exploded deployment";
    protected String cannotExplodeAlreadyExplodedDeployment$str() {
        return cannotExplodeAlreadyExplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotExplodeAlreadyExplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeAlreadyExplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExplodeEnabledDeployment = "WFLYDC0087: Cannot explode an already deployed deployment";
    protected String cannotExplodeEnabledDeployment$str() {
        return cannotExplodeEnabledDeployment;
    }
    @Override
    public final OperationFailedException cannotExplodeEnabledDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeEnabledDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddContentToSelfContainedServer = "WFLYDC0088: Cannot add content to a deployment in a self-contained server";
    protected String cannotAddContentToSelfContainedServer$str() {
        return cannotAddContentToSelfContainedServer;
    }
    @Override
    public final OperationFailedException cannotAddContentToSelfContainedServer() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddContentToSelfContainedServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddContentToUnmanagedDeployment = "WFLYDC0089: Cannot add content to an unmanaged deployment";
    protected String cannotAddContentToUnmanagedDeployment$str() {
        return cannotAddContentToUnmanagedDeployment;
    }
    @Override
    public final OperationFailedException cannotAddContentToUnmanagedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddContentToUnmanagedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddContentToUnexplodedDeployment = "WFLYDC0090: Cannot add content to an unexploded deployment";
    protected String cannotAddContentToUnexplodedDeployment$str() {
        return cannotAddContentToUnexplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotAddContentToUnexplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddContentToUnexplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveContentFromSelfContainedServer = "WFLYDC0091: Cannot remove content from a deployment in a self-contained server";
    protected String cannotRemoveContentFromSelfContainedServer$str() {
        return cannotRemoveContentFromSelfContainedServer;
    }
    @Override
    public final OperationFailedException cannotRemoveContentFromSelfContainedServer() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemoveContentFromSelfContainedServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveContentFromUnmanagedDeployment = "WFLYDC0092: Cannot remove content from an unmanaged deployment";
    protected String cannotRemoveContentFromUnmanagedDeployment$str() {
        return cannotRemoveContentFromUnmanagedDeployment;
    }
    @Override
    public final OperationFailedException cannotRemoveContentFromUnmanagedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemoveContentFromUnmanagedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveContentFromUnexplodedDeployment = "WFLYDC0093: Cannot remove content from an unexploded deployment";
    protected String cannotRemoveContentFromUnexplodedDeployment$str() {
        return cannotRemoveContentFromUnexplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotRemoveContentFromUnexplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRemoveContentFromUnexplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReadContentFromSelfContainedServer = "WFLYDC0094: Cannot read content from a deployment in a self-contained server";
    protected String cannotReadContentFromSelfContainedServer$str() {
        return cannotReadContentFromSelfContainedServer;
    }
    @Override
    public final OperationFailedException cannotReadContentFromSelfContainedServer() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotReadContentFromSelfContainedServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReadContentFromUnmanagedDeployment = "WFLYDC0095: Cannot read content from an unmanaged deployment";
    protected String cannotReadContentFromUnmanagedDeployment$str() {
        return cannotReadContentFromUnmanagedDeployment;
    }
    @Override
    public final OperationFailedException cannotReadContentFromUnmanagedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotReadContentFromUnmanagedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReadContentFromUnexplodedDeployment = "WFLYDC0096: Cannot read content from an unexploded deployment";
    protected String cannotReadContentFromUnexplodedDeployment$str() {
        return cannotReadContentFromUnexplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotReadContentFromUnexplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotReadContentFromUnexplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExplodeSubDeploymentOfUnexplodedDeployment = "WFLYDC0097: Cannot explode a subdeployment of an unexploded deployment";
    protected String cannotExplodeSubDeploymentOfUnexplodedDeployment$str() {
        return cannotExplodeSubDeploymentOfUnexplodedDeployment;
    }
    @Override
    public final OperationFailedException cannotExplodeSubDeploymentOfUnexplodedDeployment() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotExplodeSubDeploymentOfUnexplodedDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
