package org.jboss.as.host.controller.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.jboss.logging.Logger;
import org.jboss.as.controller.RunningMode;
import javax.security.sasl.SaslException;
import java.net.URI;
import java.lang.InterruptedException;
import java.net.URL;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import java.util.concurrent.ExecutionException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import java.nio.file.Path;
import javax.annotation.Generated;
import org.jboss.remoting3.Channel;
import org.jboss.as.controller.OperationFailedException;
import java.io.IOException;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import java.lang.Exception;
import javax.xml.stream.XMLStreamException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.dmr.ModelNode;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import java.io.File;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-08-13T18:02:59+0000")
public class HostControllerLogger_$logger extends DelegatingBasicLogger implements HostControllerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HostControllerLogger_$logger.class.getName();
    public HostControllerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotConnect(final URI uri, final Exception cause) {
        super.log.logf(FQCN, WARN, cause, cannotConnect$str(), uri);
    }
    private static final String cannotConnect = "WFLYHC0001: Could not connect to remote domain controller %s";
    protected String cannotConnect$str() {
        return cannotConnect;
    }
    @Override
    public final void cannotConnectToMaster(final Exception e) {
        super.log.logf(FQCN, ERROR, null, cannotConnectToMaster$str(), e);
    }
    private static final String cannotConnectToMaster = "WFLYHC0002: Could not connect to master. Error was: %s";
    protected String cannotConnectToMaster$str() {
        return cannotConnectToMaster;
    }
    @Override
    public final void creatingHttpManagementService(final String interfaceName, final int port, final int securePort) {
        super.log.logf(FQCN, INFO, null, creatingHttpManagementService$str(), interfaceName, port, securePort);
    }
    private static final String creatingHttpManagementService = "WFLYHC0003: Creating http management service using network interface (%s) port (%d) securePort (%d)";
    protected String creatingHttpManagementService$str() {
        return creatingHttpManagementService;
    }
    @Override
    public final void existingServerWithState(final String serverName, final ServerStatus state) {
        super.log.logf(FQCN, WARN, null, existingServerWithState$str(), serverName, state);
    }
    private static final String existingServerWithState = "WFLYHC0005: Existing server [%s] with status: %s";
    protected String existingServerWithState$str() {
        return existingServerWithState;
    }
    @Override
    public final void failedToStartServer(final Throwable cause, final String serverName) {
        super.log.logf(FQCN, ERROR, cause, failedToStartServer$str(), serverName);
    }
    private static final String failedToStartServer = "WFLYHC0008: Failed to start server (%s)";
    protected String failedToStartServer$str() {
        return failedToStartServer;
    }
    @Override
    public final void failedToStopServer(final Throwable cause, final String serverName) {
        super.log.logf(FQCN, ERROR, cause, failedToStopServer$str(), serverName);
    }
    private static final String failedToStopServer = "WFLYHC0009: Failed to stop server (%s)";
    protected String failedToStopServer$str() {
        return failedToStopServer;
    }
    @Override
    public final void ignoringPermGen(final JvmType type, final String jvm) {
        super.log.logf(FQCN, WARN, null, ignoringPermGen$str(), type, jvm);
    }
    private static final String ignoringPermGen = "WFLYHC0011: Ignoring <permgen> for jvm '%s' type jvm: %s";
    protected String ignoringPermGen$str() {
        return ignoringPermGen;
    }
    @Override
    public final void noDomainControllerConfigurationProvided(final RunningMode currentRunningMode, final String adminOnlyCmdLineArg, final RunningMode validRunningMode) {
        super.log.logf(FQCN, ERROR, null, noDomainControllerConfigurationProvided$str(), currentRunningMode, adminOnlyCmdLineArg, validRunningMode);
    }
    private static final String noDomainControllerConfigurationProvided = "WFLYHC0012: No <domain-controller> configuration was provided and the current running mode ('%s') requires access to the Domain Controller host. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.";
    protected String noDomainControllerConfigurationProvided$str() {
        return noDomainControllerConfigurationProvided;
    }
    @Override
    public final void httpManagementInterfaceIsUnsecured() {
        super.log.logf(FQCN, WARN, null, httpManagementInterfaceIsUnsecured$str());
    }
    private static final String httpManagementInterfaceIsUnsecured = "WFLYHC0013: No security realm defined for http management service, all access will be unrestricted.";
    protected String httpManagementInterfaceIsUnsecured$str() {
        return httpManagementInterfaceIsUnsecured;
    }
    @Override
    public final void noServerAvailable(final String serverName) {
        super.log.logf(FQCN, ERROR, null, noServerAvailable$str(), serverName);
    }
    private static final String noServerAvailable = "WFLYHC0014: No server called %s available";
    protected String noServerAvailable$str() {
        return noServerAvailable;
    }
    @Override
    public final void lostRemoteDomainConnection() {
        super.log.logf(FQCN, WARN, null, lostRemoteDomainConnection$str());
    }
    private static final String lostRemoteDomainConnection = "WFLYHC0015: Connection to remote host-controller closed. Trying to reconnect.";
    protected String lostRemoteDomainConnection$str() {
        return lostRemoteDomainConnection;
    }
    @Override
    public final void optionAlreadySet(final String option, final String jvm, final String element) {
        super.log.logf(FQCN, WARN, null, optionAlreadySet$str(), option, jvm, element);
    }
    private static final String optionAlreadySet = "WFLYHC0016: Ignoring <option value=\"%s\" for jvm '%s' since '%s' was set";
    protected String optionAlreadySet$str() {
        return optionAlreadySet;
    }
    @Override
    public final void reconnectingServer(final String serverName) {
        super.log.logf(FQCN, INFO, null, reconnectingServer$str(), serverName);
    }
    private static final String reconnectingServer = "WFLYHC0018: Reconnecting server %s";
    protected String reconnectingServer$str() {
        return reconnectingServer;
    }
    @Override
    public final void registeredRemoteSlaveHost(final String hostName, final String productName) {
        super.log.logf(FQCN, INFO, null, registeredRemoteSlaveHost$str(), hostName, productName);
    }
    private static final String registeredRemoteSlaveHost = "WFLYHC0019: Registered remote slave host \"%s\", %s";
    protected String registeredRemoteSlaveHost$str() {
        return registeredRemoteSlaveHost;
    }
    @Override
    public final void registeringServer(final String name) {
        super.log.logf(FQCN, INFO, null, registeringServer$str(), name);
    }
    private static final String registeringServer = "WFLYHC0020: Registering server %s";
    protected String registeringServer$str() {
        return registeringServer;
    }
    @Override
    public final void serverConnected(final String name, final Channel channel) {
        super.log.logf(FQCN, INFO, null, serverConnected$str(), name, channel);
    }
    private static final String serverConnected = "WFLYHC0021: Server [%s] connected using connection [%s]";
    protected String serverConnected$str() {
        return serverConnected;
    }
    @Override
    public final void startingServer(final String serverName) {
        super.log.logf(FQCN, INFO, null, startingServer$str(), serverName);
    }
    private static final String startingServer = "WFLYHC0023: Starting server %s";
    protected String startingServer$str() {
        return startingServer;
    }
    @Override
    public final void stoppingServer(final String serverName) {
        super.log.logf(FQCN, INFO, null, stoppingServer$str(), serverName);
    }
    private static final String stoppingServer = "WFLYHC0024: Stopping server %s";
    protected String stoppingServer$str() {
        return stoppingServer;
    }
    @Override
    public final void unregisteredRemoteSlaveHost(final String host) {
        super.log.logf(FQCN, INFO, null, unregisteredRemoteSlaveHost$str(), host);
    }
    private static final String unregisteredRemoteSlaveHost = "WFLYHC0026: Unregistered remote slave host \"%s\"";
    protected String unregisteredRemoteSlaveHost$str() {
        return unregisteredRemoteSlaveHost;
    }
    @Override
    public final void unregisteringServer(final String name) {
        super.log.logf(FQCN, INFO, null, unregisteringServer$str(), name);
    }
    private static final String unregisteringServer = "WFLYHC0027: Unregistering server %s";
    protected String unregisteringServer$str() {
        return unregisteringServer;
    }
    @Override
    public final void unregisteredAtRemoteHostController() {
        super.log.logf(FQCN, INFO, null, unregisteredAtRemoteHostController$str());
    }
    private static final String unregisteredAtRemoteHostController = "WFLYHC0029: Unregistered at domain controller";
    protected String unregisteredAtRemoteHostController$str() {
        return unregisteredAtRemoteHostController;
    }
    @Override
    public final void lostConnectionToRemoteHost(final String hostId) {
        super.log.logf(FQCN, WARN, null, lostConnectionToRemoteHost$str(), hostId);
    }
    private static final String lostConnectionToRemoteHost = "WFLYHC0030: Connection to remote host \"%s\" closed unexpectedly";
    protected String lostConnectionToRemoteHost$str() {
        return lostConnectionToRemoteHost;
    }
    @Override
    public final void invalidRemoteBackupPersisterState() {
        super.log.logf(FQCN, WARN, null, invalidRemoteBackupPersisterState$str());
    }
    private static final String invalidRemoteBackupPersisterState = "WFLYHC0031: Cannot load the domain model using --backup";
    protected String invalidRemoteBackupPersisterState$str() {
        return invalidRemoteBackupPersisterState;
    }
    @Override
    public final void caughtExceptionDuringBoot(final Exception e) {
        super.log.logf(FQCN, ERROR, e, caughtExceptionDuringBoot$str());
    }
    private static final String caughtExceptionDuringBoot = "WFLYHC0033: Caught exception during boot";
    protected String caughtExceptionDuringBoot$str() {
        return caughtExceptionDuringBoot;
    }
    private static final String unsuccessfulBoot = "WFLYHC0034: Host Controller boot has failed in an unrecoverable manner; exiting. See previous messages for details.";
    protected String unsuccessfulBoot$str() {
        return unsuccessfulBoot;
    }
    @Override
    public final String unsuccessfulBoot() {
        return String.format(getLoggingLocale(), unsuccessfulBoot$str());
    }
    @Override
    public final void reportAdminOnlyDomainXmlFailure() {
        super.log.logf(FQCN, ERROR, null, reportAdminOnlyDomainXmlFailure$str());
    }
    private static final String reportAdminOnlyDomainXmlFailure = "WFLYHC0035: Installation of the domain-wide configuration has failed. Because the running mode of this Host Controller is ADMIN_ONLY boot has been allowed to proceed. If ADMIN_ONLY mode were not in effect the process would be terminated due to a critical boot failure.";
    protected String reportAdminOnlyDomainXmlFailure$str() {
        return reportAdminOnlyDomainXmlFailure;
    }
    @Override
    public final void masterHostControllerChanged() {
        super.log.logf(FQCN, INFO, null, masterHostControllerChanged$str());
    }
    private static final String masterHostControllerChanged = "WFLYHC0037: The master host controller has been restarted. Re-registering this slave host controller with the new master.";
    protected String masterHostControllerChanged$str() {
        return masterHostControllerChanged;
    }
    @Override
    public final void masterHostControllerUnreachable(final long timeout) {
        super.log.logf(FQCN, WARN, null, masterHostControllerUnreachable$str(), timeout);
    }
    private static final String masterHostControllerUnreachable = "WFLYHC0038: The master host controller could not be reached in the last [%d] milliseconds. Re-connecting.";
    protected String masterHostControllerUnreachable$str() {
        return masterHostControllerUnreachable;
    }
    @Override
    public final void slaveHostControllerChanged(final String hostName) {
        super.log.logf(FQCN, INFO, null, slaveHostControllerChanged$str(), hostName);
    }
    private static final String slaveHostControllerChanged = "WFLYHC0039: The slave host controller \"%s\" has been restarted or is attempting to reconnect. Unregistering the current connection to this slave.";
    protected String slaveHostControllerChanged$str() {
        return slaveHostControllerChanged;
    }
    @Override
    public final void slaveHostControllerUnreachable(final String hostName, final long timeout) {
        super.log.logf(FQCN, WARN, null, slaveHostControllerUnreachable$str(), hostName, timeout);
    }
    private static final String slaveHostControllerUnreachable = "WFLYHC0040: The slave host controller \"%s\"  could not be reached in the last [%d] milliseconds. Unregistering.";
    protected String slaveHostControllerUnreachable$str() {
        return slaveHostControllerUnreachable;
    }
    private static final String argumentExpected = "WFLYHC0041: Argument expected for option %s. %s";
    protected String argumentExpected$str() {
        return argumentExpected;
    }
    @Override
    public final String argumentExpected(final String option, final String usageNote) {
        return String.format(getLoggingLocale(), argumentExpected$str(), option, usageNote);
    }
    private static final String attemptingToSet = "WFLYHC0042: Attempting to set '%s' when '%s' was already set";
    protected String attemptingToSet$str() {
        return attemptingToSet;
    }
    @Override
    public final IllegalArgumentException attemptingToSet(final String attributeToSet, final String attributeAlreadySet) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), attemptingToSet$str(), attributeToSet, attributeAlreadySet));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationFailureUnableToConnect = "WFLYHC0043: Unable to connect due to authentication failure.";
    protected String authenticationFailureUnableToConnect$str() {
        return authenticationFailureUnableToConnect;
    }
    @Override
    public final IllegalStateException authenticationFailureUnableToConnect(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), authenticationFailureUnableToConnect$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAccessRemoteFileRepository = "WFLYHC0044: Cannot access a remote file repository from the master domain controller";
    protected String cannotAccessRemoteFileRepository$str() {
        return cannotAccessRemoteFileRepository;
    }
    @Override
    public final IllegalStateException cannotAccessRemoteFileRepository() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAccessRemoteFileRepository$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateLocalDirectory = "WFLYHC0045: Unable to create local directory: %s";
    protected String cannotCreateLocalDirectory$str() {
        return cannotCreateLocalDirectory;
    }
    @Override
    public final IOException cannotCreateLocalDirectory(final File path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotCreateLocalDirectory$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotObtainValidDefaultAddress = "WFLYHC0046: Cannot obtain a valid default address for communicating with the ProcessController using either %s or InetAddress.getLocalHost(). Please check your system's network configuration or use the %s command line switch to configure a valid address";
    protected String cannotObtainValidDefaultAddress$str() {
        return cannotObtainValidDefaultAddress;
    }
    @Override
    public final RuntimeException cannotObtainValidDefaultAddress(final Throwable cause, final String defaultAddress, final String option) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotObtainValidDefaultAddress$str(), defaultAddress, option), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRestartServer = "WFLYHC0047: Cannot restart server %s as it is not currently started; it is %s";
    protected String cannotRestartServer$str() {
        return cannotRestartServer;
    }
    @Override
    public final String cannotRestartServer(final String serverName, final ServerStatus status) {
        return String.format(getLoggingLocale(), cannotRestartServer$str(), serverName, status);
    }
    private static final String cannotStartServersInvalidMode = "WFLYHC0048: Cannot start servers when the Host Controller running mode is %s";
    protected String cannotStartServersInvalidMode$str() {
        return cannotStartServersInvalidMode;
    }
    @Override
    public final String cannotStartServersInvalidMode(final RunningMode mode) {
        return String.format(getLoggingLocale(), cannotStartServersInvalidMode$str(), mode);
    }
    private static final String closeShouldBeManagedByService = "WFLYHC0049: Close should be managed by the service";
    protected String closeShouldBeManagedByService$str() {
        return closeShouldBeManagedByService;
    }
    @Override
    public final UnsupportedOperationException closeShouldBeManagedByService() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), closeShouldBeManagedByService$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configurationPersisterAlreadyInitialized = "WFLYHC0050: Configuration persister for domain model is already initialized";
    protected String configurationPersisterAlreadyInitialized$str() {
        return configurationPersisterAlreadyInitialized;
    }
    @Override
    public final IllegalStateException configurationPersisterAlreadyInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationPersisterAlreadyInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionToMasterInterrupted = "WFLYHC0051: Interrupted while trying to connect to master";
    protected String connectionToMasterInterrupted$str() {
        return connectionToMasterInterrupted;
    }
    @Override
    public final IllegalStateException connectionToMasterInterrupted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), connectionToMasterInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionToMasterTimeout = "WFLYHC0052: Could not connect to master in %d attempts within %s ms";
    protected String connectionToMasterTimeout$str() {
        return connectionToMasterTimeout;
    }
    @Override
    public final IllegalStateException connectionToMasterTimeout(final Throwable cause, final int retries, final long timeout) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), connectionToMasterTimeout$str(), retries, timeout), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotGetServerInventory = "WFLYHC0053: Could not get the server inventory in %d %s";
    protected String couldNotGetServerInventory$str() {
        return couldNotGetServerInventory;
    }
    @Override
    public final RuntimeException couldNotGetServerInventory(final long time, final String timeUnit) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotGetServerInventory$str(), time, timeUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String didNotReadEntireFile = "WFLYHC0054: Did not read the entire file. Missing: %d";
    protected String didNotReadEntireFile$str() {
        return didNotReadEntireFile;
    }
    @Override
    public final IOException didNotReadEntireFile(final long missing) {
        final IOException result = new IOException(String.format(getLoggingLocale(), didNotReadEntireFile$str(), missing));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorClosingDownHost = "WFLYHC0055: Error closing down host";
    protected String errorClosingDownHost$str() {
        return errorClosingDownHost;
    }
    @Override
    public final RuntimeException errorClosingDownHost(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorClosingDownHost$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedProfileOperationsRetrieval = "WFLYHC0056: Failed to retrieve profile operations from domain controller";
    protected String failedProfileOperationsRetrieval$str() {
        return failedProfileOperationsRetrieval;
    }
    @Override
    public final String failedProfileOperationsRetrieval() {
        return String.format(getLoggingLocale(), failedProfileOperationsRetrieval$str());
    }
    private static final String failedToGetFileFromRemoteRepository = "WFLYHC0057: Failed to get file from remote repository";
    protected String failedToGetFileFromRemoteRepository$str() {
        return failedToGetFileFromRemoteRepository;
    }
    @Override
    public final RuntimeException failedToGetFileFromRemoteRepository(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToGetFileFromRemoteRepository$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToGetServerStatus = "WFLYHC0058: Failed to get server status";
    protected String failedToGetServerStatus$str() {
        return failedToGetServerStatus;
    }
    @Override
    public final String failedToGetServerStatus() {
        return String.format(getLoggingLocale(), failedToGetServerStatus$str());
    }
    private static final String failedToReadAuthenticationKey = "WFLYHC0059: Failed to read authentication key: %s";
    protected String failedToReadAuthenticationKey$str() {
        return failedToReadAuthenticationKey;
    }
    @Override
    public final String failedToReadAuthenticationKey(final Throwable cause) {
        return String.format(getLoggingLocale(), failedToReadAuthenticationKey$str(), cause);
    }
    private static final String insufficientInformationToGenerateHash = "WFLYHC0061: Insufficient information to generate hash.";
    protected String insufficientInformationToGenerateHash$str() {
        return insufficientInformationToGenerateHash;
    }
    @Override
    public final SaslException insufficientInformationToGenerateHash() {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), insufficientInformationToGenerateHash$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOption = "WFLYHC0062: Invalid option '%s'. %s";
    protected String invalidOption$str() {
        return invalidOption;
    }
    @Override
    public final String invalidOption(final String option, final String usageNote) {
        return String.format(getLoggingLocale(), invalidOption$str(), option, usageNote);
    }
    private static final String invalidRootId = "WFLYHC0063: Invalid root id [%d]";
    protected String invalidRootId$str() {
        return invalidRootId;
    }
    @Override
    public final RequestProcessingException invalidRootId(final int rootId) {
        final RequestProcessingException result = new RequestProcessingException(String.format(getLoggingLocale(), invalidRootId$str(), rootId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValue = "WFLYHC0064: Value for %s is not an %s -- %s. %s";
    protected String invalidValue$str() {
        return invalidValue;
    }
    @Override
    public final String invalidValue(final String name, final String type, final Object value, final String usageNote) {
        return String.format(getLoggingLocale(), invalidValue$str(), name, type, value, usageNote);
    }
    private static final String invocationNotAllowedAfterBoot = "WFLYHC0065: Invocations of %s after HostController boot are not allowed";
    protected String invocationNotAllowedAfterBoot$str() {
        return invocationNotAllowedAfterBoot;
    }
    @Override
    public final IllegalStateException invocationNotAllowedAfterBoot(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invocationNotAllowedAfterBoot$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final String invocationNotAllowedAfterBoot(final ModelNode operation) {
        return String.format(getLoggingLocale(), invocationNotAllowedAfterBoot$str(), operation);
    }
    private static final String malformedUrl = "WFLYHC0066: Malformed URL provided for option %s. %s";
    protected String malformedUrl$str() {
        return malformedUrl;
    }
    @Override
    public final String malformedUrl(final String option, final String usageNote) {
        return String.format(getLoggingLocale(), malformedUrl$str(), option, usageNote);
    }
    private static final String mustInvokeBeforeCheckingSlaveStatus = "WFLYHC0067: Must call %s before checking for slave status";
    protected String mustInvokeBeforeCheckingSlaveStatus$str() {
        return mustInvokeBeforeCheckingSlaveStatus;
    }
    @Override
    public final IllegalStateException mustInvokeBeforeCheckingSlaveStatus(final String methodName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mustInvokeBeforeCheckingSlaveStatus$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustInvokeBeforePersisting = "WFLYHC0068: Must call %s before persisting the domain model";
    protected String mustInvokeBeforePersisting$str() {
        return mustInvokeBeforePersisting;
    }
    @Override
    public final IllegalStateException mustInvokeBeforePersisting(final String methodName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mustInvokeBeforePersisting$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noServerInventory = "WFLYHC0071: No server inventory";
    protected String noServerInventory$str() {
        return noServerInventory;
    }
    @Override
    public final IllegalStateException noServerInventory() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noServerInventory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverNameAlreadyRegistered = "WFLYHC0077: There is already a registered server named '%s'";
    protected String serverNameAlreadyRegistered$str() {
        return serverNameAlreadyRegistered;
    }
    @Override
    public final IllegalArgumentException serverNameAlreadyRegistered(final String serverName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), serverNameAlreadyRegistered$str(), serverName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverStillRunning = "WFLYHC0078: Server (%s) still running";
    protected String serverStillRunning$str() {
        return serverStillRunning;
    }
    @Override
    public final String serverStillRunning(final String name) {
        return String.format(getLoggingLocale(), serverStillRunning$str(), name);
    }
    private static final String unableToGenerateHash = "WFLYHC0079: Unable to generate hash";
    protected String unableToGenerateHash$str() {
        return unableToGenerateHash;
    }
    @Override
    public final SaslException unableToGenerateHash(final Throwable cause) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), unableToGenerateHash$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadProperties = "WFLYHC0080: Unable to load properties from URL %s. %s";
    protected String unableToLoadProperties$str() {
        return unableToLoadProperties;
    }
    @Override
    public final String unableToLoadProperties(final URL url, final String usageNote) {
        return String.format(getLoggingLocale(), unableToLoadProperties$str(), url, usageNote);
    }
    private static final String undefinedSocketBinding = "WFLYHC0081: Undefined socket binding group for server %s";
    protected String undefinedSocketBinding$str() {
        return undefinedSocketBinding;
    }
    @Override
    public final IllegalArgumentException undefinedSocketBinding(final String serverName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), undefinedSocketBinding$str(), serverName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefinedSocketBindingGroup = "WFLYHC0082: Included socket binding group %s is not defined";
    protected String undefinedSocketBindingGroup$str() {
        return undefinedSocketBindingGroup;
    }
    @Override
    public final IllegalStateException undefinedSocketBindingGroup(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), undefinedSocketBindingGroup$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknown = "WFLYHC0084: Unknown %s %s";
    protected String unknown$str() {
        return unknown;
    }
    @Override
    public final IllegalArgumentException unknown(final String name, final Object value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknown$str(), name, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownHostValue = "WFLYHC0085: Value for %s is not a known host -- %s. %s";
    protected String unknownHostValue$str() {
        return unknownHostValue;
    }
    @Override
    public final String unknownHostValue(final String name, final Object value, final String usageNote) {
        return String.format(getLoggingLocale(), unknownHostValue$str(), name, value, usageNote);
    }
    private static final String hostAlreadyShutdown = "WFLYHC0087: Host-Controller is already shutdown.";
    protected String hostAlreadyShutdown$str() {
        return hostAlreadyShutdown;
    }
    @Override
    public final IllegalStateException hostAlreadyShutdown() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), hostAlreadyShutdown$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hostControllerSystemPropertyUpdateNotSupported = "WFLYHC0090: HostControllerEnvironment does not support system property updates";
    protected String hostControllerSystemPropertyUpdateNotSupported$str() {
        return hostControllerSystemPropertyUpdateNotSupported;
    }
    @Override
    public final UnsupportedOperationException hostControllerSystemPropertyUpdateNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), hostControllerSystemPropertyUpdateNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotIgnoreTypeHost = "WFLYHC0091: Resources of type %s cannot be ignored";
    protected String cannotIgnoreTypeHost$str() {
        return cannotIgnoreTypeHost;
    }
    @Override
    public final OperationFailedException cannotIgnoreTypeHost(final String type) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotIgnoreTypeHost$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateIgnoredResourceType = "WFLYHC0092: An '%s' element whose 'type' attribute is '%s' has already been found";
    protected String duplicateIgnoredResourceType$str() {
        return duplicateIgnoredResourceType;
    }
    @Override
    public final XMLStreamException duplicateIgnoredResourceType(final String element, final String value, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateIgnoredResourceType$str(), element, value), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAccessJvmInputArgument = "WFLYHC0093: The JVM input arguments cannot be accessed so system properties passed directly to this Host Controller JVM will not be passed through to server processes. Cause of the problem: %s";
    protected String cannotAccessJvmInputArgument$str() {
        return cannotAccessJvmInputArgument;
    }
    @Override
    public final String cannotAccessJvmInputArgument(final Exception cause) {
        return String.format(getLoggingLocale(), cannotAccessJvmInputArgument$str(), cause);
    }
    private static final String missingHomeDirConfiguration = "WFLYHC0094: Missing configuration value for: %s";
    protected String missingHomeDirConfiguration$str() {
        return missingHomeDirConfiguration;
    }
    @Override
    public final IllegalStateException missingHomeDirConfiguration(final String propertyName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingHomeDirConfiguration$str(), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String homeDirectoryDoesNotExist = "WFLYHC0095: Home directory does not exist: %s";
    protected String homeDirectoryDoesNotExist$str() {
        return homeDirectoryDoesNotExist;
    }
    @Override
    public final IllegalStateException homeDirectoryDoesNotExist(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), homeDirectoryDoesNotExist$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainBaseDirectoryDoesNotExist = "WFLYHC0097: Domain base directory does not exist: %s";
    protected String domainBaseDirectoryDoesNotExist$str() {
        return domainBaseDirectoryDoesNotExist;
    }
    @Override
    public final IllegalStateException domainBaseDirectoryDoesNotExist(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), domainBaseDirectoryDoesNotExist$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainBaseDirectoryIsNotADirectory = "WFLYHC0098: Domain base directory is not a directory: %s";
    protected String domainBaseDirectoryIsNotADirectory$str() {
        return domainBaseDirectoryIsNotADirectory;
    }
    @Override
    public final IllegalStateException domainBaseDirectoryIsNotADirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), domainBaseDirectoryIsNotADirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configDirectoryDoesNotExist = "WFLYHC0099: Configuration directory does not exist: %s";
    protected String configDirectoryDoesNotExist$str() {
        return configDirectoryDoesNotExist;
    }
    @Override
    public final IllegalStateException configDirectoryDoesNotExist(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configDirectoryDoesNotExist$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainDataDirectoryIsNotDirectory = "WFLYHC0100: Domain data directory is not a directory: %s";
    protected String domainDataDirectoryIsNotDirectory$str() {
        return domainDataDirectoryIsNotDirectory;
    }
    @Override
    public final IllegalStateException domainDataDirectoryIsNotDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), domainDataDirectoryIsNotDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateDomainDataDirectory = "WFLYHC0101: Could not create domain data directory: %s";
    protected String couldNotCreateDomainDataDirectory$str() {
        return couldNotCreateDomainDataDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateDomainDataDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateDomainDataDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainContentDirectoryIsNotDirectory = "WFLYHC0102: Domain content directory is not a directory: %s";
    protected String domainContentDirectoryIsNotDirectory$str() {
        return domainContentDirectoryIsNotDirectory;
    }
    @Override
    public final IllegalStateException domainContentDirectoryIsNotDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), domainContentDirectoryIsNotDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateDomainContentDirectory = "WFLYHC0103: Could not create domain content directory: %s";
    protected String couldNotCreateDomainContentDirectory$str() {
        return couldNotCreateDomainContentDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateDomainContentDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateDomainContentDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String logDirectoryIsNotADirectory = "WFLYHC0104: Log directory is not a directory: %s";
    protected String logDirectoryIsNotADirectory$str() {
        return logDirectoryIsNotADirectory;
    }
    @Override
    public final IllegalStateException logDirectoryIsNotADirectory(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), logDirectoryIsNotADirectory$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateLogDirectory = "WFLYHC0105: Could not create log directory: %s";
    protected String couldNotCreateLogDirectory$str() {
        return couldNotCreateLogDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateLogDirectory(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateLogDirectory$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serversDirectoryIsNotADirectory = "WFLYHC0106: Servers directory is not a directory: %s";
    protected String serversDirectoryIsNotADirectory$str() {
        return serversDirectoryIsNotADirectory;
    }
    @Override
    public final IllegalStateException serversDirectoryIsNotADirectory(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serversDirectoryIsNotADirectory$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateServersDirectory = "WFLYHC0107: Could not create servers directory: %s";
    protected String couldNotCreateServersDirectory$str() {
        return couldNotCreateServersDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateServersDirectory(final File f) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateServersDirectory$str(), f));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainTempDirectoryIsNotADirectory = "WFLYHC0108: Domain temp directory does not exist: %s";
    protected String domainTempDirectoryIsNotADirectory$str() {
        return domainTempDirectoryIsNotADirectory;
    }
    @Override
    public final IllegalStateException domainTempDirectoryIsNotADirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), domainTempDirectoryIsNotADirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateDomainTempDirectory = "WFLYHC0109: Could not create domain temp directory: %s";
    protected String couldNotCreateDomainTempDirectory$str() {
        return couldNotCreateDomainTempDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateDomainTempDirectory(final File file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateDomainTempDirectory$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sslFailureUnableToConnect = "WFLYHC0110: Unable to connect due to SSL failure.";
    protected String sslFailureUnableToConnect$str() {
        return sslFailureUnableToConnect;
    }
    @Override
    public final IllegalStateException sslFailureUnableToConnect(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sslFailureUnableToConnect$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jvmOptionAlreadyExists = "WFLYHC0111: Option '%s' already exists";
    protected String jvmOptionAlreadyExists$str() {
        return jvmOptionAlreadyExists;
    }
    @Override
    public final IllegalStateException jvmOptionAlreadyExists(final String option) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), jvmOptionAlreadyExists$str(), option));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedManagementVersionForHost = "WFLYHC0113: Host controller management version %s.%s is too old, Only %s.%s or higher are supported";
    protected String unsupportedManagementVersionForHost$str() {
        return unsupportedManagementVersionForHost;
    }
    @Override
    public final OperationFailedException unsupportedManagementVersionForHost(final int major, final int minor, final int minMajor, final int minMinor) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unsupportedManagementVersionForHost$str(), major, minor, minMajor, minMinor));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToAddExtensions = "WFLYHC0114: Failed to add extensions used by the domain. Failure description: %s";
    protected String failedToAddExtensions$str() {
        return failedToAddExtensions;
    }
    @Override
    public final IllegalStateException failedToAddExtensions(final ModelNode failureDescription) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToAddExtensions$str(), failureDescription));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String argumentHasNoValue = "WFLYHC0115: Argument %s has no value. %s";
    protected String argumentHasNoValue$str() {
        return argumentHasNoValue;
    }
    @Override
    public final String argumentHasNoValue(final String argument, final String usageNote) {
        return String.format(getLoggingLocale(), argumentHasNoValue$str(), argument, usageNote);
    }
    private static final String usageNote = "Use %s --help for information on valid command line arguments and their syntax.";
    protected String usageNote$str() {
        return usageNote;
    }
    @Override
    public final String usageNote(final String command) {
        return String.format(getLoggingLocale(), usageNote$str(), command);
    }
    private static final String cannotAccessS3File = "WFLYHC0116: Cannot access S3 file: %s";
    protected String cannotAccessS3File$str() {
        return cannotAccessS3File;
    }
    @Override
    public final IllegalStateException cannotAccessS3File(final String message) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAccessS3File$str(), message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedMarshallingDomainControllerData = "WFLYHC0117: Failed to obtain domain controller data from S3 file";
    protected String failedMarshallingDomainControllerData$str() {
        return failedMarshallingDomainControllerData;
    }
    @Override
    public final IllegalStateException failedMarshallingDomainControllerData() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedMarshallingDomainControllerData$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotWriteToS3File = "WFLYHC0118: Cannot write domain controller data to S3 file: %s";
    protected String cannotWriteToS3File$str() {
        return cannotWriteToS3File;
    }
    @Override
    public final IOException cannotWriteToS3File(final String message) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotWriteToS3File$str(), message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAccessS3Bucket = "WFLYHC0119: Cannot access S3 bucket '%s': %s";
    protected String cannotAccessS3Bucket$str() {
        return cannotAccessS3Bucket;
    }
    @Override
    public final IllegalStateException cannotAccessS3Bucket(final String location, final String message) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAccessS3Bucket$str(), location, message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String discoveryOptionsFailureUnableToConnect = "WFLYHC0120: Tried all domain controller discovery option(s) but unable to connect";
    protected String discoveryOptionsFailureUnableToConnect$str() {
        return discoveryOptionsFailureUnableToConnect;
    }
    @Override
    public final IllegalStateException discoveryOptionsFailureUnableToConnect(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), discoveryOptionsFailureUnableToConnect$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String preSignedUrlsMustHaveSamePath = "WFLYHC0121: pre_signed_put_url and pre_signed_delete_url must have the same path";
    protected String preSignedUrlsMustHaveSamePath$str() {
        return preSignedUrlsMustHaveSamePath;
    }
    @Override
    public final IllegalStateException preSignedUrlsMustHaveSamePath() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), preSignedUrlsMustHaveSamePath$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String preSignedUrlsMustBeSetOrUnset = "WFLYHC0122: pre_signed_put_url and pre_signed_delete_url must both be set or both unset";
    protected String preSignedUrlsMustBeSetOrUnset$str() {
        return preSignedUrlsMustBeSetOrUnset;
    }
    @Override
    public final IllegalStateException preSignedUrlsMustBeSetOrUnset() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), preSignedUrlsMustBeSetOrUnset$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String preSignedUrlMustPointToFile = "WFLYHC0123: pre-signed url %s must point to a file within a bucket";
    protected String preSignedUrlMustPointToFile$str() {
        return preSignedUrlMustPointToFile;
    }
    @Override
    public final IllegalStateException preSignedUrlMustPointToFile(final String preSignedUrl) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), preSignedUrlMustPointToFile$str(), preSignedUrl));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPreSignedUrl = "WFLYHC0124: pre-signed url %s is not a valid url";
    protected String invalidPreSignedUrl$str() {
        return invalidPreSignedUrl;
    }
    @Override
    public final IllegalStateException invalidPreSignedUrl(final String preSignedUrl) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidPreSignedUrl$str(), preSignedUrl));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPreSignedUrlLength = "WFLYHC0125: pre-signed url %s may only have a subdirectory under a bucket";
    protected String invalidPreSignedUrlLength$str() {
        return invalidPreSignedUrlLength;
    }
    @Override
    public final IllegalStateException invalidPreSignedUrlLength(final String preSignedUrl) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidPreSignedUrlLength$str(), preSignedUrl));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String creatingBucketWithUnsupportedCallingFormat = "WFLYHC0126: Creating location-constrained bucket with unsupported calling-format";
    protected String creatingBucketWithUnsupportedCallingFormat$str() {
        return creatingBucketWithUnsupportedCallingFormat;
    }
    @Override
    public final IllegalArgumentException creatingBucketWithUnsupportedCallingFormat() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), creatingBucketWithUnsupportedCallingFormat$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidS3Location = "WFLYHC0127: Invalid location: %s";
    protected String invalidS3Location$str() {
        return invalidS3Location;
    }
    @Override
    public final IllegalArgumentException invalidS3Location(final String location) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidS3Location$str(), location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidS3Bucket = "WFLYHC0128: Invalid bucket name: %s";
    protected String invalidS3Bucket$str() {
        return invalidS3Bucket;
    }
    @Override
    public final IllegalArgumentException invalidS3Bucket(final String bucket) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidS3Bucket$str(), bucket));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bucketAuthenticationFailure = "WFLYHC0129: bucket '%s' could not be accessed (rsp=%d (%s)). Maybe the bucket is owned by somebody else or the authentication failed";
    protected String bucketAuthenticationFailure$str() {
        return bucketAuthenticationFailure;
    }
    @Override
    public final IOException bucketAuthenticationFailure(final String bucket, final int httpCode, final String responseMessage) {
        final IOException result = new IOException(String.format(getLoggingLocale(), bucketAuthenticationFailure$str(), bucket, httpCode, responseMessage));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedResponse = "WFLYHC0130: Unexpected response: %s";
    protected String unexpectedResponse$str() {
        return unexpectedResponse;
    }
    @Override
    public final IOException unexpectedResponse(final String message) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unexpectedResponse$str(), message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String httpRedirectSupportRequired = "WFLYHC0131: HTTP redirect support required";
    protected String httpRedirectSupportRequired$str() {
        return httpRedirectSupportRequired;
    }
    @Override
    public final RuntimeException httpRedirectSupportRequired() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), httpRedirectSupportRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorParsingBucketListings = "WFLYHC0132: Unexpected error parsing bucket listing(s)";
    protected String errorParsingBucketListings$str() {
        return errorParsingBucketListings;
    }
    @Override
    public final RuntimeException errorParsingBucketListings(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorParsingBucketListings$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInitializeSaxDriver = "WFLYHC0133: Couldn't initialize a SAX driver for the XMLReader";
    protected String cannotInitializeSaxDriver$str() {
        return cannotInitializeSaxDriver;
    }
    @Override
    public final RuntimeException cannotInitializeSaxDriver() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotInitializeSaxDriver$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateDiscoveryOptionClass = "WFLYHC0134: Cannot instantiate discovery option class '%s': %s";
    protected String cannotInstantiateDiscoveryOptionClass$str() {
        return cannotInstantiateDiscoveryOptionClass;
    }
    @Override
    public final IllegalStateException cannotInstantiateDiscoveryOptionClass(final String className, final String message) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotInstantiateDiscoveryOptionClass$str(), className, message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotWriteDomainControllerData(final Exception e) {
        super.log.logf(FQCN, ERROR, null, cannotWriteDomainControllerData$str(), e);
    }
    private static final String cannotWriteDomainControllerData = "WFLYHC0137: Could not write domain controller data to S3 file. Error was: %s";
    protected String cannotWriteDomainControllerData$str() {
        return cannotWriteDomainControllerData;
    }
    @Override
    public final void cannotRemoveS3File(final Exception e) {
        super.log.logf(FQCN, ERROR, null, cannotRemoveS3File$str(), e);
    }
    private static final String cannotRemoveS3File = "WFLYHC0138: Could not remove S3 file. Error was: %s";
    protected String cannotRemoveS3File$str() {
        return cannotRemoveS3File;
    }
    private static final String cannotExecuteTransactionalOperationFromSlave = "WFLYHC0140: Can't execute transactional operation '%s' from slave controller";
    protected String cannotExecuteTransactionalOperationFromSlave$str() {
        return cannotExecuteTransactionalOperationFromSlave;
    }
    @Override
    public final IllegalStateException cannotExecuteTransactionalOperationFromSlave(final String operationName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotExecuteTransactionalOperationFromSlave$str(), operationName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToApplyDomainConfig(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToApplyDomainConfig0$str());
    }
    private static final String failedToApplyDomainConfig0 = "WFLYHC0142: Failed to apply domain-wide configuration from master host controller";
    protected String failedToApplyDomainConfig0$str() {
        return failedToApplyDomainConfig0;
    }
    @Override
    public final void failedToApplyDomainConfig(final String outcome, final ModelNode failureDescription) {
        super.log.logf(FQCN, ERROR, null, failedToApplyDomainConfig2$str(), outcome, failureDescription);
    }
    private static final String failedToApplyDomainConfig2 = "WFLYHC0143: Failed to apply domain-wide configuration from master host controller. Operation outcome: %s. Failure description %s";
    protected String failedToApplyDomainConfig2$str() {
        return failedToApplyDomainConfig2;
    }
    @Override
    public final void fetchConfigFromDomainMasterFailed(final RunningMode currentRunningMode, final String policyAttribute, final AdminOnlyDomainConfigPolicy policy, final String cachedDcCmdLineArg) {
        super.log.logf(FQCN, ERROR, null, fetchConfigFromDomainMasterFailed$str(), currentRunningMode, policyAttribute, policy, cachedDcCmdLineArg);
    }
    private static final String fetchConfigFromDomainMasterFailed = "WFLYHC0144: The host cannot start because it was started in running mode '%s' with no access to a local copy of the domain wide configuration policy, the '%s' attribute was set to '%s' and the domain wide configuration policy could not be obtained from the Domain Controller host. Startup will be aborted. Use the '%s' command line argument to start if you need to start without connecting to a domain controller connection.";
    protected String fetchConfigFromDomainMasterFailed$str() {
        return fetchConfigFromDomainMasterFailed;
    }
    @Override
    public final void noAccessControlConfigurationAvailable(final RunningMode currentRunningMode, final String policyAttribute, final AdminOnlyDomainConfigPolicy policy, final String cachedDcCmdLineArg, final RunningMode desiredRunningMode) {
        super.log.logf(FQCN, ERROR, null, noAccessControlConfigurationAvailable$str(), currentRunningMode, policyAttribute, policy, cachedDcCmdLineArg, desiredRunningMode);
    }
    private static final String noAccessControlConfigurationAvailable = "WFLYHC0145: The host cannot start because it was started in running mode '%s' with no access to a local copy of the domain wide configuration policy, and the '%s' attribute was set to '%s'. Startup will be aborted. Use the '%s' command line argument to start in running mode '%s'.";
    protected String noAccessControlConfigurationAvailable$str() {
        return noAccessControlConfigurationAvailable;
    }
    @Override
    public final void failedDiscoveringMaster(final DiscoveryOption option, final Exception e) {
        super.log.logf(FQCN, WARN, null, failedDiscoveringMaster$str(), option, e);
    }
    private static final String failedDiscoveringMaster = "WFLYHC0146: Could not discover master using discovery option %s. Error was: %s";
    protected String failedDiscoveringMaster$str() {
        return failedDiscoveringMaster;
    }
    @Override
    public final void noDiscoveryOptionsLeft() {
        super.log.logf(FQCN, WARN, null, noDiscoveryOptionsLeft$str());
    }
    private static final String noDiscoveryOptionsLeft = "WFLYHC0147: No domain controller discovery options remain.";
    protected String noDiscoveryOptionsLeft$str() {
        return noDiscoveryOptionsLeft;
    }
    @Override
    public final void connectedToMaster(final URI uri) {
        super.log.logf(FQCN, INFO, null, connectedToMaster$str(), uri);
    }
    private static final String connectedToMaster = "WFLYHC0148: Connected to master host controller at %s";
    protected String connectedToMaster$str() {
        return connectedToMaster;
    }
    @Override
    public final void usingCachedDC(final String configOption, final String cachedXmlFile) {
        super.log.logf(FQCN, INFO, null, usingCachedDC$str(), configOption, cachedXmlFile);
    }
    private static final String usingCachedDC = "WFLYHC0149: Option %s was set; obtaining domain-wide configuration from %s";
    protected String usingCachedDC$str() {
        return usingCachedDC;
    }
    @Override
    public final void reconnectingToMaster() {
        super.log.logf(FQCN, INFO, null, reconnectingToMaster$str());
    }
    private static final String reconnectingToMaster = "WFLYHC0150: Trying to reconnect to master host controller.";
    protected String reconnectingToMaster$str() {
        return reconnectingToMaster;
    }
    @Override
    public final void noDomainControllerConfigurationProvidedForAdminOnly(final String policyAttribute, final AdminOnlyDomainConfigPolicy policy, final String cachedDcCmdLineArg, final RunningMode desiredRunningMode) {
        super.log.logf(FQCN, ERROR, null, noDomainControllerConfigurationProvidedForAdminOnly$str(), policyAttribute, policy, cachedDcCmdLineArg, desiredRunningMode);
    }
    private static final String noDomainControllerConfigurationProvidedForAdminOnly = "WFLYHC0151: No domain controller discovery configuration was provided and the '%s' attribute was set to '%s'. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.";
    protected String noDomainControllerConfigurationProvidedForAdminOnly$str() {
        return noDomainControllerConfigurationProvidedForAdminOnly;
    }
    @Override
    public final void serverLaunchCommandPrefix(final String serverName, final String launchCommandPrefix) {
        super.log.logf(FQCN, INFO, null, serverLaunchCommandPrefix$str(), serverName, launchCommandPrefix);
    }
    private static final String serverLaunchCommandPrefix = "WFLYHC0152: Server %s will be started with JVM launch command prefix '%s'";
    protected String serverLaunchCommandPrefix$str() {
        return serverLaunchCommandPrefix;
    }
    private static final String channelClosed = "WFLYHC0153: Channel closed";
    protected String channelClosed$str() {
        return channelClosed;
    }
    @Override
    public final IOException channelClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), channelClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateDomainAutoStartDirectory = "WFLYHC0157: Could not create domain auto-start directory: %s";
    protected String couldNotCreateDomainAutoStartDirectory$str() {
        return couldNotCreateDomainAutoStartDirectory;
    }
    @Override
    public final IllegalStateException couldNotCreateDomainAutoStartDirectory(final Path file, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotCreateDomainAutoStartDirectory$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotPersistAutoStartServerStatus(final Throwable cause) {
        super.log.logf(FQCN, INFO, cause, couldNotPersistAutoStartServerStatus$str());
    }
    private static final String couldNotPersistAutoStartServerStatus = "WFLYHC0158: Error persisting server autostart status";
    protected String couldNotPersistAutoStartServerStatus$str() {
        return couldNotPersistAutoStartServerStatus;
    }
    private static final String invalidDiscoveryType = "WFLYHC0159: Invalid discovery type %s";
    protected String invalidDiscoveryType$str() {
        return invalidDiscoveryType;
    }
    @Override
    public final String invalidDiscoveryType(final String type) {
        return String.format(getLoggingLocale(), invalidDiscoveryType$str(), type);
    }
    private static final String couldNotObtainDomainUuid = "WFLYHC0160: Could not read or create the domain UUID in file: %s";
    protected String couldNotObtainDomainUuid$str() {
        return couldNotObtainDomainUuid;
    }
    @Override
    public final IllegalStateException couldNotObtainDomainUuid(final Throwable cause, final Path file) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotObtainDomainUuid$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bindingNameNotUnique = "WFLYHC0162: The binding name '%s' in socket binding group '%s' is not unique. Names must be unique across socket-binding, local-destination-outbound-socket-binding and remote-destination-outbound-socket-binding";
    protected String bindingNameNotUnique$str() {
        return bindingNameNotUnique;
    }
    @Override
    public final OperationFailedException bindingNameNotUnique(final String name, final String groupName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), bindingNameNotUnique$str(), name, groupName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String profileInvolvedInACycle = "WFLYHC0163: Profile '%s' is involved in a cycle";
    protected String profileInvolvedInACycle$str() {
        return profileInvolvedInACycle;
    }
    @Override
    public final OperationFailedException profileInvolvedInACycle(final String profile) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), profileInvolvedInACycle$str(), profile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String profileAttemptingToOverrideSubsystem = "WFLYHC0164: Profile '%s' defines subsystem '%s' which is also defined in its ancestor profile '%s'. Overriding subsystems is not supported";
    protected String profileAttemptingToOverrideSubsystem$str() {
        return profileAttemptingToOverrideSubsystem;
    }
    @Override
    public final OperationFailedException profileAttemptingToOverrideSubsystem(final String existingSubsystemProfile, final String subsystem, final String profileName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), profileAttemptingToOverrideSubsystem$str(), existingSubsystemProfile, subsystem, profileName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String socketBindingGroupInvolvedInACycle = "WFLYHC0165: Socket binding group '%s' is involved in a cycle";
    protected String socketBindingGroupInvolvedInACycle$str() {
        return socketBindingGroupInvolvedInACycle;
    }
    @Override
    public final OperationFailedException socketBindingGroupInvolvedInACycle(final String include) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), socketBindingGroupInvolvedInACycle$str(), include));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String socketBindingGroupAttemptingToOverrideSocketBinding = "WFLYHC0166: Socket binding group '%s' defines socket binding '%s' which is also defined in its ancestor socket binding group '%s'. Overriding socket bindings is not supported";
    protected String socketBindingGroupAttemptingToOverrideSocketBinding$str() {
        return socketBindingGroupAttemptingToOverrideSocketBinding;
    }
    @Override
    public final OperationFailedException socketBindingGroupAttemptingToOverrideSocketBinding(final String existingSubsystemProfile, final String child, final String resourceName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), socketBindingGroupAttemptingToOverrideSocketBinding$str(), existingSubsystemProfile, child, resourceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String profileIncludesSameSubsystem = "WFLYHC0167: Profile '%s' includes profile '%s' and profile '%s'. Both these profiles define subsystem '%s', which is not supported";
    protected String profileIncludesSameSubsystem$str() {
        return profileIncludesSameSubsystem;
    }
    @Override
    public final OperationFailedException profileIncludesSameSubsystem(final String profile, final String include1, final String include2, final String child) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), profileIncludesSameSubsystem$str(), profile, include1, include2, child));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String socketBindingGroupIncludesSameSocketBinding = "WFLYHC0168: Socket binding group '%s' includes socket binding group '%s' and socket binding group '%s'. Both these socket binding groups define socket binding '%s', which is not supported";
    protected String socketBindingGroupIncludesSameSocketBinding$str() {
        return socketBindingGroupIncludesSameSocketBinding;
    }
    @Override
    public final OperationFailedException socketBindingGroupIncludesSameSocketBinding(final String socketBindingGroup, final String include1, final String include2, final String child) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), socketBindingGroupIncludesSameSocketBinding$str(), socketBindingGroup, include1, include2, child));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String embeddedHostControllerRestartMustProvideAdminOnlyTrue = "WFLYHC0169: Reload into running mode is not supported with embedded host controller, admin-only=true must be specified.";
    protected String embeddedHostControllerRestartMustProvideAdminOnlyTrue$str() {
        return embeddedHostControllerRestartMustProvideAdminOnlyTrue;
    }
    @Override
    public final OperationFailedException embeddedHostControllerRestartMustProvideAdminOnlyTrue() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), embeddedHostControllerRestartMustProvideAdminOnlyTrue$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hostRegistrationCannotReleaseSharedLock = "WFLYHC0170: Error releasing shared lock after host registration for operationID: %s";
    protected String hostRegistrationCannotReleaseSharedLock$str() {
        return hostRegistrationCannotReleaseSharedLock;
    }
    @Override
    public final String hostRegistrationCannotReleaseSharedLock(final int operationID) {
        return String.format(getLoggingLocale(), hostRegistrationCannotReleaseSharedLock$str(), operationID);
    }
    @Override
    public final void suspendListenerFailed(final ExecutionException cause, final String serverName) {
        super.log.logf(FQCN, ERROR, cause, suspendListenerFailed$str(), serverName);
    }
    private static final String suspendListenerFailed = "WFLYHC0171: Failed getting the response from the suspend listener for server: %s";
    protected String suspendListenerFailed$str() {
        return suspendListenerFailed;
    }
    @Override
    public final void suspendExecutionFailed(final IOException cause, final String serverName) {
        super.log.logf(FQCN, ERROR, cause, suspendExecutionFailed$str(), serverName);
    }
    private static final String suspendExecutionFailed = "WFLYHC0172: Failed executing the suspend operation for server: %s";
    protected String suspendExecutionFailed$str() {
        return suspendExecutionFailed;
    }
    private static final String cannotBothHaveFalseUseCurrentHostConfigAndHostConfig = "WFLYHC0173: It is not possible to use use-current-host-config=false while specifying a host-config";
    protected String cannotBothHaveFalseUseCurrentHostConfigAndHostConfig$str() {
        return cannotBothHaveFalseUseCurrentHostConfigAndHostConfig;
    }
    @Override
    public final OperationFailedException cannotBothHaveFalseUseCurrentHostConfigAndHostConfig() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotBothHaveFalseUseCurrentHostConfigAndHostConfig$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig = "WFLYHC0174: It is not possible to use use-current-domain-config=false while specifying a domain-config";
    protected String cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig$str() {
        return cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig;
    }
    @Override
    public final OperationFailedException cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainConfigForReloadNotFound = "WFLYHC0175: domain-config '%s' specified for reload could not be found";
    protected String domainConfigForReloadNotFound$str() {
        return domainConfigForReloadNotFound;
    }
    @Override
    public final OperationFailedException domainConfigForReloadNotFound(final String serverConfig) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), domainConfigForReloadNotFound$str(), serverConfig));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void nativeManagementInterfaceIsUnsecured() {
        super.log.logf(FQCN, WARN, null, nativeManagementInterfaceIsUnsecured$str());
    }
    private static final String nativeManagementInterfaceIsUnsecured = "WFLYHC0177: No security realm defined for native management service; all access will be unrestricted.";
    protected String nativeManagementInterfaceIsUnsecured$str() {
        return nativeManagementInterfaceIsUnsecured;
    }
    @Override
    public final void aborting(final int code) {
        super.log.logf(FQCN, FATAL, null, aborting$str(), code);
    }
    private static final String aborting = "WFLYHC0178: Aborting with exit code %d";
    protected String aborting$str() {
        return aborting;
    }
    @Override
    public final void shuttingDownInResponseToProcessControllerSignal() {
        super.log.logf(FQCN, INFO, null, shuttingDownInResponseToProcessControllerSignal$str());
    }
    private static final String shuttingDownInResponseToProcessControllerSignal = "WFLYHC0179: ProcessController has signalled to shut down; shutting down";
    protected String shuttingDownInResponseToProcessControllerSignal$str() {
        return shuttingDownInResponseToProcessControllerSignal;
    }
    @Override
    public final void shuttingDownInResponseToManagementRequest(final String op) {
        super.log.logf(FQCN, INFO, null, shuttingDownInResponseToManagementRequest$str(), op);
    }
    private static final String shuttingDownInResponseToManagementRequest = "WFLYHC0180: Shutting down in response to management operation '%s'";
    protected String shuttingDownInResponseToManagementRequest$str() {
        return shuttingDownInResponseToManagementRequest;
    }
    @Override
    public final void shutdownHookInvoked() {
        super.log.logf(FQCN, INFO, null, shutdownHookInvoked$str());
    }
    private static final String shutdownHookInvoked = "WFLYHC0181: Host Controller shutdown has been requested via an OS signal";
    protected String shutdownHookInvoked$str() {
        return shutdownHookInvoked;
    }
    @Override
    public final void timedOutAwaitingSuspendResponse(final int blockingTimeout, final String serverName) {
        super.log.logf(FQCN, INFO, null, timedOutAwaitingSuspendResponse$str(), blockingTimeout, serverName);
    }
    private static final String timedOutAwaitingSuspendResponse = "WFLYHC0182: Timed out after %d ms awaiting server suspend response(s) for server: %s";
    protected String timedOutAwaitingSuspendResponse$str() {
        return timedOutAwaitingSuspendResponse;
    }
    private static final String timedOutAwaitingSuspendResponseMsg = "WFLYHC0183: Timed out after %d ms awaiting server suspend response(s) for server: %s";
    protected String timedOutAwaitingSuspendResponseMsg$str() {
        return timedOutAwaitingSuspendResponseMsg;
    }
    @Override
    public final String timedOutAwaitingSuspendResponseMsg(final int blockingTimeout, final String serverName) {
        return String.format(getLoggingLocale(), timedOutAwaitingSuspendResponseMsg$str(), blockingTimeout, serverName);
    }
    @Override
    public final void interruptedAwaitingSuspendResponse(final InterruptedException cause, final String serverName) {
        super.log.logf(FQCN, INFO, cause, interruptedAwaitingSuspendResponse$str(), serverName);
    }
    private static final String interruptedAwaitingSuspendResponse = "WFLYHC0184: %s interrupted awaiting server suspend response(s)";
    protected String interruptedAwaitingSuspendResponse$str() {
        return interruptedAwaitingSuspendResponse;
    }
    private static final String interruptedAwaitingSuspendResponseMsg = "WFLYHC0185: %s interrupted awaiting server suspend response(s)";
    protected String interruptedAwaitingSuspendResponseMsg$str() {
        return interruptedAwaitingSuspendResponseMsg;
    }
    @Override
    public final String interruptedAwaitingSuspendResponseMsg(final String serverName) {
        return String.format(getLoggingLocale(), interruptedAwaitingSuspendResponseMsg$str(), serverName);
    }
    private static final String suspendExecutionFailedMsg = "WFLYHC0186: Failed executing the suspend operation for server: %s";
    protected String suspendExecutionFailedMsg$str() {
        return suspendExecutionFailedMsg;
    }
    @Override
    public final String suspendExecutionFailedMsg(final String serverName) {
        return String.format(getLoggingLocale(), suspendExecutionFailedMsg$str(), serverName);
    }
    private static final String suspendListenerFailedMsg = "WFLYHC0187: Failed getting the response from the suspend listener for server: %s";
    protected String suspendListenerFailedMsg$str() {
        return suspendListenerFailedMsg;
    }
    @Override
    public final String suspendListenerFailedMsg(final String serverName) {
        return String.format(getLoggingLocale(), suspendListenerFailedMsg$str(), serverName);
    }
    @Override
    public final void timedOutAwaitingResumeResponse(final int blockingTimeout, final String serverName) {
        super.log.logf(FQCN, INFO, null, timedOutAwaitingResumeResponse$str(), blockingTimeout, serverName);
    }
    private static final String timedOutAwaitingResumeResponse = "WFLYHC0188: Timed out after %d ms awaiting server resume response(s) for server: %s";
    protected String timedOutAwaitingResumeResponse$str() {
        return timedOutAwaitingResumeResponse;
    }
    private static final String timedOutAwaitingResumeResponseMsg = "WFLYHC0189: Timed out after %d ms awaiting server resume response(s) for server: %s";
    protected String timedOutAwaitingResumeResponseMsg$str() {
        return timedOutAwaitingResumeResponseMsg;
    }
    @Override
    public final String timedOutAwaitingResumeResponseMsg(final int blockingTimeout, final String serverName) {
        return String.format(getLoggingLocale(), timedOutAwaitingResumeResponseMsg$str(), blockingTimeout, serverName);
    }
    @Override
    public final void interruptedAwaitingResumeResponse(final InterruptedException cause, final String serverName) {
        super.log.logf(FQCN, INFO, cause, interruptedAwaitingResumeResponse$str(), serverName);
    }
    private static final String interruptedAwaitingResumeResponse = "WFLYHC0190: %s interrupted awaiting server resume response(s)";
    protected String interruptedAwaitingResumeResponse$str() {
        return interruptedAwaitingResumeResponse;
    }
    private static final String interruptedAwaitingResumeResponseMsg = "WFLYHC0191: %s interrupted awaiting server resume response(s)";
    protected String interruptedAwaitingResumeResponseMsg$str() {
        return interruptedAwaitingResumeResponseMsg;
    }
    @Override
    public final String interruptedAwaitingResumeResponseMsg(final String serverName) {
        return String.format(getLoggingLocale(), interruptedAwaitingResumeResponseMsg$str(), serverName);
    }
    private static final String resumeExecutionFailedMsg = "WFLYHC0192: Failed executing the resume operation for server: %s";
    protected String resumeExecutionFailedMsg$str() {
        return resumeExecutionFailedMsg;
    }
    @Override
    public final String resumeExecutionFailedMsg(final String serverName) {
        return String.format(getLoggingLocale(), resumeExecutionFailedMsg$str(), serverName);
    }
    private static final String resumeListenerFailedMsg = "WFLYHC0193: Failed getting the response from the resume listener for server: %s";
    protected String resumeListenerFailedMsg$str() {
        return resumeListenerFailedMsg;
    }
    @Override
    public final String resumeListenerFailedMsg(final String serverName) {
        return String.format(getLoggingLocale(), resumeListenerFailedMsg$str(), serverName);
    }
    @Override
    public final void resumeExecutionFailed(final IOException cause, final String serverName) {
        super.log.logf(FQCN, ERROR, cause, resumeExecutionFailed$str(), serverName);
    }
    private static final String resumeExecutionFailed = "WFLYHC0194: Failed executing the resume operation for server: %s";
    protected String resumeExecutionFailed$str() {
        return resumeExecutionFailed;
    }
    @Override
    public final void resumeListenerFailed(final ExecutionException cause, final String serverName) {
        super.log.logf(FQCN, ERROR, cause, resumeListenerFailed$str(), serverName);
    }
    private static final String resumeListenerFailed = "WFLYHC0195: Failed getting the response from the resume listener for server: %s";
    protected String resumeListenerFailed$str() {
        return resumeListenerFailed;
    }
    @Override
    public final void cannotRenameCachedDomainXmlOnBoot(final String tmpFilename, final String destFilename, final String reason) {
        super.log.logf(FQCN, ERROR, null, cannotRenameCachedDomainXmlOnBoot$str(), tmpFilename, destFilename, reason);
    }
    private static final String cannotRenameCachedDomainXmlOnBoot = "WFLYHC0196: Cannot move the file %s to %s, unable to persist domain configuration changes: %s ";
    protected String cannotRenameCachedDomainXmlOnBoot$str() {
        return cannotRenameCachedDomainXmlOnBoot;
    }
    private static final String attributeRequiresSSLContext = "WFLYHC0197: If attribute %s is defined one of ssl-context or security-realm must also be defined";
    protected String attributeRequiresSSLContext$str() {
        return attributeRequiresSSLContext;
    }
    @Override
    public final OperationFailedException attributeRequiresSSLContext(final String attribute) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), attributeRequiresSSLContext$str(), attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void managedServerUnstable(final String serverName) {
        super.log.logf(FQCN, WARN, null, managedServerUnstable1$str(), serverName);
    }
    private static final String managedServerUnstable1 = "WFLYHC0198: Server '%s' is unstable and should be stopped or restarted. An unstable server may not stop normally, so the 'kill' operation may be required to terminate the server process.";
    protected String managedServerUnstable1$str() {
        return managedServerUnstable1;
    }
    @Override
    public final void managedServerUnstable(final String serverName, final String hostName) {
        super.log.logf(FQCN, WARN, null, managedServerUnstable2$str(), serverName, hostName);
    }
    private static final String managedServerUnstable2 = "WFLYHC0198: Server '%s' (managed by host '%s') is unstable and should be stopped or restarted. An unstable server may not stop normally, so the 'kill' operation may be required to terminate the server process.";
    protected String managedServerUnstable2$str() {
        return managedServerUnstable2;
    }
    @Override
    public final void serverSuspected(final String serverName, final String hostName) {
        super.log.logf(FQCN, WARN, null, serverSuspected$str(), serverName, hostName);
    }
    private static final String serverSuspected = "WFLYHC0199: Server '%s' (managed by host '%s') has not responded to an operation request within the configured timeout. This may mean the server has become unstable.";
    protected String serverSuspected$str() {
        return serverSuspected;
    }
    @Override
    public final void failedReportingServerInstabilityToMaster(final Exception e, final String serverName) {
        super.log.logf(FQCN, ERROR, e, failedReportingServerInstabilityToMaster$str(), serverName);
    }
    private static final String failedReportingServerInstabilityToMaster = "WFLYHC0200: Reporting instability of server '%s' to Domain Controller failed.";
    protected String failedReportingServerInstabilityToMaster$str() {
        return failedReportingServerInstabilityToMaster;
    }
    private static final String hostDomainSynchronizationError = "WFLYHC0201: Error synchronizing the host model with the domain controller model with failure : %s.";
    protected String hostDomainSynchronizationError$str() {
        return hostDomainSynchronizationError;
    }
    @Override
    public final String hostDomainSynchronizationError(final String failureDescription) {
        return String.format(getLoggingLocale(), hostDomainSynchronizationError$str(), failureDescription);
    }
    @Override
    public final void domainModelAppliedButReloadIsRequired() {
        super.log.logf(FQCN, WARN, null, domainModelAppliedButReloadIsRequired$str());
    }
    private static final String domainModelAppliedButReloadIsRequired = "WFLYHC0202: The domain configuration was successfully applied, but reload is required before changes become active.";
    protected String domainModelAppliedButReloadIsRequired$str() {
        return domainModelAppliedButReloadIsRequired;
    }
    @Override
    public final void domainModelAppliedButRestartIsRequired() {
        super.log.logf(FQCN, WARN, null, domainModelAppliedButRestartIsRequired$str());
    }
    private static final String domainModelAppliedButRestartIsRequired = "WFLYHC0203: The domain configuration was successfully applied, but restart is required before changes become active.";
    protected String domainModelAppliedButRestartIsRequired$str() {
        return domainModelAppliedButRestartIsRequired;
    }
    @Override
    public final void serverLoggingConfigurationFileNotFound(final String serverName) {
        super.log.logf(FQCN, WARN, null, serverLoggingConfigurationFileNotFound$str(), serverName);
    }
    private static final String serverLoggingConfigurationFileNotFound = "WFLYHC0204: No logging configuration file could be found for the servers initial boot. Logging will not be configured until the logging subsystem is activated for the server %s";
    protected String serverLoggingConfigurationFileNotFound$str() {
        return serverLoggingConfigurationFileNotFound;
    }
    @Override
    public final void failedToSetLoggingConfiguration(final Throwable cause, final String serverName, final File path) {
        super.log.logf(FQCN, ERROR, cause, failedToSetLoggingConfiguration$str(), serverName, path);
    }
    private static final String failedToSetLoggingConfiguration = "WFLYHC0205: An error occurred setting the -Dlogging.configuration property for server %s. Configuration path %s";
    protected String failedToSetLoggingConfiguration$str() {
        return failedToSetLoggingConfiguration;
    }
    private static final String cannotOverwriteDomainXmlWithEmpty = "WFLYHC0206: File %s already exists, you must use --remove-existing-domain-config to overwrite existing files.";
    protected String cannotOverwriteDomainXmlWithEmpty$str() {
        return cannotOverwriteDomainXmlWithEmpty;
    }
    @Override
    public final IllegalStateException cannotOverwriteDomainXmlWithEmpty(final String filename) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotOverwriteDomainXmlWithEmpty$str(), filename));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotOverwriteHostXmlWithEmpty = "WFLYHC0207: File %s already exists, you must use --remove-existing-host-config to overwrite existing files.";
    protected String cannotOverwriteHostXmlWithEmpty$str() {
        return cannotOverwriteHostXmlWithEmpty;
    }
    @Override
    public final IllegalStateException cannotOverwriteHostXmlWithEmpty(final String filename) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotOverwriteHostXmlWithEmpty$str(), filename));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddHostAlreadyRegistered = "WFLYHC0208: A host (%s) has already been registered. You must shutdown this host before adding a new one.";
    protected String cannotAddHostAlreadyRegistered$str() {
        return cannotAddHostAlreadyRegistered;
    }
    @Override
    public final OperationFailedException cannotAddHostAlreadyRegistered(final String existingName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddHostAlreadyRegistered$str(), existingName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullHostName = "WFLYHC0209: Host name may not be null.";
    protected String nullHostName$str() {
        return nullHostName;
    }
    @Override
    public final OperationFailedException nullHostName() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), nullHostName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddSlaveHostAfterBoot = "WFLYHC0210: A slave host controller may not be added using add(). Please add a host, omitting this parameter, and configure the remote domain controller using write-attribute.";
    protected String cannotAddSlaveHostAfterBoot$str() {
        return cannotAddSlaveHostAfterBoot;
    }
    @Override
    public final OperationFailedException cannotAddSlaveHostAfterBoot() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotAddSlaveHostAfterBoot$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bootConfigValidationFailed = "WFLYHC0211: Boot configuration validation failed";
    protected String bootConfigValidationFailed$str() {
        return bootConfigValidationFailed;
    }
    @Override
    public final OperationFailedException bootConfigValidationFailed(final ModelNode failureDescription) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), bootConfigValidationFailed$str()), failureDescription);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fetchOfMissingConfigurationFailed = "WFLYHC0212: Fetch of missing configuration from the master Host Controller failed without explanation. Fetch operation outcome was %s";
    protected String fetchOfMissingConfigurationFailed$str() {
        return fetchOfMissingConfigurationFailed;
    }
    @Override
    public final OperationFailedException fetchOfMissingConfigurationFailed(final String failedOutcome) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), fetchOfMissingConfigurationFailed$str(), failedOutcome));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
