/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.io.WorkerAdd;
import org.wildfly.extension.io.WorkerServerDefinition;
import org.wildfly.extension.io.logging.IOLogger;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.management.XnioWorkerMXBean;

class WorkerResourceDefinition
extends PersistentResourceDefinition {
    static final String IO_WORKER_RUNTIME_CAPABILITY_NAME = "org.wildfly.io.worker";
    static final RuntimeCapability<Void> IO_WORKER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.io.worker", (boolean)true, XnioWorker.class).build();
    static final OptionAttributeDefinition WORKER_TASK_MAX_THREADS = ((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("task-max-threads", Options.WORKER_TASK_MAX_THREADS).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final OptionAttributeDefinition WORKER_TASK_KEEPALIVE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("task-keepalive", Options.WORKER_TASK_KEEPALIVE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(60))).build();
    static final OptionAttributeDefinition STACK_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("stack-size", Options.STACK_SIZE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(0L))).build();
    static final OptionAttributeDefinition WORKER_IO_THREADS = ((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("io-threads", Options.WORKER_IO_THREADS).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static OptionAttributeDefinition[] ATTRIBUTES = new OptionAttributeDefinition[]{WORKER_IO_THREADS, WORKER_TASK_KEEPALIVE, WORKER_TASK_MAX_THREADS, STACK_SIZE};
    private static final AttributeDefinition SHUTDOWN_REQUESTED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("shutdown-requested", ModelType.BOOLEAN).setStorageRuntime()).build();
    private static final AttributeDefinition CORE_WORKER_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("core-pool-size", ModelType.INT).setStorageRuntime()).build();
    private static final AttributeDefinition MAX_WORKER_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-pool-size", ModelType.INT).setStorageRuntime()).build();
    private static final AttributeDefinition IO_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("io-thread-count", ModelType.INT).setStorageRuntime()).build();
    private static final AttributeDefinition QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("queue-size", ModelType.INT).setStorageRuntime()).build();
    static final Map<String, OptionAttributeDefinition> ATTRIBUTES_BY_XMLNAME;
    static final WorkerResourceDefinition INSTANCE;

    private WorkerResourceDefinition() {
        super(IOExtension.WORKER_PATH, (ResourceDescriptionResolver)IOExtension.getResolver("worker"), (OperationStepHandler)WorkerAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_BY_XMLNAME.values();
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(IO_WORKER_RUNTIME_CAPABILITY);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (OptionAttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)attr, (OperationStepHandler)new WorkerReadAttributeHandler(attr.getOption()));
        }
        WorkerMetricsHandler metricsHandler = new WorkerMetricsHandler();
        resourceRegistration.registerMetric(SHUTDOWN_REQUESTED, (OperationStepHandler)metricsHandler);
        resourceRegistration.registerMetric(CORE_WORKER_POOL_SIZE, (OperationStepHandler)metricsHandler);
        resourceRegistration.registerMetric(MAX_WORKER_POOL_SIZE, (OperationStepHandler)metricsHandler);
        resourceRegistration.registerMetric(IO_THREAD_COUNT, (OperationStepHandler)metricsHandler);
        resourceRegistration.registerMetric(QUEUE_SIZE, (OperationStepHandler)metricsHandler);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new WorkerServerDefinition());
    }

    static XnioWorker getXnioWorker(OperationContext context) {
        String name = context.getCurrentAddressValue();
        if (!context.getCurrentAddress().getLastElement().getKey().equals(IOExtension.WORKER_PATH.getKey())) {
            for (PathElement pe : context.getCurrentAddress()) {
                if (!pe.getKey().equals(IOExtension.WORKER_PATH.getKey())) continue;
                name = pe.getValue();
                break;
            }
        }
        return WorkerResourceDefinition.getXnioWorker(context.getServiceRegistry(false), name);
    }

    static XnioWorker getXnioWorker(ServiceRegistry serviceRegistry, String name) {
        ServiceName serviceName = IO_WORKER_RUNTIME_CAPABILITY.getCapabilityServiceName(name, XnioWorker.class);
        ServiceController controller = serviceRegistry.getService(serviceName);
        if (controller == null || controller.getState() != ServiceController.State.UP) {
            return null;
        }
        return (XnioWorker)controller.getValue();
    }

    private static XnioWorkerMXBean getMetrics(ServiceRegistry serviceRegistry, String name) {
        XnioWorker worker = WorkerResourceDefinition.getXnioWorker(serviceRegistry, name);
        if (worker != null && worker.getMXBean() != null) {
            return worker.getMXBean();
        }
        return null;
    }

    private static ModelNode getMetricValue(String attributeName, XnioWorkerMXBean metric) throws OperationFailedException {
        if (SHUTDOWN_REQUESTED.getName().equals(attributeName)) {
            return new ModelNode(metric.isShutdownRequested());
        }
        if (CORE_WORKER_POOL_SIZE.getName().equals(attributeName)) {
            return new ModelNode(metric.getCoreWorkerPoolSize());
        }
        if (MAX_WORKER_POOL_SIZE.getName().equals(attributeName)) {
            return new ModelNode(metric.getMaxWorkerPoolSize());
        }
        if (IO_THREAD_COUNT.getName().equals(attributeName)) {
            return new ModelNode(metric.getIoThreadCount());
        }
        if (QUEUE_SIZE.getName().equals(attributeName)) {
            return new ModelNode(metric.getWorkerQueueSize());
        }
        throw new OperationFailedException(IOLogger.ROOT_LOGGER.noMetrics());
    }

    static {
        HashMap<String, OptionAttributeDefinition> attrs = new HashMap<String, OptionAttributeDefinition>();
        for (OptionAttributeDefinition attr : ATTRIBUTES) {
            attrs.put(attr.getXmlName(), attr);
        }
        ATTRIBUTES_BY_XMLNAME = Collections.unmodifiableMap(attrs);
        INSTANCE = new WorkerResourceDefinition();
    }

    static class WorkerResource
    extends DelegatingResource {
        private final ServiceRegistry serviceRegistry;
        private final PathAddress pathAddress;

        public WorkerResource(OperationContext context) {
            super(Resource.Factory.create());
            this.serviceRegistry = context.getServiceRegistry(false);
            this.pathAddress = context.getCurrentAddress();
            super.registerResourceProvider("server", new ResourceProvider(){

                public boolean has(String name) {
                    return this.children().contains(name);
                }

                public Resource get(String name) {
                    return PlaceholderResource.INSTANCE;
                }

                public boolean hasChildren() {
                    return false;
                }

                public Set<String> children() {
                    XnioWorkerMXBean metrics = WorkerResourceDefinition.getMetrics(serviceRegistry, pathAddress.getLastElement().getValue());
                    if (metrics == null) {
                        return Collections.emptySet();
                    }
                    LinkedHashSet<String> res = new LinkedHashSet<String>();
                    metrics.getServerMXBeans().forEach(serverMXBean -> res.add(serverMXBean.getBindAddress()));
                    return res;
                }

                public void register(String name, Resource resource) {
                    throw new UnsupportedOperationException();
                }

                public void register(String value, int index, Resource resource) {
                    throw new UnsupportedOperationException();
                }

                public Resource remove(String name) {
                    return null;
                }

                public ResourceProvider clone() {
                    return this;
                }
            });
        }

        public Set<String> getChildTypes() {
            return Collections.singleton("server");
        }
    }

    private static class WorkerMetricsHandler
    extends AbstractWorkerAttributeHandler {
        private WorkerMetricsHandler() {
        }

        @Override
        void executeWithWorker(OperationContext context, ModelNode operation, XnioWorker worker) throws OperationFailedException {
            XnioWorkerMXBean metrics = worker.getMXBean();
            String name = operation.require("name").asString();
            context.getResult().set(WorkerResourceDefinition.getMetricValue(name, metrics));
        }
    }

    private static class WorkerReadAttributeHandler
    extends AbstractWorkerAttributeHandler {
        final Option<?> option;

        public WorkerReadAttributeHandler(Option<?> option) {
            this.option = option;
        }

        @Override
        void executeWithWorker(OperationContext context, ModelNode operation, XnioWorker worker) throws OperationFailedException {
            try {
                Object result = worker.getOption(this.option);
                if (result != null) {
                    context.getResult().set(new ModelNode(result.toString()));
                }
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    private static abstract class AbstractWorkerAttributeHandler
    implements OperationStepHandler {
        private AbstractWorkerAttributeHandler() {
        }

        public void execute(OperationContext outContext, ModelNode operation) throws OperationFailedException {
            outContext.addStep((context, op) -> {
                XnioWorker worker = WorkerResourceDefinition.getXnioWorker(context);
                if (worker == null || worker.getMXBean() == null) {
                    context.getResult().set(IOExtension.NO_METRICS);
                    return;
                }
                this.executeWithWorker(context, op, worker);
            }, OperationContext.Stage.RUNTIME);
        }

        abstract void executeWithWorker(OperationContext var1, ModelNode var2, XnioWorker var3) throws OperationFailedException;
    }
}

