/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments;

import java.util.List;
import java.util.jar.Manifest;
import org.jboss.as.logging.LoggingProfileContextSelector;
import org.jboss.as.logging.deployments.AbstractLoggingDeploymentProcessor;
import org.jboss.as.logging.deployments.LoggingConfigurationService;
import org.jboss.as.logging.deployments.LoggingDeploymentResourceProcessor;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logmanager.LogContext;
import org.jboss.modules.Module;

public class LoggingProfileDeploymentProcessor
extends AbstractLoggingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String LOGGING_PROFILE = "Logging-Profile";

    public LoggingProfileDeploymentProcessor(WildFlyLogContextSelector logContextSelector) {
        super(logContextSelector);
    }

    @Override
    protected void processDeployment(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, ResourceRoot root) throws DeploymentUnitProcessingException {
        LoggingConfigurationService loggingConfigurationService = null;
        List<DeploymentUnit> subDeployments = LoggingProfileDeploymentProcessor.getSubDeployments(deploymentUnit);
        String loggingProfile = this.findLoggingProfile(root);
        if (loggingProfile != null) {
            LoggingProfileContextSelector loggingProfileContext = LoggingProfileContextSelector.getInstance();
            if (loggingProfileContext.exists(loggingProfile)) {
                Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                LogContext logContext = loggingProfileContext.get(loggingProfile);
                LoggingLogger.ROOT_LOGGER.tracef("Registering log context '%s' on '%s' for profile '%s'", logContext, root, loggingProfile);
                this.registerLogContext(deploymentUnit, module, logContext);
                loggingConfigurationService = new LoggingConfigurationService(ConfigurationPersistence.getConfigurationPersistence(logContext), "profile-" + loggingProfile);
                for (DeploymentUnit subDeployment : subDeployments) {
                    if (!subDeployment.hasAttachment(Attachments.MODULE)) continue;
                    if (subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
                        this.processDeployment(phaseContext, subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
                    }
                    if (!LoggingProfileDeploymentProcessor.hasRegisteredLogContext(subDeployment)) {
                        Module subDeploymentModule = (Module)subDeployment.getAttachment(Attachments.MODULE);
                        LoggingLogger.ROOT_LOGGER.tracef("Registering log context '%s' on '%s' for profile '%s'", logContext, subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT), loggingProfile);
                        this.registerLogContext(subDeployment, subDeploymentModule, logContext);
                    }
                    if (subDeployment.hasAttachment(LoggingDeploymentResourceProcessor.LOGGING_CONFIGURATION_SERVICE_KEY)) continue;
                    subDeployment.putAttachment(LoggingDeploymentResourceProcessor.LOGGING_CONFIGURATION_SERVICE_KEY, (Object)loggingConfigurationService);
                }
            } else {
                LoggingLogger.ROOT_LOGGER.loggingProfileNotFound(loggingProfile, root);
            }
        } else {
            for (DeploymentUnit subDeployment : subDeployments) {
                if (!subDeployment.hasAttachment(Attachments.MODULE) || !subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) continue;
                this.processDeployment(phaseContext, subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
            }
        }
        if (loggingConfigurationService != null) {
            deploymentUnit.putAttachment(LoggingDeploymentResourceProcessor.LOGGING_CONFIGURATION_SERVICE_KEY, loggingConfigurationService);
        }
    }

    private String findLoggingProfile(ResourceRoot resourceRoot) {
        String loggingProfile;
        Manifest manifest = (Manifest)resourceRoot.getAttachment(Attachments.MANIFEST);
        if (manifest != null && (loggingProfile = manifest.getMainAttributes().getValue(LOGGING_PROFILE)) != null) {
            LoggingLogger.ROOT_LOGGER.debugf("Logging profile '%s' found in '%s'.", loggingProfile, resourceRoot);
            return loggingProfile;
        }
        return null;
    }
}

