/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerService;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceRegistry;

public final class LocalShowHistoryHandler
implements OperationStepHandler {
    public static final OperationStepHandler INSTANCE = new LocalShowHistoryHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(true);
        InstallationManager installationManager = (InstallationManager)registry.getRequiredService(InstallationManagerService.NAME).getValue();
        try {
            PatchableTarget.TargetInfo info = installationManager.getIdentity().loadTargetInfo();
            ModelNode result = PatchingHistory.Factory.getHistory(installationManager, info);
            context.getResult().set(result);
            context.stepCompleted();
        }
        catch (Throwable t) {
            PatchLogger.ROOT_LOGGER.debugf(t, "failed to get history", new Object[0]);
            throw PatchLogger.ROOT_LOGGER.failedToShowHistory(t);
        }
    }
}

