/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.jboss.as.process.logging.ProcessLogger;

final class Pipe {
    private final Object lock = new Object();
    private int tail;
    private int size;
    private final byte[] buffer;
    private boolean writeClosed;
    private boolean readClosed;
    private final InputStream in = new InputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object lock;
            Object object = lock = Pipe.this.lock;
            synchronized (object) {
                int n;
                if (Pipe.this.writeClosed && Pipe.this.size == 0) {
                    return -1;
                }
                while (Pipe.this.size == 0) {
                    try {
                        lock.wait();
                        if (!Pipe.this.writeClosed || Pipe.this.size != 0) continue;
                        return -1;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                lock.notifyAll();
                int tail = Pipe.this.tail;
                try {
                    n = Pipe.this.buffer[tail++] & 0xFF;
                }
                catch (Throwable throwable) {
                    Pipe.this.tail = tail == Pipe.this.buffer.length ? 0 : tail;
                    Pipe.this.size--;
                    throw throwable;
                }
                Pipe.this.tail = tail == Pipe.this.buffer.length ? 0 : tail;
                Pipe.this.size--;
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object lock;
            Object object = lock = Pipe.this.lock;
            synchronized (object) {
                int cnt;
                int size;
                if (Pipe.this.writeClosed && Pipe.this.size == 0) {
                    return -1;
                }
                if (len == 0) {
                    return 0;
                }
                while ((size = Pipe.this.size) == 0) {
                    try {
                        lock.wait();
                        if (!Pipe.this.writeClosed || (size = Pipe.this.size) != 0) continue;
                        return -1;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                byte[] buffer = Pipe.this.buffer;
                int bufLen = buffer.length;
                int tail = Pipe.this.tail;
                if (size + tail > bufLen) {
                    int lastLen = bufLen - tail;
                    if (lastLen < len) {
                        int firstLen = tail + size - bufLen;
                        System.arraycopy(buffer, tail, b, off, lastLen);
                        int rem = Math.min(len - lastLen, firstLen);
                        System.arraycopy(buffer, 0, b, off + lastLen, rem);
                        cnt = rem + lastLen;
                    } else {
                        System.arraycopy(buffer, tail, b, off, len);
                        cnt = len;
                    }
                } else {
                    cnt = Math.min(len, size);
                    System.arraycopy(buffer, tail, b, off, cnt);
                }
                Pipe.this.tail = (tail += cnt) >= bufLen ? tail - bufLen : tail;
                Pipe.this.size = (size -= cnt);
                lock.notifyAll();
                return cnt;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object lock;
            Object object = lock = Pipe.this.lock;
            synchronized (object) {
                Pipe.this.writeClosed = true;
                Pipe.this.readClosed = true;
                Pipe.this.size = 0;
                lock.notifyAll();
                return;
            }
        }
    };
    private final OutputStream out = new OutputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object lock;
            Object object = lock = Pipe.this.lock;
            synchronized (object) {
                if (Pipe.this.writeClosed) {
                    throw ProcessLogger.ROOT_LOGGER.streamClosed();
                }
                byte[] buffer = Pipe.this.buffer;
                int bufLen = buffer.length;
                while (Pipe.this.size == bufLen) {
                    try {
                        lock.wait();
                        if (!Pipe.this.writeClosed) continue;
                        throw ProcessLogger.ROOT_LOGGER.streamClosed();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                int tail = Pipe.this.tail;
                buffer[tail] = (byte)b;
                Pipe.this.size++;
                lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Object lock;
            int remaining = len;
            Object object = lock = Pipe.this.lock;
            synchronized (object) {
                if (Pipe.this.writeClosed) {
                    throw ProcessLogger.ROOT_LOGGER.streamClosed();
                }
                byte[] buffer = Pipe.this.buffer;
                int bufLen = buffer.length;
                while (remaining > 0) {
                    int cnt;
                    int size;
                    while ((size = Pipe.this.size) == bufLen) {
                        try {
                            lock.wait();
                            if (!Pipe.this.writeClosed) continue;
                            throw ProcessLogger.ROOT_LOGGER.streamClosed();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            InterruptedIOException iioe = new InterruptedIOException();
                            iioe.bytesTransferred = len - remaining;
                            throw iioe;
                        }
                    }
                    int tail = Pipe.this.tail;
                    int startPos = tail + size;
                    if (startPos >= bufLen) {
                        cnt = Math.min(remaining, bufLen - size);
                        System.arraycopy(b, off, buffer, startPos -= bufLen, cnt);
                        remaining -= cnt;
                        off += cnt;
                    } else {
                        int firstPart = Math.min(remaining, bufLen - (tail + size));
                        System.arraycopy(b, off, buffer, startPos, firstPart);
                        off += firstPart;
                        if ((remaining -= firstPart) > 0) {
                            int latter = Math.min(remaining, tail);
                            System.arraycopy(b, off, buffer, 0, latter);
                            cnt = firstPart + latter;
                            off += latter;
                            remaining -= latter;
                        } else {
                            cnt = firstPart;
                        }
                    }
                    Pipe pipe = Pipe.this;
                    pipe.size = pipe.size + cnt;
                    lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object lock;
            Object object = lock = Pipe.this.lock;
            synchronized (object) {
                Pipe.this.writeClosed = true;
                lock.notifyAll();
                return;
            }
        }
    };

    Pipe(int bufferSize) {
        this.buffer = new byte[bufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() {
        boolean intr = false;
        try {
            Object object = this.lock;
            synchronized (object) {
                while (!this.readClosed) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public InputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }
}

