/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import org.jboss.as.process.ManagedProcess;
import org.jboss.as.process.ProcessController;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.process.logging.ProcessLogger;
import org.jboss.as.process.protocol.Connection;
import org.jboss.as.process.protocol.ConnectionHandler;
import org.jboss.as.process.protocol.MessageHandler;
import org.jboss.as.process.protocol.StreamUtils;

public final class ProcessControllerServerHandler
implements ConnectionHandler {
    private final ProcessController processController;

    public ProcessControllerServerHandler(ProcessController controller) {
        this.processController = controller;
    }

    @Override
    public MessageHandler handleConnected(Connection connection) throws IOException {
        ProcessLogger.SERVER_LOGGER.tracef("Received connection from %s", connection.getPeerAddress());
        return new InitMessageHandler(this.processController);
    }

    private static class InitMessageHandler
    implements MessageHandler {
        private final ProcessController processController;

        public InitMessageHandler(ProcessController processController) {
            this.processController = processController;
        }

        @Override
        public void handleMessage(Connection connection, InputStream dataStream) throws IOException {
            int cmd = StreamUtils.readUnsignedByte(dataStream);
            if (cmd != 238) {
                ProcessLogger.SERVER_LOGGER.receivedUnknownGreetingCode(cmd, connection.getPeerAddress());
                connection.close();
                return;
            }
            int version = StreamUtils.readUnsignedByte(dataStream);
            if (version < 1) {
                ProcessLogger.SERVER_LOGGER.receivedInvalidVersion(connection.getPeerAddress());
                connection.close();
                return;
            }
            byte[] authCode = new byte[24];
            StreamUtils.readFully(dataStream, authCode);
            ManagedProcess process = this.processController.getServerByAuthCode(authCode);
            if (process == null) {
                ProcessLogger.SERVER_LOGGER.receivedUnknownCredentials(connection.getPeerAddress());
                StreamUtils.safeClose(connection);
                return;
            }
            ProcessLogger.SERVER_LOGGER.tracef("Received authentic connection from %s", connection.getPeerAddress());
            connection.setMessageHandler(new ConnectedMessageHandler(this.processController, process.isPrivileged()));
            this.processController.addManagedConnection(connection);
            dataStream.close();
            process.resetRespawnCount();
        }

        @Override
        public void handleShutdown(Connection connection) throws IOException {
            ProcessLogger.SERVER_LOGGER.tracef("Received end-of-stream for connection", new Object[0]);
            this.processController.removeManagedConnection(connection);
            connection.shutdownWrites();
        }

        @Override
        public void handleFailure(Connection connection, IOException e) throws IOException {
            ProcessLogger.SERVER_LOGGER.tracef(e, "Received failure of connection", new Object[0]);
            this.processController.removeManagedConnection(connection);
            connection.close();
        }

        @Override
        public void handleFinished(Connection connection) throws IOException {
            ProcessLogger.SERVER_LOGGER.tracef("Connection finished", new Object[0]);
            this.processController.removeManagedConnection(connection);
        }

        private static class ConnectedMessageHandler
        implements MessageHandler {
            private final boolean isPrivileged;
            private final ProcessController processController;

            public ConnectedMessageHandler(ProcessController processController, boolean isHostController) {
                this.processController = processController;
                this.isPrivileged = isHostController;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void handleMessage(Connection connection, InputStream dataStream) throws IOException {
                ProcessMessageHandler.OperationType operationType = null;
                String processName = null;
                try {
                    int cmd = StreamUtils.readUnsignedByte(dataStream);
                    switch (cmd) {
                        case 20: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.SEND_STDIN;
                                processName = StreamUtils.readUTFZBytes(dataStream);
                                ProcessLogger.SERVER_LOGGER.tracef("Received send_stdin for process %s", processName);
                                this.processController.sendStdin(processName, dataStream);
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring send_stdin message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 16: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.ADD;
                                processName = StreamUtils.readUTFZBytes(dataStream);
                                byte[] authBytes = new byte[24];
                                StreamUtils.readFully(dataStream, authBytes);
                                int commandCount = StreamUtils.readInt(dataStream);
                                String[] command = new String[commandCount];
                                for (int i = 0; i < commandCount; ++i) {
                                    command[i] = StreamUtils.readUTFZBytes(dataStream);
                                }
                                int envCount = StreamUtils.readInt(dataStream);
                                HashMap<String, String> env = new HashMap<String, String>();
                                for (int i = 0; i < envCount; ++i) {
                                    env.put(StreamUtils.readUTFZBytes(dataStream), StreamUtils.readUTFZBytes(dataStream));
                                }
                                String workingDirectory = StreamUtils.readUTFZBytes(dataStream);
                                ProcessLogger.SERVER_LOGGER.tracef("Received add_process for process %s", processName);
                                String authKey = new String(authBytes, Charset.forName("US-ASCII"));
                                this.processController.addProcess(processName, authKey, Arrays.asList(command), env, workingDirectory, false, false);
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring add_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 17: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.START;
                                processName = StreamUtils.readUTFZBytes(dataStream);
                                this.processController.startProcess(processName);
                                ProcessLogger.SERVER_LOGGER.tracef("Received start_process for process %s", processName);
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring start_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 18: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.STOP;
                                processName = StreamUtils.readUTFZBytes(dataStream);
                                this.processController.stopProcess(processName);
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring stop_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 19: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.REMOVE;
                                processName = StreamUtils.readUTFZBytes(dataStream);
                                this.processController.removeProcess(processName);
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring remove_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 21: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.INVENTORY;
                                this.processController.sendInventory();
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring request_process_inventory message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 22: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.REMOVE;
                                processName = StreamUtils.readUTFZBytes(dataStream);
                                String scheme = StreamUtils.readUTFZBytes(dataStream);
                                String hostName = StreamUtils.readUTFZBytes(dataStream);
                                int port = StreamUtils.readInt(dataStream);
                                boolean managementSubsystemEndpoint = StreamUtils.readBoolean(dataStream);
                                byte[] authBytes = new byte[24];
                                StreamUtils.readFully(dataStream, authBytes);
                                String authKey = new String(authBytes, Charset.forName("US-ASCII"));
                                this.processController.sendReconnectProcess(processName, scheme, hostName, port, managementSubsystemEndpoint, authKey);
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring reconnect_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 23: {
                            if (this.isPrivileged) {
                                final int exitCode = StreamUtils.readInt(dataStream);
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        processController.shutdown();
                                        System.exit(exitCode);
                                    }
                                }).start();
                                return;
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring shutdown message from untrusted source", new Object[0]);
                                return;
                            }
                        }
                        case 24: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.STOP;
                                processName = StreamUtils.readUTFZBytes(dataStream);
                                this.processController.destroyProcess(processName);
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring destroy_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        case 25: {
                            if (this.isPrivileged) {
                                operationType = ProcessMessageHandler.OperationType.STOP;
                                processName = StreamUtils.readUTFZBytes(dataStream);
                                this.processController.killProcess(processName);
                            } else {
                                ProcessLogger.SERVER_LOGGER.tracef("Ignoring kill_process message from untrusted source", new Object[0]);
                            }
                            dataStream.close();
                            return;
                        }
                        default: {
                            ProcessLogger.SERVER_LOGGER.receivedUnknownMessageCode(cmd);
                            dataStream.close();
                            return;
                        }
                    }
                }
                catch (IOException e) {
                    if (operationType == null || processName == null) throw e;
                    StreamUtils.safeClose(dataStream);
                    try {
                        OutputStream os = connection.writeMessage();
                        try {
                            os.write(22);
                            os.write(operationType.getCode());
                            StreamUtils.writeUTFZBytes(os, processName);
                            os.close();
                            throw e;
                        }
                        finally {
                            StreamUtils.safeClose(os);
                        }
                    }
                    catch (IOException ignore) {
                        ProcessLogger.ROOT_LOGGER.debugf(ignore, "failed to write operation failed message", new Object[0]);
                    }
                    throw e;
                }
                finally {
                    StreamUtils.safeClose(dataStream);
                }
            }

            @Override
            public void handleShutdown(Connection connection) throws IOException {
                ProcessLogger.SERVER_LOGGER.tracef("Received end-of-stream for connection", new Object[0]);
                this.processController.removeManagedConnection(connection);
                connection.shutdownWrites();
            }

            @Override
            public void handleFailure(Connection connection, IOException e) throws IOException {
                ProcessLogger.SERVER_LOGGER.tracef(e, "Received failure of connection", new Object[0]);
                this.processController.removeManagedConnection(connection);
                connection.close();
            }

            @Override
            public void handleFinished(Connection connection) throws IOException {
                ProcessLogger.SERVER_LOGGER.tracef("Connection finished", new Object[0]);
                this.processController.removeManagedConnection(connection);
                connection.close();
            }
        }
    }
}

