/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.security.InetAddressPrincipal;
import org.jboss.threads.AsyncFuture;

public final class ManagementChannelHandler
extends AbstractMessageHandler
implements ManagementChannelAssociation {
    public static final Attachments.Key<File> TEMP_DIR = new Attachments.Key(File.class);
    private static final AtomicReferenceFieldUpdater<ManagementChannelHandler, ManagementRequestHandlerFactory[]> updater = AtomicReferenceFieldUpdater.newUpdater(ManagementChannelHandler.class, ManagementRequestHandlerFactory[].class, "handlers");
    private static final ManagementRequestHandlerFactory[] NO_HANDLERS = new ManagementRequestHandlerFactory[0];
    private volatile ManagementRequestHandlerFactory[] handlers;
    private final ManagementChannelReceiver receiver;
    private final ManagementClientChannelStrategy strategy;
    private final Attachments attachments = new Attachments();

    public ManagementChannelHandler(Channel channel, ExecutorService executorService) {
        this(ManagementClientChannelStrategy.create(channel), executorService);
    }

    public ManagementChannelHandler(Channel channel, ExecutorService executorService, ManagementRequestHandlerFactory ... initial) {
        this(ManagementClientChannelStrategy.create(channel), executorService, initial);
    }

    public ManagementChannelHandler(ManagementClientChannelStrategy strategy, ExecutorService executorService) {
        this(strategy, executorService, NO_HANDLERS);
    }

    public ManagementChannelHandler(ManagementClientChannelStrategy strategy, ExecutorService executorService, ManagementRequestHandlerFactory ... initial) {
        super(executorService);
        this.strategy = strategy;
        this.handlers = initial;
        this.receiver = ManagementChannelReceiver.createDelegating(this);
    }

    public long getLastMessageReceivedTime() {
        return this.receiver.getLastMessageTime();
    }

    @Override
    public Channel getChannel() throws IOException {
        return this.strategy.getChannel();
    }

    public InetAddress getRemoteAddress() {
        try {
            Channel channel = this.strategy.getChannel();
            Connection connection = channel.getConnection();
            for (Principal principal : connection.getPrincipals()) {
                if (!(principal instanceof InetAddressPrincipal)) continue;
                return ((InetAddressPrincipal)principal).getInetAddress();
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    @Override
    public <T, A> ActiveOperation<T, A> initializeOperation(A attachment, ActiveOperation.CompletedCallback<T> callback) throws IOException {
        return super.registerActiveOperation(attachment, callback);
    }

    @Override
    public <T, A> ActiveOperation<T, A> executeRequest(ManagementRequest<T, A> request, A attachment, ActiveOperation.CompletedCallback<T> callback) throws IOException {
        ActiveOperation<T, A> operation = super.registerActiveOperation(attachment, callback);
        this.executeRequest(operation, request);
        return operation;
    }

    @Override
    public <T, A> ActiveOperation<T, A> executeRequest(ManagementRequest<T, A> request, A attachment) throws IOException {
        ActiveOperation operation = super.registerActiveOperation(attachment);
        this.executeRequest(operation, request);
        return operation;
    }

    @Override
    public <T, A> AsyncFuture<T> executeRequest(Integer operationId, ManagementRequest<T, A> request) throws IOException {
        ActiveOperation operation = super.getActiveOperation(operationId);
        if (operation == null) {
            throw ProtocolLogger.ROOT_LOGGER.responseHandlerNotFound(operationId);
        }
        return this.executeRequest(operation, request);
    }

    @Override
    public <T, A> AsyncFuture<T> executeRequest(ActiveOperation<T, A> support, ManagementRequest<T, A> request) throws IOException {
        return super.executeRequest(request, this.strategy.getChannel(), support);
    }

    @Override
    protected ManagementRequestHandler<?, ?> getRequestHandler(final ManagementRequestHeader header) {
        final ManagementRequestHandlerFactory[] snapshot = updater.get(this);
        return new ManagementRequestHandlerFactory.RequestHandlerChain(){
            final int length;
            private int index;
            {
                this.length = snapshot.length;
                this.index = -1;
            }

            @Override
            public ManagementRequestHandler<?, ?> resolveNext() {
                if (this.index++ == this.length) {
                    return ManagementChannelHandler.this.getFallbackHandler(header);
                }
                ManagementRequestHandlerFactory factory = snapshot[this.index];
                if (factory == null) {
                    return this.resolveNext();
                }
                return factory.resolveHandler(this, header);
            }

            @Override
            public <T, A> ActiveOperation<T, A> createActiveOperation(A attachment) {
                return ManagementChannelHandler.this.registerActiveOperation(attachment);
            }

            @Override
            public <T, A> ActiveOperation<T, A> createActiveOperation(A attachment, ActiveOperation.CompletedCallback<T> completedCallback) {
                return ManagementChannelHandler.this.registerActiveOperation(attachment, completedCallback);
            }

            @Override
            public <T, A> ActiveOperation<T, A> registerActiveOperation(Integer id, A attachment) {
                return ManagementChannelHandler.this.registerActiveOperation(id, attachment);
            }

            @Override
            public <T, A> ActiveOperation<T, A> registerActiveOperation(Integer id, A attachment, ActiveOperation.CompletedCallback<T> completedCallback) {
                return ManagementChannelHandler.this.registerActiveOperation(id, attachment, completedCallback);
            }
        }.resolveNext();
    }

    public Channel.Receiver getReceiver() {
        return this.receiver;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    public void addHandlerFactory(ManagementRequestHandlerFactory factory) {
        ManagementRequestHandlerFactory[] newVal;
        ManagementRequestHandlerFactory[] snapshot;
        do {
            snapshot = updater.get(this);
            int length = snapshot.length;
            newVal = new ManagementRequestHandlerFactory[length + 1];
            System.arraycopy(snapshot, 0, newVal, 0, length);
            newVal[length] = factory;
        } while (!updater.compareAndSet(this, snapshot, newVal));
    }

    public boolean removeHandlerFactory(ManagementRequestHandlerFactory instance) {
        ManagementRequestHandlerFactory[] newVal;
        ManagementRequestHandlerFactory[] snapshot;
        do {
            snapshot = updater.get(this);
            int length = snapshot.length;
            int index = -1;
            for (int i = 0; i < length; ++i) {
                if (snapshot[i] != instance) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return false;
            }
            newVal = new ManagementRequestHandlerFactory[length - 1];
            System.arraycopy(snapshot, 0, newVal, 0, index);
            System.arraycopy(snapshot, index + 1, newVal, index, length - index - 1);
        } while (!updater.compareAndSet(this, snapshot, newVal));
        return true;
    }
}

