/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.HashSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class WorkerThreadPoolVsEndpointHandler
implements OperationStepHandler {
    static final OperationStepHandler INSTANCE = new WorkerThreadPoolVsEndpointHandler();

    WorkerThreadPoolVsEndpointHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        HashSet<String> configuredAttributes = new HashSet<String>();
        for (AttributeDefinition attribute : RemotingSubsystemRootResource.ATTRIBUTES) {
            String attrName = attribute.getName();
            if (!model.hasDefined(attrName)) continue;
            configuredAttributes.add(attrName);
        }
        Resource endpointConfig = resource.getChild(RemotingEndpointResource.ENDPOINT_PATH);
        if (configuredAttributes.size() > 0) {
            ModelNode endpointModel;
            if (context.getProcessType().isServer()) {
                throw RemotingLogger.ROOT_LOGGER.workerConfigurationIgnored();
            }
            if (endpointConfig != null && (endpointModel = endpointConfig.getModel()).isDefined()) {
                for (Property prop : endpointModel.asPropertyList()) {
                    if (!prop.getValue().isDefined()) continue;
                    throw new OperationFailedException(RemotingLogger.ROOT_LOGGER.workerThreadsEndpointConfigurationChoiceRequired(Element.WORKER_THREAD_POOL.getLocalName(), Element.ENDPOINT.getLocalName()));
                }
            }
        } else if (endpointConfig == null) {
            context.addResource(PathAddress.pathAddress((PathElement[])new PathElement[]{RemotingEndpointResource.ENDPOINT_PATH}), Resource.Factory.create());
        }
    }
}

