/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.InetSocketAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.AbstractStreamServerService;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.remoting3.Endpoint;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.AcceptingChannel;

final class InjectedSocketBindingStreamServerService
extends AbstractStreamServerService {
    private final Supplier<SocketBinding> socketBindingSupplier;

    InjectedSocketBindingStreamServerService(Consumer<AcceptingChannel<StreamConnection>> streamServerConsumer, Supplier<Endpoint> endpointSupplier, Supplier<SecurityRealm> securityRealmSupplier, Supplier<SaslAuthenticationFactory> saslAuthenticationFactorySupplier, Supplier<SSLContext> sslContextSupplier, Supplier<SocketBindingManager> socketBindingManagerSupplier, Supplier<SocketBinding> socketBindingSupplier, OptionMap connectorPropertiesOptionMap) {
        super(streamServerConsumer, endpointSupplier, securityRealmSupplier, saslAuthenticationFactorySupplier, sslContextSupplier, socketBindingManagerSupplier, connectorPropertiesOptionMap);
        this.socketBindingSupplier = socketBindingSupplier;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        RemotingConnectorBindingInfoService.install(context.getChildTarget(), context.getController().getName().getSimpleName(), this.getSocketBinding(), Protocol.REMOTE);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
    }

    @Override
    InetSocketAddress getSocketAddress() {
        return this.socketBindingSupplier.get().getSocketAddress();
    }

    @Override
    ManagedBinding registerSocketBinding(SocketBindingManager socketBindingManager) {
        ManagedBinding binding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)this.socketBindingSupplier.get());
        socketBindingManager.getNamedRegistry().registerBinding(binding);
        return binding;
    }

    @Override
    void unregisterSocketBinding(ManagedBinding managedBinding, SocketBindingManager socketBindingManager) {
        socketBindingManager.getNamedRegistry().unregisterBinding(managedBinding);
    }

    public SocketBinding getSocketBinding() {
        return this.socketBindingSupplier.get();
    }
}

