/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.modules.Module;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DeploymentClassIndex {
    private final Map<String, ClassIndex> index = new HashMap<String, ClassIndex>();
    private final DeploymentReflectionIndex deploymentReflectionIndex;
    private final Module module;

    public DeploymentClassIndex(DeploymentReflectionIndex deploymentReflectionIndex, Module module) {
        this.deploymentReflectionIndex = deploymentReflectionIndex;
        this.module = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassIndex classIndex(String className) throws ClassNotFoundException {
        ClassIndex classIndex = this.index.get(className);
        if (classIndex == null) {
            ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.module.getClassLoader());
                Class<?> clazz = Class.forName(className, false, (ClassLoader)this.module.getClassLoader());
                classIndex = new ClassIndex(clazz, this.deploymentReflectionIndex);
                this.index.put(className, classIndex);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            }
        }
        return classIndex;
    }

    void cleanup() {
        this.index.clear();
    }
}

