/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.File;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ExternalModuleSpecService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ExternalModuleService
implements Service<ExternalModuleService> {
    public static final String EXTERNAL_MODULE_PREFIX = "deployment.external.";
    private boolean started;

    public boolean isValid(String externalModule) {
        File f = new File(externalModule);
        return f.exists() && !f.isDirectory();
    }

    public ModuleIdentifier addExternalModule(String moduleName, ServiceRegistry serviceRegistry, ServiceTarget serviceTarget) {
        return this.addExternalModule(moduleName, serviceRegistry, serviceTarget, moduleName);
    }

    public ModuleIdentifier addExternalModule(String moduleName, ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, String path) {
        ModuleIdentifier identifier = ModuleIdentifier.create((String)(EXTERNAL_MODULE_PREFIX + moduleName));
        ServiceName serviceName = ServiceModuleLoader.moduleSpecServiceName(identifier);
        ServiceController controller = serviceRegistry.getService(serviceName);
        if (controller == null) {
            ExternalModuleSpecService service = new ExternalModuleSpecService(identifier, new File(path));
            serviceTarget.addService(serviceName).setInstance((org.jboss.msc.Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        return identifier;
    }

    public synchronized void start(StartContext context) throws StartException {
        if (this.started) {
            throw ServerLogger.ROOT_LOGGER.externalModuleServiceAlreadyStarted();
        }
        this.started = true;
    }

    public void stop(StopContext context) {
    }

    public ExternalModuleService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public static void addService(ServiceTarget serviceTarget) {
        serviceTarget.addService(Services.JBOSS_EXTERNAL_MODULE_SERVICE).setInstance((org.jboss.msc.Service)new ExternalModuleService()).install();
    }
}

