/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.server.jmx.RunningStateJmxMBean;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.SuspendController;
import org.wildfly.extension.core.management.client.Process;

public class RunningStateJmx
extends NotificationBroadcasterSupport
implements RunningStateJmxMBean {
    private final ObjectName objectName;
    private final AtomicLong sequence = new AtomicLong(0L);
    private volatile Process.RuntimeConfigurationState state = Process.RuntimeConfigurationState.STOPPED;
    private volatile Process.RunningState runningState = Process.RunningState.STOPPED;
    private volatile RunningModeControl runningModeControl = null;
    private final boolean isServer;
    public static final String RUNTIME_CONFIGURATION_STATE = "RuntimeConfigurationState";
    public static final String RUNNING_STATE = "RunningState";

    private RunningStateJmx(ObjectName objectName, RunningModeControl runningModeControl, Process.Type type) {
        this.objectName = objectName;
        this.runningModeControl = runningModeControl;
        this.isServer = type == Process.Type.DOMAIN_SERVER || type == Process.Type.EMBEDDED_SERVER || type == Process.Type.STANDALONE_SERVER;
    }

    @Override
    public String getProcessState() {
        return this.state.toString();
    }

    @Override
    public Process.RunningState getRunningState() {
        return this.runningState;
    }

    @Override
    public Process.RunningMode getRunningMode() {
        return Process.RunningMode.from((String)this.runningModeControl.getRunningMode().name());
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), ServerLogger.ROOT_LOGGER.processStateChangeNotificationDescription())};
    }

    @Override
    public synchronized void setProcessState(ControlledProcessState.State oldState, ControlledProcessState.State newState) {
        String stateString = newState == ControlledProcessState.State.RUNNING ? "ok" : newState.toString();
        String oldStateString = oldState == ControlledProcessState.State.RUNNING ? "ok" : oldState.toString();
        this.state = Process.RuntimeConfigurationState.valueOf((String)newState.name());
        AttributeChangeNotification notification = new AttributeChangeNotification(this.objectName, this.sequence.getAndIncrement(), System.currentTimeMillis(), ServerLogger.ROOT_LOGGER.jmxAttributeChange(RUNTIME_CONFIGURATION_STATE, oldStateString, stateString), RUNTIME_CONFIGURATION_STATE, String.class.getName(), oldStateString, stateString);
        this.sendNotification(notification);
        switch (newState) {
            case RUNNING: {
                if (Process.RunningState.NORMAL == this.runningState || Process.RunningState.ADMIN_ONLY == this.runningState || this.isServer) break;
                if (this.getRunningMode() == Process.RunningMode.NORMAL) {
                    this.setRunningState(this.runningState, Process.RunningState.NORMAL);
                    break;
                }
                this.setRunningState(this.runningState, Process.RunningState.ADMIN_ONLY);
                break;
            }
            case STARTING: {
                if (Process.RunningState.STARTING == this.runningState) break;
                this.setRunningState(this.runningState, Process.RunningState.STARTING);
                break;
            }
            case STOPPING: {
                if (Process.RunningState.STOPPING == this.runningState) break;
                this.setRunningState(this.runningState, Process.RunningState.STOPPING);
                break;
            }
            case STOPPED: {
                if (Process.RunningState.STOPPED == this.runningState) break;
                this.setRunningState(this.runningState, Process.RunningState.STOPPED);
                break;
            }
        }
    }

    @Override
    public synchronized void setRunningState(Process.RunningState oldState, Process.RunningState newState) {
        if (oldState == null || oldState == newState || this.runningState == newState) {
            return;
        }
        this.runningState = newState;
        AttributeChangeNotification notification = new AttributeChangeNotification(this.objectName, this.sequence.getAndIncrement(), System.currentTimeMillis(), ServerLogger.ROOT_LOGGER.jmxAttributeChange(RUNNING_STATE, oldState.toString(), newState.toString()), RUNNING_STATE, String.class.getName(), oldState.toString(), newState.toString());
        this.sendNotification(notification);
    }

    public static void registerMBean(ControlledProcessStateService processStateService, SuspendController suspendController, RunningModeControl runningModeControl, Process.Type type) {
        try {
            ObjectName name = new ObjectName("jboss.root:type=state");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            final RunningStateJmx mbean = new RunningStateJmx(name, runningModeControl, type);
            if (server.isRegistered(name)) {
                server.unregisterMBean(name);
            }
            server.registerMBean(mbean, name);
            RunningStateJmx.registerStateListener(mbean, processStateService);
            if (suspendController != null) {
                suspendController.addListener(new OperationListener(){

                    @Override
                    public void suspendStarted() {
                        mbean.setRunningState(mbean.getRunningState(), Process.RunningState.SUSPENDING);
                    }

                    @Override
                    public void complete() {
                        mbean.setRunningState(mbean.getRunningState(), Process.RunningState.SUSPENDED);
                    }

                    @Override
                    public void cancelled() {
                        if (mbean.getRunningState() == null || mbean.getRunningState() == Process.RunningState.STARTING) {
                            mbean.setRunningState(Process.RunningState.STARTING, Process.RunningState.SUSPENDED);
                        }
                        if (mbean.getRunningMode() == Process.RunningMode.NORMAL) {
                            mbean.setRunningState(mbean.getRunningState(), Process.RunningState.NORMAL);
                        } else {
                            mbean.setRunningState(mbean.getRunningState(), Process.RunningState.ADMIN_ONLY);
                        }
                    }

                    @Override
                    public void timeout() {
                    }
                });
            } else {
                mbean.setRunningState(null, Process.RunningState.STARTING);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void registerStateListener(final RunningStateJmxMBean mbean, ControlledProcessStateService processStateService) {
        processStateService.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("currentState".equals(evt.getPropertyName())) {
                    ControlledProcessState.State oldState = (ControlledProcessState.State)evt.getOldValue();
                    ControlledProcessState.State newState = (ControlledProcessState.State)evt.getNewValue();
                    mbean.setProcessState(oldState, newState);
                }
            }
        });
    }
}

