/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentAttributes {
    public static final ResourceDescriptionResolver DEPLOYMENT_RESOLVER = ServerDescriptions.getResourceDescriptionResolver("deployment", false);
    public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new StringLengthValidator(1, false))).build();
    public static final AttributeDefinition TO_REPLACE = SimpleAttributeDefinitionBuilder.create((String)"to-replace", (SimpleAttributeDefinition)NAME).build();
    public static final SimpleAttributeDefinition RUNTIME_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"runtime-name", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    public static final SimpleAttributeDefinition RUNTIME_NAME_NILLABLE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"runtime-name", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).build();
    public static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"enabled", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false))).setAllowExpression(false)).setAttributeMarshaller(new AttributeMarshaller(){

        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel) {
            return !resourceModel.has(attribute.getName()) || resourceModel.get(attribute.getName()).getType() != ModelType.BOOLEAN || !resourceModel.get(attribute.getName()).asBoolean();
        }

        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            ModelNode value;
            ModelNode modelNode = value = resourceModel.hasDefined(attribute.getName()) ? resourceModel.get(attribute.getName()) : new ModelNode(false);
            if (value.getType() != ModelType.BOOLEAN || !value.asBoolean()) {
                writer.writeAttribute(attribute.getXmlName(), value.asString());
            }
        }
    })).build();
    public static final AttributeDefinition PERSISTENT = SimpleAttributeDefinitionBuilder.create((String)"persistent", (ModelType)ModelType.BOOLEAN, (boolean)false).build();
    public static final AttributeDefinition OWNER = ((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"owner", (ModelType)ModelType.PROPERTY).setAllowNull(true)).build();
    public static final AttributeDefinition STATUS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"status", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new EnumValidator(AbstractDeploymentUnitService.DeploymentStatus.class, true, (Enum[])new AbstractDeploymentUnitService.DeploymentStatus[0]))).build();
    public static final SimpleAttributeDefinition ENABLED_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"enabled-time", (ModelType)ModelType.LONG, (boolean)true).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
    public static final SimpleAttributeDefinition ENABLED_TIMESTAMP = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"enabled-timestamp", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition DISABLED_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"disabled-time", (ModelType)ModelType.LONG, (boolean)true).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
    public static final SimpleAttributeDefinition DISABLED_TIMESTAMP = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"disabled-timestamp", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition MANAGED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"managed", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).addFlag(AttributeAccess.Flag.RUNTIME_SERVICE_NOT_REQUIRED)).build();
    public static final AttributeDefinition EMPTY = ((SimpleAttributeDefinitionBuilder)DeploymentAttributes.createContentValueTypeAttribute("empty", ModelType.BOOLEAN, (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true), false, "hash", "input-stream-index", "bytes", "url", "path", "relative-to").setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition CONTENT_INPUT_STREAM_INDEX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)DeploymentAttributes.createContentValueTypeAttribute("input-stream-index", ModelType.INT, (ParameterValidator)new StringLengthValidator(1, true), false, "hash", "bytes", "url", "path", "relative-to", "empty").addArbitraryDescriptor("filesystem-path", new ModelNode(true))).addArbitraryDescriptor("attached-streams", new ModelNode(true))).build();
    public static final SimpleAttributeDefinition CONTENT_HASH = DeploymentAttributes.createContentValueTypeAttribute("hash", ModelType.BYTES, (ParameterValidator)new HashValidator(true), false, "input-stream-index", "bytes", "url", "path", "relative-to", "empty").build();
    public static final SimpleAttributeDefinition CONTENT_BYTES = DeploymentAttributes.createContentValueTypeAttribute("bytes", ModelType.BYTES, (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true), false, "input-stream-index", "hash", "url", "path", "relative-to", "empty").build();
    public static final SimpleAttributeDefinition CONTENT_URL = DeploymentAttributes.createContentValueTypeAttribute("url", ModelType.STRING, (ParameterValidator)new StringLengthValidator(1, true), false, "input-stream-index", "hash", "bytes", "path", "relative-to", "empty").build();
    public static final AttributeDefinition CONTENT_PATH = ((SimpleAttributeDefinitionBuilder)DeploymentAttributes.createContentValueTypeAttribute("path", ModelType.STRING, (ParameterValidator)new StringLengthValidator(1, true), false, "input-stream-index", "hash", "bytes", "url", "empty").setRequires(new String[]{"archive"})).build();
    public static final AttributeDefinition CONTENT_RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)DeploymentAttributes.createContentValueTypeAttribute("relative-to", ModelType.STRING, (ParameterValidator)new StringLengthValidator(1, true), false, "input-stream-index", "hash", "bytes", "url", "empty").setRequires(new String[]{"path"})).build();
    public static final AttributeDefinition CONTENT_ARCHIVE = ((SimpleAttributeDefinitionBuilder)DeploymentAttributes.createContentValueTypeAttribute("archive", ModelType.BOOLEAN, (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN), false, "input-stream-index", "bytes", "url").setRequires(new String[]{"path", "hash", "empty"})).build();
    public static final SimpleAttributeDefinition DEPLOYMENT_CONTENT_PATH = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"path", (ModelType)ModelType.STRING, (boolean)true).addArbitraryDescriptor("relative-to", new ModelNode(true))).build();
    public static final SimpleAttributeDefinition TARGET_PATH = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-path", (ModelType)ModelType.STRING, (boolean)false).addArbitraryDescriptor("relative-to", new ModelNode(true))).build();
    public static final StringListAttributeDefinition REMOVED_PATHS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("paths").addArbitraryDescriptor("relative-to", new ModelNode(true))).setAllowExpression(true)).setAllowNull(false)).build();
    public static final StringListAttributeDefinition UPDATED_PATHS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("path").addArbitraryDescriptor("relative-to", new ModelNode(true))).setAllowExpression(true)).setAllowNull(false)).build();
    public static final SimpleAttributeDefinition OVERWRITE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"overwrite", (ModelType)ModelType.BOOLEAN, (boolean)true).setNullSignificant(false)).setDefaultValue(new ModelNode(true))).build();
    public static final SimpleAttributeDefinition DEPTH = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"depth", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(-1))).build();
    public static final SimpleAttributeDefinition ARCHIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"archive", (ModelType)ModelType.BOOLEAN, (boolean)true).setNullSignificant(false)).setDefaultValue(new ModelNode(false))).build();
    public static final ObjectListAttributeDefinition CONTENT_ALL = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"content", (ObjectTypeAttributeDefinition)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"content", (AttributeDefinition[])new AttributeDefinition[]{CONTENT_INPUT_STREAM_INDEX, CONTENT_HASH, CONTENT_BYTES, CONTENT_URL, CONTENT_PATH, CONTENT_RELATIVE_TO, CONTENT_ARCHIVE, EMPTY}).setValidator((ParameterValidator)new ContentTypeValidator())).build()).setMinSize(1)).setMaxSize(1)).setCorrector((ParameterCorrector)ContentListCorrector.access$000())).build();
    public static final ObjectListAttributeDefinition CONTENT_ALL_NILLABLE = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"content", (ObjectTypeAttributeDefinition)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"content", (AttributeDefinition[])new AttributeDefinition[]{CONTENT_INPUT_STREAM_INDEX, CONTENT_HASH, CONTENT_BYTES, CONTENT_URL, CONTENT_PATH, CONTENT_RELATIVE_TO, CONTENT_ARCHIVE}).setValidator((ParameterValidator)new ContentTypeValidator())).build()).setMinSize(1)).setMaxSize(1)).setAllowNull(true).setCorrector((ParameterCorrector)ContentListCorrector.access$000())).build();
    public static final ObjectListAttributeDefinition CONTENT_RESOURCE = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"content", (ObjectTypeAttributeDefinition)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"content", (AttributeDefinition[])new AttributeDefinition[]{CONTENT_HASH, CONTENT_PATH, CONTENT_RELATIVE_TO, CONTENT_ARCHIVE}).setValidator((ParameterValidator)new ContentTypeValidator())).build()).setMinSize(1)).setMaxSize(1)).build();
    public static final ObjectListAttributeDefinition EXPLODED_CONTENT = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"content", (ObjectTypeAttributeDefinition)ObjectTypeAttributeDefinition.Builder.of((String)"content", (AttributeDefinition[])new AttributeDefinition[]{CONTENT_INPUT_STREAM_INDEX, CONTENT_HASH, CONTENT_BYTES, CONTENT_URL, TARGET_PATH}).build()).setMinSize(1)).setValidator((ParameterValidator)new ManagedContentTypeValidator("target-path", "overwrite"))).setCorrector((ParameterCorrector)ContentListCorrector.access$000())).build();
    public static final AttributeDefinition[] SERVER_RESOURCE_ATTRIBUTES = new AttributeDefinition[]{NAME, RUNTIME_NAME, CONTENT_RESOURCE, ENABLED, PERSISTENT, OWNER, STATUS, ENABLED_TIME, ENABLED_TIMESTAMP, DISABLED_TIME, DISABLED_TIMESTAMP, MANAGED};
    public static final AttributeDefinition[] SERVER_ADD_ATTRIBUTES = new AttributeDefinition[]{RUNTIME_NAME_NILLABLE, CONTENT_ALL, ENABLED};
    public static final AttributeDefinition[] SERVER_GROUP_RESOURCE_ATTRIBUTES = new AttributeDefinition[]{NAME, RUNTIME_NAME, ENABLED, MANAGED};
    public static final AttributeDefinition[] SERVER_GROUP_ADD_ATTRIBUTES = new AttributeDefinition[]{RUNTIME_NAME_NILLABLE, ENABLED};
    public static final AttributeDefinition[] DOMAIN_RESOURCE_ATTRIBUTES = new AttributeDefinition[]{NAME, RUNTIME_NAME, MANAGED, CONTENT_RESOURCE};
    public static final AttributeDefinition[] DOMAIN_ADD_ATTRIBUTES = new AttributeDefinition[]{RUNTIME_NAME_NILLABLE, CONTENT_ALL};
    public static final Map<String, AttributeDefinition> MANAGED_CONTENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(new AttributeDefinition[]{CONTENT_INPUT_STREAM_INDEX, CONTENT_HASH, CONTENT_BYTES, CONTENT_URL, EMPTY});
    public static final Map<String, AttributeDefinition> UNMANAGED_CONTENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(CONTENT_PATH, CONTENT_RELATIVE_TO, CONTENT_ARCHIVE);
    private static final ObjectTypeAttributeDefinition BROWSE_CONTENT_REPLY = ObjectTypeAttributeDefinition.Builder.of((String)"content", (AttributeDefinition[])new AttributeDefinition[]{SimpleAttributeDefinitionBuilder.create((String)"directory", (ModelType)ModelType.BOOLEAN, (boolean)false).build(), SimpleAttributeDefinitionBuilder.create((String)"path", (ModelType)ModelType.STRING, (boolean)false).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"file-size", (ModelType)ModelType.LONG, (boolean)true).setMeasurementUnit(MeasurementUnit.BYTES)).build()}).setAllowNull(false).build();
    public static final Map<String, AttributeDefinition> ALL_CONTENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(MANAGED_CONTENT_ATTRIBUTES, UNMANAGED_CONTENT_ATTRIBUTES);
    public static final OperationDefinition DEPLOY_DEFINITION = new SimpleOperationDefinition("deploy", DEPLOYMENT_RESOLVER);
    public static final OperationDefinition UNDEPLOY_DEFINITION = new SimpleOperationDefinition("undeploy", DEPLOYMENT_RESOLVER);
    public static final OperationDefinition REDEPLOY_DEFINITION = new SimpleOperationDefinition("redeploy", DEPLOYMENT_RESOLVER);
    public static final OperationDefinition EXPLODE_DEFINITION = new SimpleOperationDefinitionBuilder("explode", DEPLOYMENT_RESOLVER).addParameter((AttributeDefinition)DEPLOYMENT_CONTENT_PATH).withFlag(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS).build();
    public static final OperationDefinition SERVER_DEPLOYMENT_ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", DEPLOYMENT_RESOLVER).setParameters(SERVER_ADD_ATTRIBUTES).build();
    public static final OperationDefinition DEPLOYMENT_ADD_CONTENT_DEFINITION = new SimpleOperationDefinitionBuilder("add-content", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{EXPLODED_CONTENT, OVERWRITE}).withFlag(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS).build();
    public static final OperationDefinition DEPLOYMENT_REMOVE_CONTENT_DEFINITION = new SimpleOperationDefinitionBuilder("remove-content", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{REMOVED_PATHS}).withFlag(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS).build();
    public static final OperationDefinition DEPLOYMENT_READ_CONTENT_DEFINITION = new SimpleOperationDefinitionBuilder("read-content", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{DEPLOYMENT_CONTENT_PATH}).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("uuid", ModelType.STRING, false).build()}).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.READ_ONLY}).build();
    public static final OperationDefinition DEPLOYMENT_BROWSE_CONTENT_DEFINITION = new SimpleOperationDefinitionBuilder("browse-content", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{DEPLOYMENT_CONTENT_PATH, ARCHIVE, DEPTH}).setReplyParameters(new AttributeDefinition[]{BROWSE_CONTENT_REPLY}).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.READ_ONLY}).build();
    public static final OperationDefinition SERVER_GROUP_DEPLOYMENT_ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", DEPLOYMENT_RESOLVER).setParameters(SERVER_GROUP_ADD_ATTRIBUTES).build();
    public static final OperationDefinition DOMAIN_DEPLOYMENT_ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", DEPLOYMENT_RESOLVER).setParameters(DOMAIN_ADD_ATTRIBUTES).build();
    private static final SimpleAttributeDefinition UPLOAD_HASH_REPLY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CONTENT_HASH).setAllowNull(false)).build();
    public static final AttributeDefinition BYTES_NOT_NULL = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CONTENT_BYTES).setAllowNull(false)).build();
    public static final OperationDefinition UPLOAD_BYTES_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-bytes", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{BYTES_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ApplicationTypeAccessConstraintDefinition.DEPLOYMENT).build();
    public static final OperationDefinition DOMAIN_UPLOAD_BYTES_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-bytes", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{BYTES_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ApplicationTypeAccessConstraintDefinition.DEPLOYMENT).build();
    public static final AttributeDefinition URL_NOT_NULL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CONTENT_URL).setAllowNull(false)).addArbitraryDescriptor("web-url", new ModelNode(true))).build();
    public static final OperationDefinition UPLOAD_URL_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-url", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{URL_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ApplicationTypeAccessConstraintDefinition.DEPLOYMENT).build();
    public static final OperationDefinition DOMAIN_UPLOAD_URL_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-url", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{URL_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ApplicationTypeAccessConstraintDefinition.DEPLOYMENT).build();
    public static final AttributeDefinition INPUT_STREAM_INDEX_NOT_NULL = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CONTENT_INPUT_STREAM_INDEX).setAllowNull(false)).build();
    public static final OperationDefinition UPLOAD_STREAM_ATTACHMENT_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-stream", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{INPUT_STREAM_INDEX_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ApplicationTypeAccessConstraintDefinition.DEPLOYMENT).build();
    public static final OperationDefinition DOMAIN_UPLOAD_STREAM_ATTACHMENT_DEFINITION = new SimpleOperationDefinitionBuilder("upload-deployment-stream", DEPLOYMENT_RESOLVER).setParameters(new AttributeDefinition[]{INPUT_STREAM_INDEX_NOT_NULL}).setReplyParameters(new AttributeDefinition[]{UPLOAD_HASH_REPLY}).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ApplicationTypeAccessConstraintDefinition.DEPLOYMENT).build();
    public static final Map<String, AttributeDefinition> REPLACE_DEPLOYMENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(new AttributeDefinition[]{NAME, TO_REPLACE, CONTENT_ALL_NILLABLE, RUNTIME_NAME_NILLABLE});
    public static final OperationDefinition REPLACE_DEPLOYMENT_DEFINITION = new SimpleOperationDefinitionBuilder("replace-deployment", DEPLOYMENT_RESOLVER).setParameters(REPLACE_DEPLOYMENT_ATTRIBUTES.values().toArray(new AttributeDefinition[REPLACE_DEPLOYMENT_ATTRIBUTES.size()])).build();
    public static final Map<String, AttributeDefinition> SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(new AttributeDefinition[]{NAME, TO_REPLACE, RUNTIME_NAME_NILLABLE});
    public static final OperationDefinition SERVER_GROUP_REPLACE_DEPLOYMENT_DEFINITION = new SimpleOperationDefinitionBuilder("replace-deployment", DEPLOYMENT_RESOLVER).setParameters(SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.values().toArray(new AttributeDefinition[SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.size()])).build();
    public static final Map<String, AttributeDefinition> FULL_REPLACE_DEPLOYMENT_ATTRIBUTES = DeploymentAttributes.createAttributeMap(new AttributeDefinition[]{NAME, RUNTIME_NAME_NILLABLE, CONTENT_ALL, ENABLED});
    public static final OperationDefinition FULL_REPLACE_DEPLOYMENT_DEFINITION = new SimpleOperationDefinitionBuilder("full-replace-deployment", DEPLOYMENT_RESOLVER).setParameters(FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.values().toArray(new AttributeDefinition[FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.size()])).addAccessConstraint((AccessConstraintDefinition)ApplicationTypeAccessConstraintDefinition.DEPLOYMENT).build();
    public static final NotificationDefinition NOTIFICATION_DEPLOYMENT_DEPLOYED = NotificationDefinition.Builder.create((String)"deployment-deployed", (ResourceDescriptionResolver)DEPLOYMENT_RESOLVER).build();
    public static final NotificationDefinition NOTIFICATION_DEPLOYMENT_UNDEPLOYED = NotificationDefinition.Builder.create((String)"deployment-undeployed", (ResourceDescriptionResolver)DEPLOYMENT_RESOLVER).build();
    private static final List<String> UNMANAGED_CONTENT_ATTS = Arrays.asList(CONTENT_PATH.getName(), CONTENT_RELATIVE_TO.getName());

    public static boolean isUnmanagedContent(ModelNode content) {
        return UNMANAGED_CONTENT_ATTS.stream().anyMatch(s -> content.hasDefined(s));
    }

    private static SimpleAttributeDefinitionBuilder createContentValueTypeAttribute(String name, ModelType type, ParameterValidator validator, boolean allowExpression, String ... alternatives) {
        SimpleAttributeDefinitionBuilder builder = SimpleAttributeDefinitionBuilder.create((String)name, (ModelType)type, (boolean)true);
        if (validator != null) {
            builder.setValidator(validator);
        }
        builder.setAllowExpression(allowExpression);
        if (alternatives != null && alternatives.length > 0) {
            builder.setAlternatives(alternatives);
        }
        return builder;
    }

    private static Map<String, AttributeDefinition> createAttributeMap(AttributeDefinition ... defs) {
        HashMap<String, AttributeDefinition> map = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : defs) {
            map.put(def.getName(), def);
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, AttributeDefinition> createAttributeMap(Map<String, AttributeDefinition> ... maps) {
        HashMap<String, AttributeDefinition> map = new HashMap<String, AttributeDefinition>();
        for (Map<String, AttributeDefinition> other : maps) {
            map.putAll(other);
        }
        return Collections.unmodifiableMap(map);
    }

    private static class ContentListCorrector
    implements ParameterCorrector {
        private static final ContentListCorrector INSTANCE = new ContentListCorrector();

        private ContentListCorrector() {
        }

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            ModelNode result = newValue;
            if (newValue.getType() == ModelType.OBJECT) {
                result = new ModelNode();
                result.add(newValue);
            }
            return result;
        }

        static /* synthetic */ ContentListCorrector access$000() {
            return INSTANCE;
        }
    }

    private static class ManagedContentTypeValidator
    extends ParametersValidator {
        private final Set<String> ignoredParameters;

        public ManagedContentTypeValidator(String ... ignoredParameters) {
            this.ignoredParameters = new HashSet<String>(Arrays.asList(ignoredParameters));
        }

        public void validateParameter(String parameterName, ModelNode contentItemNode) throws OperationFailedException {
            for (String key : contentItemNode.keys()) {
                String[] reqs;
                if (this.ignoredParameters.contains(key)) continue;
                AttributeDefinition def = MANAGED_CONTENT_ATTRIBUTES.get(key);
                if (def == null) {
                    throw ServerLogger.ROOT_LOGGER.unknownContentItemKey(key);
                }
                def.validateOperation(contentItemNode);
                if (!contentItemNode.hasDefined(key)) continue;
                String[] alts = def.getAlternatives();
                if (alts != null && alts.length > 0) {
                    for (String alt : alts) {
                        if (!contentItemNode.hasDefined(alt)) continue;
                        throw ServerLogger.ROOT_LOGGER.cannotHaveMoreThanOneManagedContentItem(MANAGED_CONTENT_ATTRIBUTES.keySet());
                    }
                }
                if ((reqs = def.getRequires()) == null || reqs.length <= 0) continue;
                boolean hasReq = false;
                for (String req : reqs) {
                    if (!contentItemNode.hasDefined(req)) continue;
                    hasReq = true;
                    break;
                }
                if (hasReq) continue;
                throw ServerLogger.ROOT_LOGGER.nullParameter(reqs[0]);
            }
        }
    }

    private static class ContentTypeValidator
    extends ParametersValidator {
        private ContentTypeValidator() {
        }

        public void validateParameter(String parameterName, ModelNode contentItemNode) throws OperationFailedException {
            for (String key : contentItemNode.keys()) {
                boolean managedAttr = true;
                if (CONTENT_ARCHIVE.equals(key)) continue;
                AttributeDefinition def = MANAGED_CONTENT_ATTRIBUTES.get(key);
                if (def == null) {
                    def = UNMANAGED_CONTENT_ATTRIBUTES.get(key);
                    managedAttr = false;
                }
                if (def != null) {
                    String[] reqs;
                    def.validateOperation(contentItemNode);
                    if (!contentItemNode.hasDefined(key)) continue;
                    String[] alts = def.getAlternatives();
                    if (alts != null && alts.length > 0) {
                        for (String alt : alts) {
                            if (!contentItemNode.hasDefined(alt)) continue;
                            boolean altIsManaged = MANAGED_CONTENT_ATTRIBUTES.containsKey(alt);
                            if (managedAttr == altIsManaged) {
                                if (managedAttr) {
                                    throw ServerLogger.ROOT_LOGGER.cannotHaveMoreThanOneManagedContentItem(MANAGED_CONTENT_ATTRIBUTES.keySet());
                                }
                                throw new IllegalStateException();
                            }
                            throw ServerLogger.ROOT_LOGGER.cannotMixUnmanagedAndManagedContentItems(Collections.singleton(key), new HashSet<String>(Arrays.asList(def.getAlternatives())));
                        }
                    }
                    if ((reqs = def.getRequires()) == null || reqs.length <= 0) continue;
                    boolean hasReq = false;
                    for (String req : reqs) {
                        if (!contentItemNode.hasDefined(req)) continue;
                        hasReq = true;
                        break;
                    }
                    if (hasReq) continue;
                    throw ServerLogger.ROOT_LOGGER.nullParameter(reqs[0]);
                }
                throw ServerLogger.ROOT_LOGGER.unknownContentItemKey(key);
            }
        }
    }

    private static class HashValidator
    extends ModelTypeValidator
    implements MinMaxValidator {
        public HashValidator(boolean nillable) {
            super(ModelType.BYTES, nillable);
        }

        public Long getMin() {
            return 20L;
        }

        public Long getMax() {
            return 20L;
        }
    }
}

