/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.HashSet;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitPhaseService;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractDeploymentUnitService
implements Service<DeploymentUnit> {
    private static final String FIRST_PHASE_NAME = Phase.values()[0].name();
    final ImmutableManagementResourceRegistration registration;
    final ManagementResourceRegistration mutableRegistration;
    final Resource resource;
    final CapabilityServiceSupport capabilityServiceSupport;
    final AbstractVaultReader vaultReader;
    private final InjectedValue<DeployerChains> deployerChainsInjector = new InjectedValue();
    private DeploymentUnit deploymentUnit;
    private volatile StabilityMonitor monitor;

    AbstractDeploymentUnitService(ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, Resource resource, CapabilityServiceSupport capabilityServiceSupport, AbstractVaultReader vaultReader) {
        this.mutableRegistration = mutableRegistration;
        this.capabilityServiceSupport = capabilityServiceSupport;
        this.registration = registration;
        this.vaultReader = vaultReader;
        this.resource = resource;
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceTarget target = context.getChildTarget();
        String deploymentName = context.getController().getName().getSimpleName();
        this.monitor = new StabilityMonitor();
        this.monitor.addController(context.getController());
        this.deploymentUnit = this.createAndInitializeDeploymentUnit((ServiceRegistry)context.getController().getServiceContainer());
        String managementName = this.deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME);
        if (this.deploymentUnit.getParent() == null) {
            ServerLogger.DEPLOYMENT_LOGGER.startingDeployment(managementName, deploymentName);
        } else {
            ServerLogger.DEPLOYMENT_LOGGER.startingSubDeployment(deploymentName);
        }
        ServiceName serviceName = this.deploymentUnit.getServiceName().append(new String[]{FIRST_PHASE_NAME});
        Phase firstPhase = Phase.values()[0];
        DeploymentUnitPhaseService<?> phaseService = DeploymentUnitPhaseService.create(this.deploymentUnit, firstPhase);
        ServiceBuilder phaseServiceBuilder = target.addService(serviceName, phaseService);
        phaseServiceBuilder.addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector());
        phaseServiceBuilder.install();
    }

    protected abstract DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry var1);

    public synchronized void stop(StopContext context) {
        String deploymentName = context.getController().getName().getSimpleName();
        String managementName = this.deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME);
        if (this.deploymentUnit.getParent() == null) {
            ServerLogger.DEPLOYMENT_LOGGER.stoppedDeployment(managementName, deploymentName, (int)(context.getElapsedTime() / 1000000L));
        } else {
            ServerLogger.DEPLOYMENT_LOGGER.stoppedSubDeployment(deploymentName, (int)(context.getElapsedTime() / 1000000L));
        }
        this.deploymentUnit = null;
        this.monitor.removeController(context.getController());
        this.monitor = null;
        DeploymentResourceSupport.cleanup(this.resource);
    }

    public synchronized DeploymentUnit getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit;
    }

    public DeploymentStatus getStatus() {
        StabilityMonitor monitor = this.monitor;
        if (monitor == null) {
            return DeploymentStatus.STOPPED;
        }
        HashSet problems = new HashSet();
        try {
            monitor.awaitStability(problems, problems);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return problems.isEmpty() ? DeploymentStatus.OK : DeploymentStatus.FAILED;
    }

    Injector<DeployerChains> getDeployerChainsInjector() {
        return this.deployerChainsInjector;
    }

    public static enum DeploymentStatus {
        NEW,
        OK,
        FAILED,
        STOPPED;

    }
}

