/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentDeployHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "deploy";
    private final AbstractVaultReader vaultReader;

    public DeploymentDeployHandler(AbstractVaultReader vaultReader) {
        this.vaultReader = vaultReader;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        model.get(DeploymentAttributes.ENABLED.getName()).set(true);
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        String runtimeName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, model).asString();
        DeploymentHandlerUtil.ContentItem[] contents = DeploymentHandlerUtils.getContents(DeploymentAttributes.CONTENT_RESOURCE.resolveModelAttribute(context, model));
        DeploymentHandlerUtil.deploy(context, operation, runtimeName, name, this.vaultReader, contents);
        DeploymentUtils.enableAttribute(model);
    }
}

