/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.moduleservice.ModuleIndexBuilder;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ModuleIndexService
implements Service<ModuleIndexService> {
    private final Map<ModuleIdentifier, CompositeIndex> indexes = new HashMap<ModuleIdentifier, CompositeIndex>();

    public void start(StartContext context) throws StartException {
        context.getController().compareAndSetMode(ServiceController.Mode.ON_DEMAND, ServiceController.Mode.ACTIVE);
    }

    public void stop(StopContext context) {
        this.indexes.clear();
    }

    public ModuleIndexService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public synchronized CompositeIndex getIndex(Module module) {
        CompositeIndex index = this.indexes.get(module.getIdentifier());
        if (index == null) {
            index = ModuleIndexBuilder.buildCompositeIndex(module);
            this.indexes.put(module.getIdentifier(), index);
        }
        return index;
    }

    public static void addService(ServiceTarget serviceTarget) {
        ModuleIndexService service = new ModuleIndexService();
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_MODULE_INDEX_SERVICE, (Service)service);
        serviceBuilder.install();
    }
}

