/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentDefinition;
import org.jboss.dmr.ModelNode;

public class DeploymentOverlayIndex {
    private final Map<String, Map<String, byte[]>> exactMatches;
    private final Map<String, Map<String, byte[]>> wildcards;

    private DeploymentOverlayIndex(Map<String, Map<String, byte[]>> exactMatches, Map<String, Map<String, byte[]>> wildcards) {
        this.exactMatches = exactMatches;
        this.wildcards = wildcards;
    }

    public Map<String, byte[]> getOverlays(String deployment) {
        HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
        Map<String, byte[]> exact = this.exactMatches.get(deployment);
        if (exact != null) {
            ret.putAll(exact);
        }
        for (Map.Entry<String, Map<String, byte[]>> entry : this.wildcards.entrySet()) {
            if (!DeploymentOverlayIndex.getPattern(entry.getKey()).matcher(deployment).matches()) continue;
            for (Map.Entry<String, byte[]> e : entry.getValue().entrySet()) {
                if (ret.containsKey(e.getKey())) continue;
                ret.put(e.getKey(), e.getValue());
            }
        }
        return ret;
    }

    public static DeploymentOverlayIndex createDeploymentOverlayIndex(OperationContext context) {
        HashMap<String, Map<String, byte[]>> exactMatches = new HashMap<String, Map<String, byte[]>>();
        LinkedHashMap<String, Map<String, byte[]>> wildcards = new LinkedHashMap<String, Map<String, byte[]>>();
        Set overlayNames = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay")})).getChildrenNames("deployment-overlay");
        for (String overlay : overlayNames) {
            Set deployments = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay", (String)overlay)})).getChildrenNames("deployment");
            for (String deployment : deployments) {
                if (DeploymentOverlayIndex.isWildcard(deployment)) {
                    DeploymentOverlayIndex.handleContent(context, wildcards, overlay, deployment);
                    continue;
                }
                DeploymentOverlayIndex.handleContent(context, exactMatches, overlay, deployment);
            }
        }
        return new DeploymentOverlayIndex(exactMatches, wildcards);
    }

    private static void handleContent(OperationContext context, Map<String, Map<String, byte[]>> wildcards, String overlay, String deployment) {
        Map<String, byte[]> contentMap = wildcards.get(deployment);
        if (contentMap == null) {
            contentMap = new HashMap<String, byte[]>();
            wildcards.put(deployment, contentMap);
        }
        Set content = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay", (String)overlay)})).getChildrenNames("content");
        for (String contentItem : content) {
            ModelNode sha;
            Resource cr = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay", (String)overlay), PathElement.pathElement((String)"content", (String)contentItem)}));
            try {
                sha = DeploymentOverlayContentDefinition.CONTENT_ATTRIBUTE.resolveModelAttribute(context, cr.getModel());
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
            String key = contentItem.startsWith("/") ? contentItem.substring(1) : contentItem;
            contentMap.put(key, sha.asBytes());
        }
    }

    private static boolean isWildcard(String name) {
        return name.contains("*") || name.contains("?");
    }

    static Pattern getPattern(String name) {
        return Pattern.compile(DeploymentOverlayIndex.wildcardToJavaRegexp(name));
    }

    private static String wildcardToJavaRegexp(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        String regex = expr.replaceAll("([(){}\\[\\].+^$])", "\\\\$1");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        return regex;
    }
}

