/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class ServiceModuleLoader
extends ModuleLoader
implements Service<ServiceModuleLoader> {
    private static final ServerLogger log = ServerLogger.MODULE_SERVICE_LOGGER;
    public static final ServiceName MODULE_SPEC_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"module", "spec", "service"});
    public static final ServiceName MODULE_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"module", "service"});
    public static final ServiceName MODULE_RESOLVED_SERVICE_PREFIX = ServiceName.of((String[])new String[]{"module", "resolved", "service"});
    public static final String MODULE_PREFIX = "deployment.";
    private final ModuleLoader mainModuleLoader;
    private volatile ServiceContainer serviceContainer;

    public ServiceModuleLoader(ModuleLoader mainModuleLoader) {
        this.mainModuleLoader = mainModuleLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (identifier.getName().startsWith(MODULE_PREFIX)) {
            Class<ServiceModuleLoader> clazz = ServiceModuleLoader.class;
            synchronized (ServiceModuleLoader.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return super.preloadModule(identifier);
            }
        }
        return ServiceModuleLoader.preloadModule((ModuleIdentifier)identifier, (ModuleLoader)this.mainModuleLoader);
    }

    public ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ServiceController controller = this.serviceContainer.getService(ServiceModuleLoader.moduleSpecServiceName(identifier));
        if (controller == null) {
            ServerLogger.MODULE_SERVICE_LOGGER.debugf("Could not load module '%s' as corresponding module spec service '%s' was not found", identifier, identifier);
            return null;
        }
        ModuleSpecLoadListener listener = new ModuleSpecLoadListener();
        controller.addListener((ServiceListener)listener);
        return listener.getModuleSpec();
    }

    public String toString() {
        return "Service Module Loader";
    }

    public synchronized void start(StartContext context) throws StartException {
        if (this.serviceContainer != null) {
            throw ServerLogger.ROOT_LOGGER.serviceModuleLoaderAlreadyStarted();
        }
        this.serviceContainer = context.getController().getServiceContainer();
    }

    public synchronized void stop(StopContext context) {
        if (this.serviceContainer == null) {
            throw ServerLogger.ROOT_LOGGER.serviceModuleLoaderAlreadyStopped();
        }
        this.serviceContainer = null;
    }

    public ServiceModuleLoader getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void relinkModule(Module module) throws ModuleLoadException {
        this.relink(module);
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration) {
        ServiceModuleLoader service = new ServiceModuleLoader(configuration.getModuleLoader());
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVICE_MODULE_LOADER, (Service)service);
        serviceBuilder.install();
    }

    public static ServiceName moduleSpecServiceName(ModuleIdentifier identifier) {
        if (!ServiceModuleLoader.isDynamicModule(identifier)) {
            throw ServerLogger.ROOT_LOGGER.missingModulePrefix(identifier, MODULE_PREFIX);
        }
        return MODULE_SPEC_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    public static void installModuleResolvedService(ServiceTarget serviceTarget, ModuleIdentifier identifier) {
        ValueService resolvedService = new ValueService((Value)new ImmediateValue((Object)identifier));
        serviceTarget.addService(ServiceModuleLoader.moduleResolvedServiceName(identifier), (Service)resolvedService).addDependency(ServiceModuleLoader.moduleSpecServiceName(identifier)).install();
    }

    public static ServiceName moduleResolvedServiceName(ModuleIdentifier identifier) {
        if (!ServiceModuleLoader.isDynamicModule(identifier)) {
            throw ServerLogger.ROOT_LOGGER.missingModulePrefix(identifier, MODULE_PREFIX);
        }
        return MODULE_RESOLVED_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    public static boolean isDynamicModule(ModuleIdentifier identifier) {
        return identifier.getName().startsWith(MODULE_PREFIX);
    }

    public static ServiceName moduleServiceName(ModuleIdentifier identifier) {
        if (!identifier.getName().startsWith(MODULE_PREFIX)) {
            throw ServerLogger.ROOT_LOGGER.missingModulePrefix(identifier, MODULE_PREFIX);
        }
        return MODULE_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    private class ModuleSpecLoadListener
    extends AbstractServiceListener<ModuleDefinition> {
        private volatile StartException startException;
        private volatile ModuleSpec moduleSpec;

        private ModuleSpecLoadListener() {
        }

        public void listenerAdded(ServiceController<? extends ModuleDefinition> controller) {
            log.tracef("listenerAdded: %s", controller);
            ServiceController.State state = controller.getState();
            if (state == ServiceController.State.UP || state == ServiceController.State.START_FAILED) {
                this.done(controller, controller.getStartException());
            }
        }

        public void transition(ServiceController<? extends ModuleDefinition> controller, ServiceController.Transition transition) {
            switch (transition) {
                case STARTING_to_UP: {
                    log.tracef("serviceStarted: %s", controller);
                    this.done(controller, null);
                    break;
                }
                case STARTING_to_START_FAILED: {
                    log.tracef((Throwable)controller.getStartException(), "serviceFailed: %s", controller);
                    this.done(controller, controller.getStartException());
                    break;
                }
                case STOP_REQUESTED_to_STOPPING: {
                    log.tracef("serviceStopping: %s", controller);
                    ModuleSpec moduleSpec = this.moduleSpec;
                    String identifier = moduleSpec.getName();
                    Module module = ServiceModuleLoader.this.findLoadedModuleLocal(identifier);
                    if (module != null) {
                        ServiceModuleLoader.this.unloadModuleLocal(identifier, module);
                    }
                    controller.removeListener((ServiceListener)this);
                    break;
                }
            }
        }

        private void done(ServiceController<? extends ModuleDefinition> controller, StartException reason) {
            this.startException = reason;
            if (this.startException == null) {
                this.moduleSpec = ((ModuleDefinition)controller.getValue()).getModuleSpec();
            }
        }

        public ModuleSpec getModuleSpec() throws ModuleLoadException {
            if (this.startException != null) {
                throw new ModuleLoadException(this.startException.getCause());
            }
            return this.moduleSpec;
        }
    }
}

