/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.wildfly.common.Assert;

public final class AttributeValue
implements Comparable<AttributeValue>,
Serializable {
    private static final int K_OPAQUE = 0;
    private static final int K_NUMERIC = 1;
    private static final int K_STRING = 2;
    private static final int K_BOOLEAN_TRUE = 3;
    private static final int K_BOOLEAN_FALSE = 4;
    private static final AttributeValue TRUE = new AttributeValue("true", 3);
    private static final AttributeValue FALSE = new AttributeValue("false", 4);
    private final byte[] content;
    private final int hashCode;
    private final int kind;
    private final int asInt;
    private String toString;
    private static final byte[] TRUE_BYTES = "true".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FALSE_BYTES = "false".getBytes(StandardCharsets.US_ASCII);

    private AttributeValue(byte[] content, String toString, int kind) {
        this.content = content;
        this.hashCode = Arrays.hashCode(content);
        this.kind = kind;
        this.asInt = kind == 1 ? Integer.parseInt(toString) : 0;
        this.toString = toString;
    }

    private AttributeValue(String string, int kind) {
        this(string.getBytes(StandardCharsets.UTF_8), string, kind);
    }

    public static AttributeValue fromString(String string) {
        Assert.checkNotNullParam((String)"string", (Object)string);
        switch (string) {
            case "true": {
                return TRUE;
            }
            case "false": {
                return FALSE;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(string.length());
        boolean bs = false;
        boolean fd = false;
        int fb = 0;
        int i = 0;
        while (i < string.length()) {
            int cp = string.codePointAt(i);
            if (bs) {
                if (cp == 92) {
                    bs = false;
                    baos.write(92);
                } else if (cp >= 0 && cp <= 9 || cp >= 97 && cp <= 102 || cp >= 65 && cp <= 70) {
                    int b = Character.digit(cp, 16);
                    if (fd) {
                        fd = false;
                        bs = false;
                        baos.write(fb << 4 | b);
                    } else {
                        fb = b;
                        fd = true;
                    }
                }
            } else if (cp == 92) {
                bs = true;
            } else if (cp < 128) {
                baos.write(cp);
            } else if (cp < 2048) {
                baos.write(0xC0 | 0x1F & cp >> 6);
                baos.write(0x80 | 0x3F & cp);
            } else if (cp < 65536) {
                baos.write(0xE0 | 0xF & cp >> 12);
                baos.write(0x80 | 0x3F & cp >> 6);
                baos.write(0x80 | 0x3F & cp);
            } else if (cp < 0x110000) {
                baos.write(0xF0 | 7 & cp >> 18);
                baos.write(0x80 | 0x3F & cp >> 12);
                baos.write(0x80 | 0x3F & cp >> 6);
                baos.write(0x80 | 0x3F & cp);
            } else {
                throw new IllegalArgumentException();
            }
            i = string.offsetByCodePoints(i, 1);
        }
        return AttributeValue.fromClonedBytes(baos.toByteArray());
    }

    public static AttributeValue fromBytes(byte[] bytes) {
        Assert.checkNotNullParam((String)"bytes", (Object)bytes);
        return AttributeValue.fromClonedBytes((byte[])bytes.clone());
    }

    private static AttributeValue fromClonedBytes(byte[] clone) {
        int kind = AttributeValue.analyze(clone);
        if (kind == 3) {
            return TRUE;
        }
        if (kind == 4) {
            return FALSE;
        }
        if (kind == 1) {
            return new AttributeValue(clone, new String(clone, StandardCharsets.US_ASCII), 1);
        }
        return new AttributeValue(clone, null, kind);
    }

    private static int analyze(byte[] content) {
        if (Arrays.equals(content, TRUE_BYTES)) {
            return 3;
        }
        if (Arrays.equals(content, FALSE_BYTES)) {
            return 4;
        }
        if (content.length == 0) {
            return 2;
        }
        int c = content[0] & 0xFF;
        if (c == 255) {
            return 0;
        }
        if (c == 45 || c >= 48 && c <= 57) {
            for (int i = 1; i < content.length; ++i) {
                if (c >= 48 && c <= 57) continue;
                return 2;
            }
            return 1;
        }
        return 2;
    }

    public boolean isBoolean() {
        int kind = this.kind;
        return kind == 3 || kind == 4;
    }

    public boolean isNumeric() {
        return this.kind == 1;
    }

    public boolean isOpaque() {
        return this.kind == 0;
    }

    public boolean isString() {
        return this.kind == 2;
    }

    public int asInt() throws IllegalArgumentException {
        if (this.kind == 1) {
            return this.asInt;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int compareTo(AttributeValue other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        int res = Integer.signum(other.kind - this.kind);
        if (res != 0) {
            return res;
        }
        switch (this.kind) {
            case 1: {
                return Integer.signum(other.asInt - this.asInt);
            }
            case 2: {
                return this.toString().compareTo(other.toString());
            }
            case 0: {
                return this.compareArray(this.content, other.content);
            }
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof AttributeValue && this.compareTo((AttributeValue)obj) == 0;
    }

    private int compareArray(byte[] c1, byte[] c2) {
        for (int i = 0; i < Math.min(c1.length, c2.length); ++i) {
            int res = Integer.signum((c2[i] & 0xFF) - (c1[i] & 0xFF));
            if (res == 0) continue;
            return res;
        }
        return Integer.signum(c1.length - c2.length);
    }

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            StringBuilder builder = new StringBuilder();
            byte[] content = this.content;
            switch (this.kind) {
                case 0: {
                    for (byte b : content) {
                        int l = b & 0xF;
                        int h = (b & 0xF0) >> 4;
                        builder.append('\\');
                        if (h < 10) {
                            builder.append(48 + h);
                        } else {
                            builder.append(65 + h - 10);
                        }
                        if (l < 10) {
                            builder.append(48 + l);
                            continue;
                        }
                        builder.append(65 + l - 10);
                    }
                    break;
                }
                case 2: {
                    int length = content.length;
                    int i = 0;
                    while (i < length) {
                        int b;
                        int a;
                        if ((a = content[i++] & 0xFF) < 128) {
                            if (Character.isISOControl(a)) {
                                int l = a & 0xF;
                                int h = (a & 0xF0) >> 4;
                                builder.append('\\');
                                if (h < 10) {
                                    builder.append(48 + h);
                                } else {
                                    builder.append(65 + h - 10);
                                }
                                if (l < 10) {
                                    builder.append(48 + l);
                                    continue;
                                }
                                builder.append(65 + l - 10);
                                continue;
                            }
                            builder.appendCodePoint(a);
                            continue;
                        }
                        if (a < 192) {
                            builder.append('\ufffd');
                            continue;
                        }
                        if (a < 224) {
                            if (i < length) {
                                b = content[i++] & 0xFF;
                                builder.appendCodePoint((a & 0x1F) << 6 | b & 0x3F);
                                continue;
                            }
                            builder.append('\ufffd');
                            continue;
                        }
                        if (a < 240) {
                            if (i < length) {
                                if (((b = content[i++] & 0xFF) & 0xC0) == 128) {
                                    if (i < length) {
                                        int c;
                                        if (((c = content[i++] & 0xFF) & 0xC0) == 128) {
                                            builder.appendCodePoint((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                                            continue;
                                        }
                                        builder.append('\ufffd');
                                        continue;
                                    }
                                    builder.append('\ufffd');
                                    continue;
                                }
                                builder.append('\ufffd');
                                continue;
                            }
                            builder.append('\ufffd');
                            continue;
                        }
                        if (a < 248) {
                            builder.append('\ufffd');
                            i += 4;
                            continue;
                        }
                        if (a < 252) {
                            builder.append('\ufffd');
                            i += 5;
                            continue;
                        }
                        builder.append('\ufffd');
                    }
                    break;
                }
                default: {
                    throw Assert.impossibleSwitchCase((int)this.kind);
                }
            }
            this.toString = builder.toString();
            return this.toString;
        }
        return toString;
    }

    Object writeReplace() {
        return new Serialized(this.content);
    }

    static class Serialized
    implements Serializable {
        private static final long serialVersionUID = 227138322941710864L;
        private final byte[] content;

        Serialized(byte[] content) {
            this.content = content;
        }

        byte[] getContent() {
            return this.content;
        }

        Object readResolve() {
            return AttributeValue.fromBytes(this.content);
        }
    }
}

