/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ConfiguredProvider;
import org.wildfly.discovery.InvalidDiscoveryConfigurationException;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.AggregateDiscoveryProvider;
import org.wildfly.discovery.impl.AggregateRegistryProvider;
import org.wildfly.discovery.impl.LocalRegistryAndDiscoveryProvider;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.RegistryProvider;

final class DiscoveryXmlParser {
    private static final DiscoveryProvider[] NO_DISCOVERY_PROVIDERS = new DiscoveryProvider[0];
    private static final RegistryProvider[] NO_REGISTRY_PROVIDERS = new RegistryProvider[0];
    static final String NS_DISCOVERY_1_0 = "urn:wildfly-discovery:1.0";

    private DiscoveryXmlParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ConfiguredProvider getConfiguredProvider() {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        if (clientConfiguration == null) return new ConfiguredProvider(DiscoveryProvider.EMPTY, RegistryProvider.EMPTY);
        try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(Collections.singleton(NS_DISCOVERY_1_0));){
            ConfiguredProvider configuredProvider = DiscoveryXmlParser.parseConfiguration(streamReader);
            return configuredProvider;
        }
        catch (ConfigXMLParseException e) {
            throw new InvalidDiscoveryConfigurationException(e);
        }
    }

    private static ConfiguredProvider parseConfiguration(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "discovery": {
                            ConfiguredProvider configuredProvider = DiscoveryXmlParser.parseDiscoveryElement(reader);
                            DiscoveryXmlParser.expectDocumentEnd(reader, configuredProvider);
                            return configuredProvider;
                        }
                    }
                    throw reader.unexpectedElement();
                }
            }
            throw reader.unexpectedContent();
        }
        return new ConfiguredProvider(DiscoveryProvider.EMPTY, RegistryProvider.EMPTY);
    }

    private static void expectDocumentEnd(ConfigurationXMLStreamReader reader, ConfiguredProvider configuredProvider) throws ConfigXMLParseException {
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 3: 
                case 5: {
                    continue block5;
                }
                case 8: {
                    return;
                }
                case 1: 
                case 2: {
                    throw reader.unexpectedElement();
                }
            }
            if (reader.isWhiteSpace()) continue;
            throw reader.unexpectedContent();
        }
    }

    private static ConfiguredProvider parseDiscoveryElement(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        DiscoveryProvider discoveryProvider = DiscoveryProvider.EMPTY;
        RegistryProvider registryProvider = RegistryProvider.EMPTY;
        LocalRegistryAndDiscoveryProvider localRegistry = new LocalRegistryAndDiscoveryProvider();
        DiscoveryXmlParser.requireNoAttributes(reader);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "discovery-provider": {
                            if (discoveryProvider != DiscoveryProvider.EMPTY) {
                                throw reader.unexpectedElement();
                            }
                            discoveryProvider = DiscoveryXmlParser.parseDiscoveryProvider(reader, localRegistry);
                            break block12;
                        }
                        case "registry-provider": {
                            if (registryProvider != RegistryProvider.EMPTY) {
                                throw reader.unexpectedElement();
                            }
                            registryProvider = DiscoveryXmlParser.parseRegistryProvider(reader, localRegistry);
                            break block12;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    break block12;
                }
                default: {
                    continue block12;
                }
            }
        }
        return new ConfiguredProvider(discoveryProvider, registryProvider);
    }

    private static RegistryProvider parseRegistryProvider(ConfigurationXMLStreamReader reader, LocalRegistryAndDiscoveryProvider localRegistry) throws ConfigXMLParseException {
        DiscoveryXmlParser.requireNoAttributes(reader);
        switch (reader.nextTag()) {
            case 1: {
                RegistryProvider registryProvider;
                DiscoveryXmlParser.checkNamespace(reader);
                switch (reader.getLocalName()) {
                    case "local-registry": {
                        registryProvider = localRegistry;
                        break;
                    }
                    case "aggregate": {
                        registryProvider = DiscoveryXmlParser.parseAggregateRegistry(reader, localRegistry);
                        break;
                    }
                    case "custom": {
                        registryProvider = DiscoveryXmlParser.parseCustom(reader, RegistryProvider.class);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                DiscoveryXmlParser.expectEnd(reader);
                return registryProvider;
            }
        }
        throw reader.unexpectedElement();
    }

    private static DiscoveryProvider parseDiscoveryProvider(ConfigurationXMLStreamReader reader, LocalRegistryAndDiscoveryProvider localRegistry) throws ConfigXMLParseException {
        DiscoveryXmlParser.requireNoAttributes(reader);
        switch (reader.nextTag()) {
            case 1: {
                DiscoveryProvider discoveryProvider;
                DiscoveryXmlParser.checkNamespace(reader);
                switch (reader.getLocalName()) {
                    case "local-registry": {
                        discoveryProvider = localRegistry;
                        break;
                    }
                    case "static": {
                        discoveryProvider = DiscoveryXmlParser.parseStatic(reader);
                        break;
                    }
                    case "aggregate": {
                        discoveryProvider = DiscoveryXmlParser.parseAggregateDiscovery(reader, localRegistry);
                        break;
                    }
                    case "custom": {
                        discoveryProvider = DiscoveryXmlParser.parseCustom(reader, DiscoveryProvider.class);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                DiscoveryXmlParser.expectEnd(reader);
                return discoveryProvider;
            }
        }
        throw reader.missingRequiredElement(NS_DISCOVERY_1_0, "local-registry/static/aggregate/custom");
    }

    private static DiscoveryProvider parseAggregateDiscovery(ConfigurationXMLStreamReader reader, LocalRegistryAndDiscoveryProvider localRegistry) throws ConfigXMLParseException {
        DiscoveryXmlParser.requireNoAttributes(reader);
        ArrayList<DiscoveryProvider> delegates = new ArrayList<DiscoveryProvider>();
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "discovery-provider": {
                            delegates.add(DiscoveryXmlParser.parseDiscoveryProvider(reader, localRegistry));
                            break block10;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        return new AggregateDiscoveryProvider(delegates.toArray(NO_DISCOVERY_PROVIDERS));
    }

    private static RegistryProvider parseAggregateRegistry(ConfigurationXMLStreamReader reader, LocalRegistryAndDiscoveryProvider localRegistry) throws ConfigXMLParseException {
        DiscoveryXmlParser.requireNoAttributes(reader);
        ArrayList<RegistryProvider> delegates = new ArrayList<RegistryProvider>();
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "registry-provider": {
                            delegates.add(DiscoveryXmlParser.parseRegistryProvider(reader, localRegistry));
                            break block10;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        return new AggregateRegistryProvider(delegates.toArray(NO_REGISTRY_PROVIDERS));
    }

    private static DiscoveryProvider parseStatic(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ArrayList<ServiceURL> serviceURLs = new ArrayList<ServiceURL>();
        DiscoveryXmlParser.requireNoAttributes(reader);
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "service": {
                            serviceURLs.add(DiscoveryXmlParser.parseService(reader));
                            break block10;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        return new StaticDiscoveryProvider(serviceURLs);
    }

    private static void requireNoAttributes(ConfigurationXMLStreamReader reader) {
        if (reader.getAttributeCount() > 0) {
            reader.unexpectedAttribute(0);
        }
    }

    private static ServiceURL parseService(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ServiceURL.Builder builder = new ServiceURL.Builder();
        URI uri = null;
        String uriSchemeAuthority = null;
        String abstractType = null;
        String abstractTypeAuthority = null;
        int cnt = reader.getAttributeCount();
        block22: for (int i = 0; i < cnt; ++i) {
            DiscoveryXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "uri": {
                    uri = reader.getURIAttributeValue(i);
                    continue block22;
                }
                case "uri-scheme-authority": {
                    uriSchemeAuthority = reader.getAttributeValue(i);
                    continue block22;
                }
                case "abstract-type": {
                    abstractType = reader.getAttributeValue(i);
                    continue block22;
                }
                case "abstract-type-authority": {
                    abstractTypeAuthority = reader.getAttributeValue(i);
                    continue block22;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (uri == null) {
            throw reader.missingRequiredAttribute(null, "uri");
        }
        builder.setUri(uri);
        if (uriSchemeAuthority != null) {
            builder.setUriSchemeAuthority(uriSchemeAuthority);
        }
        if (abstractType != null) {
            builder.setAbstractType(abstractType);
        }
        if (abstractTypeAuthority != null) {
            builder.setAbstractTypeAuthority(abstractTypeAuthority);
        }
        block23: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "attribute": {
                            DiscoveryXmlParser.parseAttribute(reader, builder);
                            break block23;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    break block23;
                }
                default: {
                    continue block23;
                }
            }
        }
        return builder.create();
    }

    private static void checkAttributeNamespace(ConfigurationXMLStreamReader reader, int i) throws ConfigXMLParseException {
        if (reader.getAttributeNamespace(i) != null) {
            throw reader.unexpectedAttribute(i);
        }
    }

    private static void parseAttribute(ConfigurationXMLStreamReader reader, ServiceURL.Builder builder) throws ConfigXMLParseException {
        String name = null;
        AttributeValue value = null;
        int cnt = reader.getAttributeCount();
        block8: for (int i = 0; i < cnt; ++i) {
            DiscoveryXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block8;
                }
                case "value": {
                    value = AttributeValue.fromString(reader.getAttributeValue(i));
                    continue block8;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (name == null) {
            throw reader.missingRequiredAttribute(null, "name");
        }
        DiscoveryXmlParser.expectEnd(reader);
        if (value == null) {
            builder.addAttribute(name);
        } else {
            builder.addAttribute(name, value);
        }
    }

    private static void checkNamespace(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        switch (reader.getNamespaceURI()) {
            case "urn:wildfly-discovery:1.0": {
                break;
            }
            default: {
                throw reader.unexpectedElement();
            }
        }
    }

    private static <T> T parseCustom(ConfigurationXMLStreamReader reader, Class<T> type) throws ConfigXMLParseException {
        Object item;
        block24: {
            String className = null;
            String moduleName = null;
            int cnt = reader.getAttributeCount();
            block18: for (int i = 0; i < cnt; ++i) {
                DiscoveryXmlParser.checkAttributeNamespace(reader, i);
                switch (reader.getAttributeLocalName(i)) {
                    case "class": {
                        className = reader.getAttributeValue(i);
                        continue block18;
                    }
                    case "module": {
                        moduleName = reader.getAttributeValue(i);
                        continue block18;
                    }
                    default: {
                        throw reader.unexpectedAttribute(i);
                    }
                }
            }
            ClassLoader searchLoader = DiscoveryXmlParser.class.getClassLoader();
            if (moduleName != null) {
                if (className != null) {
                    try {
                        item = Module.loadClassFromCallerModuleLoader(moduleName, className).asSubclass(type).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | ModuleLoadException e) {
                        throw new InvalidDiscoveryConfigurationException(e);
                    }
                }
                try {
                    ServiceLoader loader = Module.loadServiceFromCallerModuleLoader(moduleName, type);
                    Iterator iterator = loader.iterator();
                    try {
                        if (!iterator.hasNext()) {
                            throw new InvalidDiscoveryConfigurationException("No provider found in module " + moduleName);
                        }
                        item = iterator.next();
                        break block24;
                    }
                    catch (ServiceConfigurationError e) {
                        throw new InvalidDiscoveryConfigurationException(e);
                    }
                }
                catch (ModuleLoadException e) {
                    throw new InvalidDiscoveryConfigurationException(e);
                }
            }
            if (className != null) {
                try {
                    item = Class.forName(className, true, DiscoveryXmlParser.class.getClassLoader()).asSubclass(type).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new InvalidDiscoveryConfigurationException(e);
                }
            }
            ServiceLoader<T> loader = ServiceLoader.load(type);
            Iterator<T> iterator = loader.iterator();
            try {
                if (!iterator.hasNext()) {
                    throw new InvalidDiscoveryConfigurationException("No provider found");
                }
                item = iterator.next();
            }
            catch (ServiceConfigurationError e) {
                throw new InvalidDiscoveryConfigurationException(e);
            }
        }
        DiscoveryXmlParser.expectEnd(reader);
        return item;
    }

    private static void expectEnd(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
    }
}

