/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.auth;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;

public final class PropertiesFileAuth {
    private static final String APPLICATION_USERS = "application-users.properties";
    private static final String APPLICATION_ROLES = "application-roles.properties";
    private static final String MGMT_USERS = "mgmt-users.properties";
    private static final String MGMT_GROUPS = "mgmt-groups.properties";
    private final String fileName;
    private final File file;
    private static final Pattern REALM = Pattern.compile("\\$REALM_NAME=(.*?)\\$");

    public static Users applicationUsers() {
        return new Users(PropertiesFileAuth.inConfigurationDirectory(APPLICATION_USERS));
    }

    public static UserMappings applicationRoles() {
        return new UserMappings(PropertiesFileAuth.inConfigurationDirectory(APPLICATION_ROLES));
    }

    public static Users mgmtUsers() {
        return new Users(PropertiesFileAuth.inConfigurationDirectory(MGMT_USERS));
    }

    public static UserMappings mgmtGroups() {
        return new UserMappings(PropertiesFileAuth.inConfigurationDirectory(MGMT_GROUPS));
    }

    public static PropertiesFileAuth inConfigurationDirectory(String fileName) {
        return new PropertiesFileAuth(fileName, null);
    }

    public static PropertiesFileAuth of(File file) {
        return new PropertiesFileAuth(null, file);
    }

    private PropertiesFileAuth(String fileName, File file) {
        this.fileName = fileName;
        this.file = file;
    }

    private File thePropertiesFile(OfflineCommandContext ctx) {
        if (this.file != null) {
            return this.file;
        }
        return new File(ctx.options.configurationDirectory(), this.fileName);
    }

    public OfflineCommand defineUser(String username, String password) {
        return new DefineUser(username, password);
    }

    public OfflineCommand undefineUser(String username) {
        return new UndefineUser(username);
    }

    public OfflineCommand defineUserMapping(String username, String roleOrGroup) {
        return new DefineUserMapping(username, roleOrGroup);
    }

    public OfflineCommand undefineUserMapping(String username, String roleOrGroup) {
        return new UndefineUserMapping(username, roleOrGroup);
    }

    public static final class UserMappings {
        private final PropertiesFileAuth delegate;

        private UserMappings(PropertiesFileAuth delegate) {
            this.delegate = delegate;
        }

        public OfflineCommand defineUserMapping(String username, String roleOrGroup) {
            return this.delegate.defineUserMapping(username, roleOrGroup);
        }

        public OfflineCommand undefineUserMapping(String username, String roleOrGroup) {
            return this.delegate.undefineUserMapping(username, roleOrGroup);
        }
    }

    public static final class Users {
        private final PropertiesFileAuth delegate;

        private Users(PropertiesFileAuth delegate) {
            this.delegate = delegate;
        }

        public OfflineCommand defineUser(String username, String password) {
            return this.delegate.defineUser(username, password);
        }

        public OfflineCommand undefineUser(String username) {
            return this.delegate.undefineUser(username);
        }
    }

    private final class UndefineUserMapping
    extends AbstractUserMapping {
        UndefineUserMapping(String username, String roleOrGroup) {
            super(username, roleOrGroup, false);
        }
    }

    private final class DefineUserMapping
    extends AbstractUserMapping {
        DefineUserMapping(String username, String roleOrGroup) {
            super(username, roleOrGroup, true);
        }
    }

    private abstract class AbstractUserMapping
    implements OfflineCommand {
        private final String username;
        private final String roleOrGroup;
        private final boolean trueToAdd_falseToRemove;

        public AbstractUserMapping(String username, String roleOrGroup, boolean trueToAdd_falseToRemove) {
            this.username = username;
            this.roleOrGroup = roleOrGroup;
            this.trueToAdd_falseToRemove = trueToAdd_falseToRemove;
        }

        public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
            File file = PropertiesFileAuth.this.thePropertiesFile(ctx);
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            HashSet allRolesOrGroupsForUser = Sets.newHashSet();
            Iterable linesForUser = Iterables.filter((Iterable)lines, (Predicate)Predicates.containsPattern((String)("^" + Pattern.quote(this.username) + "=")));
            Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
            for (String line : linesForUser) {
                String rolesOrGroups = line.replaceFirst("^" + Pattern.quote(this.username) + "=", "");
                allRolesOrGroupsForUser.addAll(splitter.splitToList((CharSequence)rolesOrGroups));
            }
            if (this.trueToAdd_falseToRemove) {
                allRolesOrGroupsForUser.add(this.roleOrGroup);
            } else {
                allRolesOrGroupsForUser.remove(this.roleOrGroup);
            }
            Iterables.removeIf((Iterable)lines, (Predicate)Predicates.containsPattern((String)("^" + Pattern.quote(this.username) + "=")));
            lines.add(this.username + "=" + Joiner.on((char)',').join((Iterable)allRolesOrGroupsForUser));
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)lines, "\n");
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.username + " -> " + this.roleOrGroup;
        }
    }

    private final class UndefineUser
    implements OfflineCommand {
        private final String username;

        UndefineUser(String username) {
            this.username = username;
        }

        public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
            File file = PropertiesFileAuth.this.thePropertiesFile(ctx);
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            Iterables.removeIf((Iterable)lines, (Predicate)Predicates.containsPattern((String)("^" + Pattern.quote(this.username) + "=")));
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)lines, "\n");
        }

        public String toString() {
            return "UndefineUser " + this.username;
        }
    }

    private final class DefineUser
    implements OfflineCommand {
        private final String username;
        private final String password;

        DefineUser(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
            File file = PropertiesFileAuth.this.thePropertiesFile(ctx);
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            Optional realmLine = Iterables.tryFind((Iterable)lines, (Predicate)Predicates.contains((Pattern)REALM));
            if (!realmLine.isPresent()) {
                throw new CommandFailedException("The $REALM_NAME=...$ directive is missing: " + file);
            }
            Matcher matcher = REALM.matcher((CharSequence)realmLine.get());
            matcher.find();
            String realm = matcher.group(1);
            Iterables.removeIf((Iterable)lines, (Predicate)Predicates.containsPattern((String)("^" + this.username + "=")));
            String authString = this.username + ":" + realm + ":" + this.password;
            String hashedAuthString = Hashing.md5().hashString((CharSequence)authString, Charsets.UTF_8).toString();
            lines.add(this.username + "=" + hashedAuthString);
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)lines, "\n");
        }

        public String toString() {
            return "DefineUser " + this.username;
        }
    }
}

