/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Properties;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.galleon.plugin.server.ClassLoaderHelper;

public class CompleteServerInvoker {
    private final Path installationDir;
    private final String serverConfig;
    private Object server;
    private final URLClassLoader newCl;

    public CompleteServerInvoker(Path installationDir, MessageWriter messageWriter, String serverConfig) {
        this.installationDir = installationDir;
        this.serverConfig = serverConfig;
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        this.newCl = ClassLoaderHelper.prepareClassLoader((Path)installationDir, (ClassLoader)originalCl, (URL[])new URL[0]);
    }

    public void startServer() throws IOException, ProvisioningException {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        Properties props = System.getProperties();
        try {
            Thread.currentThread().setContextClassLoader(this.newCl);
            Class<?> serverClass = this.newCl.loadClass("org.wildfly.galleon.plugin.config.generator.CompleteServer");
            this.server = serverClass.getConstructor(Path.class, String.class).newInstance(this.installationDir, this.serverConfig);
            Method startServerMethod = serverClass.getMethod("startServer", new Class[0]);
            startServerMethod.invoke(this.server, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ProvisioningException(ex.getMessage(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            System.setProperties(props);
        }
    }

    public void stopServer() throws ProvisioningException {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.newCl);
            if (this.server != null) {
                Method stopServerMethod = this.server.getClass().getMethod("stopServer", new Class[0]);
                stopServerMethod.invoke(this.server, new Object[0]);
            }
            this.server = null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ProvisioningException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            ClassLoaderHelper.close((URLClassLoader)this.newCl);
        }
    }

    public boolean isServerActive() {
        return this.server == null;
    }
}

