/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.arguments.ArgumentValueCallbackHandler;
import org.jboss.as.cli.parsing.arguments.ArgumentValueInitialState;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.xml.ConfigXmlWriter;
import org.jboss.galleon.xml.ProvisionedFeatureBuilder;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.wildfly.galleon.plugin.config.generator.WfEmbeddedTaskBase;

public class WfConfigsReader
extends WfEmbeddedTaskBase<List<ProvisionedConfig>> {
    private static final String DOMAIN_ELEMENT = "<domain ";
    private static final String HOST_ELEMENT = "<host ";
    private static final String SERVER_ELEMENT = "<server ";
    private static final String DOT_XML = ".xml";
    private static final Set<String> READ_ONLY_PATHS;
    private Path home;
    private MessageWriter log;
    private ProvisioningLayout<?> layout;
    private ProvisionedConfig provisionedConfig;
    private ConfigSpecMapper specMapper = new ConfigSpecMapper();
    private Map<String, FeatureSpec> loadedSpecs = Collections.emptyMap();
    private List<ConfigModel> userConfigs = Collections.emptyList();
    private String configModel;
    private String configName;
    private String hostName;
    private static final Object EMPTY_LIST_OR_OBJ;

    public static List<ConfigModel> exportDiff(ProvisioningLayout<?> layout, ProvisionedState provisionedState, MessageWriter log, Path home) throws ProvisioningException {
        WfConfigsReader reader = new WfConfigsReader();
        reader.log = log;
        reader.home = home;
        reader.generate(layout, provisionedState, home, log, false);
        Path baseDir = Paths.get(System.getProperty("user.home"), new String[0]).resolve("galleon-scripts");
        for (ConfigModel config : reader.userConfigs) {
            try {
                ConfigXmlWriter.getInstance().write((Object)config, baseDir.resolve(config.getName()));
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return reader.userConfigs;
    }

    @Override
    protected String getHome(ProvisioningRuntime runtime) {
        return this.home.toString();
    }

    @Override
    protected void doGenerate(ProvisioningLayout<?> layout, ProvisionedState provisionedState) throws ProvisioningException {
        this.layout = layout;
        List provisionedConfigs = provisionedState.getConfigs();
        HashMap<String, Path> actualStandaloneConfigs = new HashMap<String, Path>(provisionedConfigs.size());
        Path configDir = this.home.resolve("standalone").resolve("configuration");
        if (Files.exists(configDir, new LinkOption[0])) {
            this.locateConfigs(configDir, actualStandaloneConfigs, SERVER_ELEMENT);
        }
        if (Files.exists(configDir = this.home.resolve("domain").resolve("configuration"), new LinkOption[0])) {
            this.locateConfigs(configDir, actualStandaloneConfigs, DOMAIN_ELEMENT, HOST_ELEMENT);
        }
        for (ProvisionedConfig config : provisionedConfigs) {
            Path path = (Path)actualStandaloneConfigs.remove(config.getName());
            if (path == null) {
                System.out.println("Exclude config " + config.getName());
                continue;
            }
            this.provisionedConfig = config;
            this.configModel = config.getModel();
            this.configName = config.getName();
            this.readConfig(this.getConfigArg(this.configModel), path);
            this.provisionedConfig = null;
        }
        this.configModel = "standalone";
        for (Path newConfig : actualStandaloneConfigs.values()) {
            this.configModel = newConfig.getParent().getParent().getFileName().toString();
            this.configName = newConfig.getFileName().toString();
            this.readConfig(this.getConfigArg(this.configModel), newConfig);
        }
    }

    @Override
    protected String[] getForkArgs() throws ProvisioningException {
        String[] superArgs = super.getForkArgs();
        int i = superArgs.length + 2;
        String[] args = new String[i];
        System.arraycopy(superArgs, 0, args, 0, superArgs.length);
        Path configXml = this.layout.getTmpPath(new String[]{"diffgen"}).resolve("provisioning.xml");
        try {
            ProvisioningXmlWriter.getInstance().write((Object)this.layout.getConfig(), configXml);
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to persist provisioning config", (Throwable)e);
        }
        args[--i] = configXml.toString();
        args[--i] = this.layout.getFactory().getHome().toString();
        return args;
    }

    @Override
    public void forkedForEmbedded(String ... args) throws ProvisioningException {
        int i = args.length;
        String provisioningXml = args[--i];
        ProvisioningConfig provisioningConfig = ProvisioningXmlParser.parse((Path)Paths.get(provisioningXml, new String[0]));
        Path layoutFactoryHome = Paths.get(args[--i], new String[0]);
        this.layout = ProvisioningLayoutFactory.getInstance((Path)layoutFactoryHome, null).newConfigLayout(provisioningConfig);
        super.forkedForEmbedded(args);
    }

    private String getConfigArg(String configModel) {
        switch (configModel) {
            case "standalone": {
                return "--server-config";
            }
            case "domain": {
                return "--domain-config";
            }
            case "host": {
                return "--host-config";
            }
        }
        throw new IllegalStateException("Unexpected config model " + configModel);
    }

    private void locateConfigs(Path configDir, Map<String, Path> actualConfigs, String ... firstElement) throws ProvisioningException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(configDir);){
            for (Path p : stream) {
                String fileName;
                int length;
                if (!Files.isRegularFile(p, new LinkOption[0]) || (length = (fileName = p.getFileName().toString()).length()) < DOT_XML.length() + 1 || !fileName.regionMatches(true, length - DOT_XML.length(), DOT_XML, 0, DOT_XML.length()) || !WfConfigsReader.isConfig(p, firstElement)) continue;
                actualConfigs.put(fileName, p);
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readDirectory((Path)configDir), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig(String configArg, Path configPath) throws ProvisioningException {
        try {
            ModelNode readConfigOp = Operations.createOperation((String)"read-config-as-features");
            if (configArg.equals("--server-config")) {
                this.startServer("--admin-only", configArg, configPath.getFileName().toString());
            } else {
                this.startHc(configArg, configPath.getFileName().toString());
                if (configArg.equals("--host-config")) {
                    this.hostName = "";
                    ModelNode readHostNameOp = Operations.createOperation((String)"read-children-names");
                    readHostNameOp.get("child-type").set("host");
                    this.handle(readHostNameOp);
                    ModelNode addr = readConfigOp.get("address");
                    addr.add("host", this.hostName);
                    this.hostName = null;
                }
            }
            readConfigOp.get("nested").set(false);
            this.handle(readConfigOp);
        }
        finally {
            this.stopEmbedded();
        }
    }

    @Override
    protected void handleSuccess(ModelNode response) throws ProvisioningException {
        int model;
        if (this.hostName != null) {
            if (!Operations.isSuccessfulOutcome((ModelNode)response)) {
                throw new ProvisioningException("Failed to determine the host name: " + Operations.getFailureDescription((ModelNode)response));
            }
            List list = Operations.readResult((ModelNode)response).asList();
            if (list.size() != 1) {
                throw new ProvisioningException("Failed to determine the host name: expected one item in the list but got " + list);
            }
            this.hostName = ((ModelNode)list.get(0)).asString();
            return;
        }
        this.specMapper.reset();
        if (this.provisionedConfig != null) {
            this.specMapper.map(this.provisionedConfig);
        }
        if (this.configModel.equals("standalone")) {
            model = 0;
        } else if (this.configModel.equals("domain")) {
            model = 1;
        } else if (this.configModel.equals("host")) {
            model = 2;
        } else {
            throw new IllegalStateException("Unexpected config model " + this.configModel);
        }
        if (this.log != null) {
            this.log.print((CharSequence)("Analyzing " + this.configName));
        }
        ConfigModel.Builder configBuilder = null;
        String prevSpec = null;
        ResolvedSpecId specId = null;
        Map<Object, Object> specFeatures = Collections.emptyMap();
        for (ModelNode modelNode : response.get("result").asList()) {
            FeatureParameterSpec paramSpec;
            String paramName;
            FeatureConfig feature;
            List params;
            ProvisionedFeature provisionedFeature;
            List props;
            String specName;
            try {
                specName = modelNode.get("spec").asString();
            }
            catch (Throwable t) {
                throw new ProvisioningException("Failed to process " + modelNode, t);
            }
            if (model == 1 && specName.startsWith("profile.")) {
                specName = specName.substring("profile.".length());
            }
            if (!specName.equals(prevSpec)) {
                specId = this.specMapper.specs.get(specName);
                if (specId == null) {
                    specId = this.resolveSpec(specName);
                    if (specId == null) {
                        if (model == 1 && specName.startsWith("domain.")) {
                            specName = specName.substring("domain.".length());
                            specId = this.resolveSpec(specName);
                        } else if (model == 2 && specName.startsWith("host.")) {
                            specName = specName.substring("host.".length());
                            specId = this.resolveSpec(specName);
                        }
                    }
                    if (specId == null) {
                        throw new ProvisioningException("Failed to locate feature spec " + modelNode.get("spec").asString() + " in the installed feature-packs");
                    }
                }
                prevSpec = specName;
                specFeatures = this.specMapper.features.get(specName);
            }
            ResolvedFeatureId actualFeatureId = null;
            if (modelNode.hasDefined("id") && !(props = modelNode.get("id").asPropertyList()).isEmpty()) {
                ResolvedFeatureId.Builder idBuilder = ResolvedFeatureId.builder((ResolvedSpecId)specId);
                for (Object prop : props) {
                    idBuilder.setParam(prop.getName(), (Object)prop.getValue().asString());
                }
                actualFeatureId = idBuilder.build();
            }
            ProvisionedFeature provisionedFeature2 = provisionedFeature = specFeatures == null ? null : (ProvisionedFeature)specFeatures.remove(actualFeatureId);
            if (!modelNode.hasDefined("params") || (params = modelNode.get("params").asPropertyList()).isEmpty()) continue;
            if (provisionedFeature == null) {
                Object prop;
                if (specName.equals("path") && READ_ONLY_PATHS.contains(actualFeatureId.getParams().get("path"))) continue;
                feature = actualFeatureId == null ? new FeatureConfig(specName) : this.newFeatureConfig(actualFeatureId);
                prop = params.iterator();
                while (prop.hasNext()) {
                    Property prop2 = (Property)prop.next();
                    feature.setParam(prop2.getName(), prop2.getValue().asString());
                }
                if (configBuilder == null) {
                    configBuilder = ConfigModel.builder((String)this.configModel, (String)this.configName);
                }
                configBuilder.addFeature(feature);
                if (this.log == null) continue;
                this.log.print("Added feature %s", new Object[]{feature});
                continue;
            }
            feature = null;
            HashMap provisionedParams = new HashMap(((ProvisionedFeatureBuilder)provisionedFeature).getConfigParams());
            for (String idParam : actualFeatureId.getParams().keySet()) {
                provisionedParams.remove(idParam);
            }
            FeatureSpec featureSpec = this.getFeatureSpec(specId);
            for (Property property : params) {
                paramName = property.getName();
                if (!featureSpec.hasParam(paramName)) {
                    if (this.log == null) continue;
                    this.log.print((CharSequence)("WARN: parameter " + paramName + " is not found in " + specId));
                    continue;
                }
                paramSpec = featureSpec.getParam(paramName);
                Object provisionedValue = WfConfigsReader.resolve(property, (String)provisionedParams.remove(paramName));
                Object actualValue = WfConfigsReader.toJava(property.getValue());
                if (provisionedValue != null && actualValue.equals(provisionedValue)) continue;
                if (provisionedValue == null) {
                    if (paramName.equals("module") && specName.equals("extension") && actualValue.equals(actualFeatureId.getParams().get("extension"))) continue;
                    if (feature == null) {
                        feature = actualFeatureId == null ? new FeatureConfig(specName) : this.newFeatureConfig(actualFeatureId);
                    }
                    feature.setParam(paramName, property.getValue().asString());
                    if (this.log == null) continue;
                    this.log.print("Parameter %s of %s set to %s", new Object[]{paramName, actualFeatureId, actualValue});
                    continue;
                }
                if (this.log != null) {
                    this.log.print("Parameter %s of %s changed from %s to %s", new Object[]{paramName, actualFeatureId, provisionedValue, actualValue});
                }
                if (provisionedValue.equals(WfConfigsReader.resolve(property, paramSpec.getDefaultValue()))) continue;
                if (feature == null) {
                    feature = actualFeatureId == null ? new FeatureConfig(specName) : this.newFeatureConfig(actualFeatureId);
                }
                feature.setParam(paramName, property.getValue().asString());
            }
            if (!provisionedParams.isEmpty()) {
                for (Map.Entry entry : provisionedParams.entrySet()) {
                    paramName = (String)entry.getKey();
                    paramSpec = featureSpec.getParam(paramName);
                    if ("GLN_UNDEFINED".equals(paramSpec.getDefaultValue()) || paramName.equals("extension") && specName.startsWith("subsystem.") || paramName.equals("persist-name") && specName.equals("host")) continue;
                    if (feature == null) {
                        feature = actualFeatureId == null ? new FeatureConfig(specName) : this.newFeatureConfig(actualFeatureId);
                    }
                    feature.unsetParam(paramName);
                    if (this.log == null) continue;
                    this.log.print("Parameter %s of %s is unset", new Object[]{paramName, actualFeatureId});
                }
            }
            if (feature == null) continue;
            if (configBuilder == null) {
                configBuilder = ConfigModel.builder((String)this.configModel, (String)this.configName);
            }
            configBuilder.addFeature(feature);
        }
        if (!this.specMapper.features.isEmpty()) {
            for (Map map : this.specMapper.features.values()) {
                if (map.isEmpty()) continue;
                for (Map.Entry entry : map.entrySet()) {
                    ResolvedFeatureId removedId = (ResolvedFeatureId)entry.getKey();
                    if (removedId == null) {
                        throw new ProvisioningException("Feature " + entry.getValue() + " has no ID");
                    }
                    String specName = removedId.getSpecId().getName();
                    if (specName.equals("core-service.management") || specName.equals("server-root")) continue;
                    if (configBuilder == null) {
                        configBuilder = ConfigModel.builder((String)this.configModel, (String)this.configName);
                    }
                    FeatureId.Builder idBuilder = FeatureId.builder((String)specName);
                    for (Map.Entry entry2 : removedId.getParams().entrySet()) {
                        idBuilder.setParam((String)entry2.getKey(), entry2.getValue().toString());
                    }
                    configBuilder.excludeFeature(idBuilder.build());
                    if (this.log == null) continue;
                    this.log.print("Excluded %s", new Object[]{removedId});
                }
            }
        }
        if (!this.specMapper.excludedSpecs.isEmpty()) {
            if (configBuilder == null) {
                configBuilder = ConfigModel.builder((String)this.configModel, (String)this.configName);
            }
            for (String string : this.specMapper.excludedSpecs) {
                configBuilder.excludeSpec(string);
            }
        }
        if (configBuilder != null) {
            this.userConfigs = CollectionUtils.add(this.userConfigs, (Object)configBuilder.build());
        }
    }

    private ResolvedSpecId resolveSpec(String specName) throws ProvisioningException {
        List fps = this.layout.getOrderedFeaturePacks();
        for (int i = fps.size() - 1; i >= 0; --i) {
            FeaturePackLayout fp = (FeaturePackLayout)fps.get(i);
            FeatureSpec spec = fp.loadFeatureSpec(specName);
            if (spec == null) continue;
            return new ResolvedSpecId(fp.getFPID().getProducer(), specName);
        }
        return null;
    }

    private FeatureSpec getFeatureSpec(ResolvedSpecId specId) throws ProvisioningException {
        FeatureSpec featureSpec = this.loadedSpecs.get(specId.getName());
        if (featureSpec != null) {
            return featureSpec;
        }
        featureSpec = this.layout.getFeaturePack(specId.getProducer()).loadFeatureSpec(specId.getName());
        this.loadedSpecs = CollectionUtils.put(this.loadedSpecs, (Object)specId.getName(), (Object)featureSpec);
        return featureSpec;
    }

    private FeatureConfig newFeatureConfig(ResolvedFeatureId id) throws ProvisioningDescriptionException {
        FeatureConfig featureConfig = new FeatureConfig(id.getSpecId().getName());
        for (Map.Entry param : id.getParams().entrySet()) {
            featureConfig.setParam((String)param.getKey(), param.getValue().toString());
        }
        return featureConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isConfig(Path configPath, String ... firstElement) throws ProvisioningException {
        int n;
        int n2;
        String[] stringArray;
        String line;
        try (BufferedReader reader = Files.newBufferedReader(configPath);){
            block32: {
                line = reader.readLine();
                if (line == null) {
                    boolean bl = false;
                    return bl;
                }
                do {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) != '<') continue;
                    if (line.length() < 2) {
                        boolean bl = false;
                        return bl;
                    }
                    char c = line.charAt(1);
                    if (c != '?' && c != '!') break block32;
                } while ((line = reader.readLine()) != null);
                return false;
            }
            stringArray = firstElement;
            n2 = stringArray.length;
            n = 0;
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile((Path)configPath), (Throwable)e);
        }
        while (n < n2) {
            String e = stringArray[n];
            if (line.regionMatches(0, e, 0, e.length())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void forkedEmbeddedMessage(String msg) {
    }

    @Override
    public List<ProvisionedConfig> getResult() {
        return Collections.emptyList();
    }

    @Override
    protected void doStartServer(String ... args) throws ProvisioningException {
        if (this.configModel == null) {
            this.configModel = "standalone";
        }
        super.doStartServer(args);
    }

    @Override
    protected void doStartHc(String ... args) throws ProvisioningException {
        if (this.configModel == null) {
            this.configModel = "domain";
            for (String arg : args) {
                if (!arg.startsWith("--host-config")) continue;
                this.configModel = "host";
                break;
            }
        }
        super.doStartHc(args);
    }

    private static Object resolve(Property prop, String provisionedValue) throws ProvisioningException {
        if (provisionedValue == null || provisionedValue.isEmpty() || provisionedValue.length() > 2 && provisionedValue.charAt(0) == '$' && provisionedValue.charAt(1) == '{') {
            return provisionedValue;
        }
        return WfConfigsReader.toJava(WfConfigsReader.toDmr(prop, provisionedValue));
    }

    private static ModelNode toDmr(Property prop, String provisionedValue) throws ProvisioningException {
        try {
            return ModelNode.fromString((String)provisionedValue);
        }
        catch (Exception e) {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            try {
                StateParser.parse((String)provisionedValue, (ParsingStateCallbackHandler)handler, (ParsingState)ArgumentValueInitialState.INSTANCE);
            }
            catch (CommandFormatException e1) {
                throw new ProvisioningException("Failed to parse parameter " + prop.getName() + " '" + provisionedValue + "'", (Throwable)e1);
            }
            return handler.getResult();
        }
    }

    private static Object toJava(ModelNode node) {
        switch (node.getType()) {
            case LIST: {
                List list = node.asList();
                if (list.isEmpty()) {
                    return EMPTY_LIST_OR_OBJ;
                }
                int size = list.size();
                if (size == 1) {
                    return Collections.singletonList(WfConfigsReader.toJava((ModelNode)list.get(0)));
                }
                ArrayList<Object> o = new ArrayList<Object>(size);
                for (ModelNode item : list) {
                    o.add(WfConfigsReader.toJava(item));
                }
                return o;
            }
            case OBJECT: {
                List list = node.asPropertyList();
                if (list.isEmpty()) {
                    return EMPTY_LIST_OR_OBJ;
                }
                int size = list.size();
                if (size == 1) {
                    Property prop = (Property)list.get(0);
                    return Collections.singletonMap(prop.getName(), WfConfigsReader.toJava(prop.getValue()));
                }
                HashMap<String, Object> map = new HashMap<String, Object>(size);
                for (Property prop : list) {
                    map.put(prop.getName(), WfConfigsReader.toJava(prop.getValue()));
                }
                return map;
            }
            case PROPERTY: {
                Property prop = node.asProperty();
                return Collections.singletonMap(prop.getName(), WfConfigsReader.toJava(prop.getValue()));
            }
        }
        return node.asString();
    }

    static {
        HashSet<String> tmp = new HashSet<String>(10);
        tmp.add("java.home");
        tmp.add("jboss.home.dir");
        tmp.add("jboss.controller.temp.dir");
        tmp.add("jboss.server.temp.dir");
        tmp.add("user.home");
        tmp.add("user.dir");
        tmp.add("jboss.server.config.dir");
        tmp.add("jboss.server.base.dir");
        tmp.add("jboss.server.data.dir");
        tmp.add("jboss.server.log.dir");
        READ_ONLY_PATHS = Collections.unmodifiableSet(tmp);
        EMPTY_LIST_OR_OBJ = new Object();
    }

    public static class ConfigSpecMapper
    implements ProvisionedConfigHandler {
        Map<String, Map<ResolvedFeatureId, ProvisionedFeature>> features = new HashMap<String, Map<ResolvedFeatureId, ProvisionedFeature>>();
        Map<String, ResolvedSpecId> specs = new HashMap<String, ResolvedSpecId>();
        Set<String> excludedSpecs = Collections.emptySet();
        private String specName;
        private Map<ResolvedFeatureId, ProvisionedFeature> specFeatures;

        public void reset() {
            this.features.clear();
            this.specs.clear();
            this.excludedSpecs = Collections.emptySet();
            this.specName = null;
            this.specFeatures = null;
        }

        public void map(ProvisionedConfig config) throws ProvisioningException {
            config.handle((ProvisionedConfigHandler)this);
            this.specName = null;
            this.specFeatures = null;
        }

        public void nextSpec(ResolvedFeatureSpec spec) throws ProvisioningException {
            this.specName = spec.getName();
            this.specFeatures = this.features.get(this.specName);
            if (this.specFeatures == null) {
                this.specFeatures = new LinkedHashMap<ResolvedFeatureId, ProvisionedFeature>();
                this.features.put(this.specName, this.specFeatures);
            }
            this.specs.put(this.specName, spec.getId());
        }

        public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
            if (feature.getId() == null) {
                this.excludedSpecs = CollectionUtils.addLinked(this.excludedSpecs, (Object)feature.getSpecId().getName());
                return;
            }
            this.specFeatures.put(feature.getId(), feature);
        }
    }
}

