/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.deployment.MojoDeploymentException;

abstract class AbstractDeployment
extends AbstractServerConnection {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(alias="server-groups", property="wildfly.serverGroups")
    private List<String> serverGroups;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Parameter(alias="runtime-name", property="wildfly.deployment.runtime.name")
    private String runtimeName;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;

    AbstractDeployment() {
    }

    protected abstract File file();

    @Override
    public abstract String goal();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipExecution()) {
            this.getLog().debug((CharSequence)String.format("Skipping deployment of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        try (ModelControllerClient client = this.createClient();
             MavenModelControllerClientConfiguration configuration = this.getClientConfiguration();){
            boolean isDomain = ServerHelper.getContainerDescription((ModelControllerClient)client).isDomain();
            this.validate(isDomain);
            this.getLog().debug((CharSequence)"Executing deployment");
            Deployment deployment = this.configureDeployment(this.createDeployment());
            DeploymentResult result = this.executeDeployment(DeploymentManager.Factory.create((ModelControllerClient)client), deployment);
            if (!result.successful()) {
                throw new MojoExecutionException(String.format("Failed to execute goal %s: %s", this.goal(), result.getFailureMessage()));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to execute goal %s.", this.goal()), (Throwable)e);
        }
    }

    protected boolean skipExecution() {
        return this.skip;
    }

    protected abstract DeploymentResult executeDeployment(DeploymentManager var1, Deployment var2) throws IOException, MojoDeploymentException;

    protected Deployment createDeployment() {
        return Deployment.of((File)this.file());
    }

    protected void validate(boolean isDomain) throws MojoDeploymentException {
        boolean hasServerGroups = this.hasServerGroups();
        if (isDomain) {
            if (!hasServerGroups) {
                throw new MojoDeploymentException("Server is running in domain mode, but no server groups have been defined.");
            }
        } else if (hasServerGroups) {
            throw new MojoDeploymentException("Server is running in standalone mode, but server groups have been defined.");
        }
    }

    private Deployment configureDeployment(Deployment deployment) {
        return deployment.setName(this.name).setRuntimeName(this.runtimeName).addServerGroups(this.getServerGroups());
    }

    private Collection<String> getServerGroups() {
        return this.serverGroups == null ? Collections.emptyList() : this.serverGroups;
    }

    private boolean hasServerGroups() {
        return this.serverGroups != null && !this.serverGroups.isEmpty();
    }
}

