/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.ContainerDescription;
import org.wildfly.plugin.tools.DeploymentManager;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.server.ServerManager;
import org.wildfly.plugin.tools.server.ServerManagerException;

abstract class AbstractServerManager<T extends ModelControllerClient>
implements ServerManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractServerManager.class);
    protected final ProcessHandle process;
    final T client;
    private final boolean shutdownOnClose;
    private final DeploymentManager deploymentManager;
    private final AtomicBoolean closed;
    private final AtomicBoolean shutdown;

    protected AbstractServerManager(ProcessHandle process, T client, boolean shutdownOnClose) {
        this.process = process;
        this.client = client;
        this.shutdownOnClose = shutdownOnClose;
        this.deploymentManager = DeploymentManager.create(client);
        this.closed = new AtomicBoolean(false);
        this.shutdown = new AtomicBoolean(false);
    }

    @Override
    public ModelControllerClient client() {
        this.checkState();
        return this.client;
    }

    @Override
    public ContainerDescription containerDescription() throws IOException {
        return ContainerDescription.lookup(this.client());
    }

    @Override
    public DeploymentManager deploymentManager() {
        return this.deploymentManager;
    }

    @Override
    public String launchType() {
        return ServerManager.launchType(this.client()).orElse("unknown");
    }

    @Override
    public CompletableFuture<ServerManager> kill() {
        if (this.process != null && this.process.isAlive()) {
            return CompletableFuture.supplyAsync(() -> {
                this.internalClose(false, false);
                return this.process.destroyForcibly();
            }).thenCompose(successfulRequest -> {
                if (successfulRequest.booleanValue()) {
                    return this.process.onExit().thenApply(processHandle -> this);
                }
                return CompletableFuture.completedFuture(this);
            });
        }
        return CompletableFuture.completedFuture(this);
    }

    @Override
    public boolean waitFor(long startupTimeout, TimeUnit unit) throws InterruptedException {
        long timeout;
        long sleep = 100L;
        for (timeout = unit.toMillis(startupTimeout); timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (this.isRunning()) break;
            timeout -= System.currentTimeMillis() - before;
            if (this.process != null && !this.process.isAlive()) {
                throw new ServerManagerException("The process %d is no longer active.", this.process.pid());
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            if (this.process != null) {
                this.process.destroy();
            }
            return false;
        }
        return true;
    }

    @Override
    public String takeSnapshot() throws IOException, OperationExecutionException {
        ModelNode op = Operations.createOperation((String)"take-snapshot");
        String snapshot = this.executeOperation(op).asString();
        return snapshot.contains(File.separator) ? snapshot.substring(snapshot.lastIndexOf(File.separator) + 1) : snapshot;
    }

    @Override
    public void executeReload(ModelNode reloadOp) throws IOException, OperationExecutionException {
        block2: {
            try {
                this.executeOperation(reloadOp);
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ExecutionException || cause instanceof CancellationException) break block2;
                throw e;
            }
        }
    }

    @Override
    public void shutdown(long timeout) throws IOException {
        this.checkState();
        if (this.shutdown.compareAndSet(false, true)) {
            this.internalShutdown(this.client(), timeout);
        }
        this.waitForShutdown(this.client());
    }

    @Override
    public CompletableFuture<ServerManager> shutdownAsync(long timeout) {
        this.checkState();
        AbstractServerManager serverManager = this;
        if (this.process != null) {
            return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    if (this.shutdown.compareAndSet(false, true)) {
                        this.internalShutdown((ModelControllerClient)this.client, timeout);
                    }
                }
                catch (IOException e) {
                    throw new CompletionException("Failed to shutdown server.", e);
                }
                return null;
            }).thenCombine(this.process.onExit(), (outcome, processHandle) -> null)).handle((ignore, error) -> {
                if (error != null && this.process.isAlive()) {
                    if (this.process.destroyForcibly()) {
                        LOGGER.warnf(error, "Failed to shutdown the server. An attempt to destroy the process %d has been made, but it may still temporarily run in the background.", (Object)this.process.pid());
                    } else {
                        LOGGER.warnf(error, "Failed to shutdown server and destroy the process %d. The server may still be running in a process.", (Object)this.process.pid());
                    }
                }
                return serverManager;
            });
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (this.shutdown.compareAndSet(false, true)) {
                    this.internalShutdown((ModelControllerClient)this.client, timeout);
                }
            }
            catch (IOException e) {
                throw new CompletionException("Failed to shutdown server.", e);
            }
            return null;
        }).thenApply(outcome -> {
            while (ServerManager.isRunning(this.client)) {
                Thread.onSpinWait();
            }
            return serverManager;
        });
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        this.internalClose(this.shutdownOnClose, true);
    }

    void checkState() {
        if (this.closed.get()) {
            throw new ServerManagerException("The server manager has been closed and cannot process requests");
        }
    }

    void internalClose(boolean shutdownOnClose, boolean waitForShutdown) {
        if (this.closed.compareAndSet(false, true)) {
            if (shutdownOnClose) {
                try {
                    if (this.shutdown.compareAndSet(false, true)) {
                        this.internalShutdown((ModelControllerClient)this.client, 0L);
                    }
                    if (waitForShutdown) {
                        this.waitForShutdown((ModelControllerClient)this.client);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to shutdown the server while closing the server manager.", (Throwable)e);
                }
            }
            try {
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed to close the client.", (Throwable)e);
            }
        }
    }

    abstract void internalShutdown(ModelControllerClient var1, long var2) throws IOException;

    private void waitForShutdown(ModelControllerClient client) {
        if (this.process != null) {
            try {
                this.process.onExit().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new ServerManagerException(e, "Error waiting for process %d to exit.", this.process.pid());
            }
        } else {
            while (ServerManager.isRunning(client)) {
                Thread.onSpinWait();
            }
        }
    }

    static ModelNode executeOperation(ModelControllerClient client, ModelNode op) throws IOException, OperationExecutionException {
        ModelNode result = client.execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            return Operations.readResult((ModelNode)result);
        }
        throw new OperationExecutionException(op, result);
    }
}

