/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import org.wildfly.security.auth.client.MatchRule;

class RuleNode<T> {
    final RuleNode<T> next;
    final MatchRule rule;
    final T configuration;

    RuleNode(RuleNode<T> next, MatchRule rule, T configuration) {
        this.next = next;
        this.rule = rule;
        this.configuration = configuration;
    }

    RuleNode<T> getNext() {
        return this.next;
    }

    MatchRule getRule() {
        return this.rule;
    }

    T getConfiguration() {
        return this.configuration;
    }

    RuleNode<T> without(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException();
        }
        RuleNode<T> next = this.next;
        if (idx == 0) {
            return next;
        }
        if (next == null) {
            throw new IndexOutOfBoundsException();
        }
        return new RuleNode<T>(next.without(idx - 1), this.rule, this.configuration);
    }

    RuleNode<T> with(MatchRule rule, T configuration, int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (idx == 0) {
            return new RuleNode<T>(this, rule, configuration);
        }
        RuleNode<T> next = this.next;
        if (next == null) {
            throw new IndexOutOfBoundsException();
        }
        return new RuleNode<T>(next.with(rule, configuration, idx - 1), this.rule, this.configuration);
    }

    RuleNode<T> with(MatchRule rule, T configuration) {
        return this.withAll(new RuleNode<T>(null, rule, configuration));
    }

    RuleNode<T> withAll(RuleNode<T> other) {
        RuleNode<T> next = this.next;
        if (next == null) {
            return new RuleNode<T>(other, this.rule, this.configuration);
        }
        return new RuleNode<T>(next.withAll(other), this.rule, this.configuration);
    }

    RuleNode<T> withAll(RuleNode<T> authRules, int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (idx == 0) {
            return authRules.withAll(this);
        }
        RuleNode<T> next = this.next;
        if (next == null) {
            throw new IndexOutOfBoundsException();
        }
        return new RuleNode<T>(next.withAll(authRules, idx - 1), this.rule, this.configuration);
    }

    RuleNode<T> replacing(MatchRule rule, T configuration, int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException();
        }
        RuleNode<T> next = this.next;
        if (idx == 0) {
            return new RuleNode<T>(next, rule, configuration);
        }
        if (next == null) {
            throw new IndexOutOfBoundsException();
        }
        return new RuleNode<T>(next.with(rule, configuration, idx - 1), rule, configuration);
    }
}

