/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.keystore.DelegatingKeyStoreSpi;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

final class WrappingPasswordKeyStoreSpiImpl
extends DelegatingKeyStoreSpi {
    private final KeyStore delegate;

    WrappingPasswordKeyStoreSpiImpl(KeyStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            Key key = this.delegate.getKey(alias, password);
            return key instanceof SecretKey && "password".equals(key.getAlgorithm()) ? WrappingPasswordKeyStoreSpiImpl.decoded((SecretKey)key) : key;
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            return this.delegate.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        try {
            return this.delegate.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (key instanceof Password) {
            this.engineSetEntry(alias, new PasswordEntry((Password)key), password == null ? null : new KeyStore.PasswordProtection(password));
        } else {
            this.delegate.setKeyEntry(alias, key, password, chain);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.delegate.setKeyEntry(alias, key, chain);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.delegate.setCertificateEntry(alias, cert);
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        SecretKey secretKey;
        KeyStore.Entry entry = this.delegate.getEntry(alias, protParam);
        if (entry instanceof KeyStore.SecretKeyEntry && "password".equals((secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey()).getAlgorithm())) {
            return new PasswordEntry(WrappingPasswordKeyStoreSpiImpl.decoded(secretKey));
        }
        return entry;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (entry instanceof PasswordEntry) {
            try {
                this.delegate.setEntry(alias, new KeyStore.SecretKeyEntry(WrappingPasswordKeyStoreSpiImpl.encoded(((PasswordEntry)entry).getPassword())), protParam);
            }
            catch (InvalidKeyException e) {
                throw new KeyStoreException(e);
            }
        } else {
            this.delegate.setEntry(alias, entry, protParam);
        }
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        try {
            return entryClass == PasswordEntry.class && this.delegate.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class) || this.delegate.entryInstanceOf(alias, entryClass);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        try {
            return this.delegate.isCertificateEntry(alias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        try {
            return this.delegate.getCertificateAlias(cert);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    private static Password decoded(SecretKey key) {
        return ClearPassword.createRaw("clear", new String(key.getEncoded(), StandardCharsets.UTF_8).toCharArray());
    }

    private static SecretKey encoded(Password password) throws InvalidKeyException {
        if (password instanceof ClearPassword) {
            return new SecretKeySpec(new String(((ClearPassword)password).getPassword()).getBytes(StandardCharsets.UTF_8), "password");
        }
        throw ElytronMessages.log.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();
    }

    @Override
    protected KeyStore getKeyStore() {
        return this.delegate;
    }
}

