/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security;

import java.security.Provider;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.credential.store.impl.CmdPasswordStore;
import org.wildfly.security.credential.store.impl.ExecPasswordStore;
import org.wildfly.security.credential.store.impl.KeystorePasswordStore;
import org.wildfly.security.credential.store.impl.MaskedPasswordStore;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.impl.ServerMechanismFactoryImpl;
import org.wildfly.security.keystore.PasswordKeyStoreSpi;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.impl.PasswordFactorySpiImpl;

public class WildFlyElytronProvider
extends Provider {
    private static final long serialVersionUID = 1267015094996624988L;
    private static final String HTTP_SERVER_FACTORY_TYPE = HttpServerAuthenticationMechanismFactory.class.getSimpleName();
    private static final String SASL_CLIENT_FACTORY_TYPE = SaslClientFactory.class.getSimpleName();
    private static final String SASL_SERVER_FACTORY_TYPE = SaslServerFactory.class.getSimpleName();
    private static final String PASSWORD_FACTORY_TYPE = PasswordFactory.class.getSimpleName();

    public WildFlyElytronProvider() {
        super("WildFlyElytron", 1.0, "WildFly Elytron Provider");
        this.putHttpAuthenticationMechanismImplementations();
        this.putKeyStoreImplementations();
        this.putPasswordImplementations();
        this.putSaslMechanismImplementations();
        this.putCredentialStoreProviderImplementations();
    }

    private void putKeyStoreImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        this.putService(new Provider.Service(this, "KeyStore", "PasswordFile", PasswordKeyStoreSpi.class.getName(), emptyList, emptyMap));
    }

    private void putHttpAuthenticationMechanismImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        this.putService(new Provider.Service(this, HTTP_SERVER_FACTORY_TYPE, "BASIC", ServerMechanismFactoryImpl.class.getName(), emptyList, emptyMap));
    }

    private void putPasswordImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "clear", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "crypt-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "sun-crypt-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "sun-crypt-md5-bare-salt", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "crypt-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "crypt-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-md2", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-sha-1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-sha-384", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "simple-digest-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "digest-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "digest-sha", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "digest-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "digest-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-sha-1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-sha-384", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "password-salt-digest-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-sha-1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-sha-384", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "salt-password-digest-sha-512", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "crypt-des", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "bsd-crypt-des", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "bcrypt", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "scram-sha-1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "scram-sha-256", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "otp-md5", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, PASSWORD_FACTORY_TYPE, "otp-sha1", PasswordFactorySpiImpl.class.getName(), emptyList, emptyMap));
    }

    private void putSaslMechanismImplementations() {
        List<String> noAliases = Collections.emptyList();
        Map<String, String> noProperties = Collections.emptyMap();
        ClassLoader myClassLoader = WildFlyElytronProvider.class.getClassLoader();
        String myClassName = WildFlyElytronProvider.class.getName();
        String myPackageWithDot = myClassName.substring(0, myClassName.lastIndexOf(46) + 1);
        ServiceLoader<SaslClientFactory> clientLoader = ServiceLoader.load(SaslClientFactory.class, myClassLoader);
        Iterator<SaslClientFactory> clientIterator = clientLoader.iterator();
        Map<String, String> props = Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true");
        while (true) {
            try {
                while (clientIterator.hasNext()) {
                    String[] names;
                    String className;
                    SaslClientFactory factory = clientIterator.next();
                    if (factory.getClass().getClassLoader() != myClassLoader || !(className = factory.getClass().getName()).startsWith(myPackageWithDot)) continue;
                    for (String name : names = factory.getMechanismNames(props)) {
                        this.putService(new Provider.Service(this, SASL_CLIENT_FACTORY_TYPE, name, className, noAliases, noProperties));
                    }
                }
            }
            catch (RuntimeException | ServiceConfigurationError factory) {
                continue;
            }
            break;
        }
        ServiceLoader<SaslServerFactory> serverLoader = ServiceLoader.load(SaslServerFactory.class, myClassLoader);
        Iterator<SaslServerFactory> serverIterator = serverLoader.iterator();
        while (true) {
            try {
                while (serverIterator.hasNext()) {
                    String[] names;
                    String className;
                    SaslServerFactory factory = serverIterator.next();
                    if (factory.getClass().getClassLoader() != myClassLoader || !(className = factory.getClass().getName()).startsWith(myPackageWithDot)) continue;
                    for (String name : names = factory.getMechanismNames(props)) {
                        this.putService(new Provider.Service(this, SASL_SERVER_FACTORY_TYPE, name, className, noAliases, noProperties));
                    }
                }
            }
            catch (RuntimeException | ServiceConfigurationError throwable) {
                continue;
            }
            break;
        }
    }

    private void putCredentialStoreProviderImplementations() {
        List<String> emptyList = Collections.emptyList();
        Map<String, String> emptyMap = Collections.emptyMap();
        this.putService(new Provider.Service(this, "CredentialStore", "KeyStorePasswordStore", KeystorePasswordStore.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, "CredentialStore", "ExecPasswordStore", ExecPasswordStore.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, "CredentialStore", "CmdPasswordStore", CmdPasswordStore.class.getName(), emptyList, emptyMap));
        this.putService(new Provider.Service(this, "CredentialStore", "MaskedPasswordStore", MaskedPasswordStore.class.getName(), emptyList, emptyMap));
    }
}

