/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.ietf.jgss.GSSCredential;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.credential.GSSCredentialCredential;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

class SetGSSCredentialAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final GSSCredential credential;

    SetGSSCredentialAuthenticationConfiguration(AuthenticationConfiguration parent, GSSCredential credential) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetKeyStoreCredentialAuthenticationConfiguration.class).without(SetAnonymousAuthenticationConfiguration.class).without(SetPasswordAuthenticationConfiguration.class).without(SetKeyManagerCredentialAuthenticationConfiguration.class).without(SetCertificateCredentialAuthenticationConfiguration.class));
        this.credential = credential;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        CredentialCallback credentialCallback;
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback && (credentialCallback = (CredentialCallback)callback).isCredentialTypeSupported(GSSCredentialCredential.class, null)) {
            credentialCallback.setCredential(new GSSCredentialCredential(this.credential));
            return;
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    void configureSaslProperties(Map<String, Object> properties) {
        properties.put("javax.security.sasl.credentials", this.credential);
        super.configureSaslProperties(properties);
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        return SaslMechanismInformation.GS2.test(mechanismName) || mechanismName.equals("GSSAPI") || super.filterOneSaslMechanism(mechanismName);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetGSSCredentialAuthenticationConfiguration(newParent, this.credential);
    }
}

