/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.KeyStoreEntrySecurityFactory;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetGSSCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.util.SaslMechanismInformation;
import org.wildfly.security.x500.X500;

class SetKeyStoreCredentialAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<KeyStore.Entry> entryFactory;

    SetKeyStoreCredentialAuthenticationConfiguration(AuthenticationConfiguration parent, KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        this(parent, new OneTimeSecurityFactory<KeyStore.Entry>(new KeyStoreEntrySecurityFactory(keyStore, alias, protectionParameter)));
    }

    SetKeyStoreCredentialAuthenticationConfiguration(AuthenticationConfiguration parent, SecurityFactory<KeyStore.Entry> entryFactory) {
        super(parent.without(SetPasswordAuthenticationConfiguration.class).without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetGSSCredentialAuthenticationConfiguration.class).without(SetKeyManagerCredentialAuthenticationConfiguration.class).without(SetCertificateCredentialAuthenticationConfiguration.class));
        this.entryFactory = entryFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetKeyStoreCredentialAuthenticationConfiguration(newParent, this.entryFactory);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback) {
            KeyStore.Entry entry;
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            try {
                entry = this.entryFactory.create();
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.log.unableToReadCredential(e);
            }
            if (entry instanceof PasswordEntry) {
                credentialCallback.setCredential(new PasswordCredential(((PasswordEntry)entry).getPassword()));
                return;
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                Object[] certificateChain = privateKeyEntry.getCertificateChain();
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                if (certificateChain != null && certificateChain.length != 0 && credentialCallback.isCredentialTypeSupported(X509CertificateChainPrivateCredential.class, privateKey.getAlgorithm())) {
                    try {
                        X509Certificate[] x509Certificates = X500.asX509CertificateArray(certificateChain);
                        credentialCallback.setCredential(new X509CertificateChainPrivateCredential(privateKey, x509Certificates));
                        return;
                    }
                    catch (ArrayStoreException x509Certificates) {}
                }
            } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
                Certificate certificate = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
                if (certificate instanceof X509Certificate) {
                    credentialCallback.setCredential(new X509CertificateChainPublicCredential((X509Certificate)certificate));
                    return;
                }
            } else if (entry instanceof KeyStore.SecretKeyEntry) {
                credentialCallback.setCredential(new SecretKeyCredential(((KeyStore.SecretKeyEntry)entry).getSecretKey()));
                return;
            }
        } else if (callback instanceof PasswordCallback) {
            KeyStore.Entry entry;
            try {
                entry = this.entryFactory.create();
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.log.unableToReadCredential(e);
            }
            if (entry instanceof PasswordEntry) {
                ClearPasswordSpec keySpec;
                Password realPassword;
                PasswordFactory passwordFactory;
                Password password = ((PasswordEntry)entry).getPassword();
                try {
                    passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                }
                catch (NoSuchAlgorithmException e) {
                    throw ElytronMessages.log.unableToReadCredential(e);
                }
                try {
                    realPassword = passwordFactory.translate(password);
                }
                catch (InvalidKeyException e) {
                    throw ElytronMessages.log.unableToReadCredential(e);
                }
                try {
                    keySpec = passwordFactory.getKeySpec(realPassword, ClearPasswordSpec.class);
                }
                catch (InvalidKeySpecException e) {
                    throw ElytronMessages.log.unableToReadCredential(e);
                }
                ((PasswordCallback)callback).setPassword(keySpec.getEncodedPassword());
                return;
            }
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        KeyStore.Entry entry;
        try {
            entry = this.entryFactory.create();
        }
        catch (GeneralSecurityException e) {
            return super.filterOneSaslMechanism(mechanismName);
        }
        Set<Class<? extends Credential>> types = SaslMechanismInformation.getSupportedClientCredentialTypes(mechanismName);
        if (types == null) {
            return super.filterOneSaslMechanism(mechanismName);
        }
        if (entry instanceof PasswordEntry) {
            Set<String> algorithms = SaslMechanismInformation.getSupportedClientCredentialAlgorithms(mechanismName, PasswordCredential.class);
            return types.contains(PasswordCredential.class) && (algorithms.isEmpty() || algorithms.contains(((PasswordEntry)entry).getPassword().getAlgorithm())) || super.filterOneSaslMechanism(mechanismName);
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            Set<String> algorithms = SaslMechanismInformation.getSupportedClientCredentialAlgorithms(mechanismName, X509CertificateChainPrivateCredential.class);
            return types.contains(X509CertificateChainPrivateCredential.class) && (algorithms.isEmpty() || algorithms.contains(((KeyStore.PrivateKeyEntry)entry).getPrivateKey().getAlgorithm())) || super.filterOneSaslMechanism(mechanismName);
        }
        return super.filterOneSaslMechanism(mechanismName);
    }
}

