/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.NoSuchAttributeException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.realm.ldap.CredentialPersister;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.UserPasswordPasswordUtil;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

class UserPasswordCredentialLoader
implements CredentialPersister {
    static final String DEFAULT_USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    private final String userPasswordAttributeName;

    UserPasswordCredentialLoader(String userPasswordAttributeName) {
        Assert.checkNotNullParam((String)"userPasswordAttributeName", (Object)userPasswordAttributeName);
        this.userPasswordAttributeName = userPasswordAttributeName;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(DirContextFactory contextFactory, Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return credentialType == PasswordCredential.class ? (algorithmName == null ? SupportLevel.SUPPORTED : SupportLevel.POSSIBLY_SUPPORTED) : SupportLevel.UNSUPPORTED;
    }

    @Override
    public IdentityCredentialPersister forIdentity(DirContextFactory contextFactory, String distinguishedName) {
        return new ForIdentityLoader(contextFactory, distinguishedName);
    }

    EvidenceVerifier toEvidenceVerifier() {
        return new EvidenceVerifier(){

            @Override
            public SupportLevel getEvidenceVerifySupport(DirContextFactory contextFactory, Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return UserPasswordCredentialLoader.this.getCredentialAcquireSupport(contextFactory, PasswordCredential.class, null);
            }

            @Override
            public IdentityEvidenceVerifier forIdentity(DirContextFactory contextFactory, String distinguishedName) throws RealmUnavailableException {
                return new ForIdentityLoader(contextFactory, distinguishedName);
            }
        };
    }

    private class ForIdentityLoader
    implements IdentityCredentialPersister,
    IdentityEvidenceVerifier {
        private final DirContextFactory contextFactory;
        private final String distinguishedName;

        public ForIdentityLoader(DirContextFactory contextFactory, String distinguishedName) {
            this.contextFactory = contextFactory;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) {
            Credential credential = this.getCredential(credentialType, algorithmName);
            if (credential != null) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.getCredentialAcquireSupport(PasswordCredential.class, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
            DirContext context;
            if (credentialType != PasswordCredential.class) {
                return null;
            }
            try {
                context = this.contextFactory.obtainDirContext(null);
            }
            catch (NamingException e) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("Getting user-password credential " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
                return null;
            }
            try {
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{UserPasswordCredentialLoader.this.userPasswordAttributeName});
                Attribute attribute = attributes.get(UserPasswordCredentialLoader.this.userPasswordAttributeName);
                int size = attribute.size();
                for (int i = 0; i < size; ++i) {
                    byte[] value = (byte[])attribute.get(i);
                    Password password = UserPasswordPasswordUtil.parseUserPassword(value);
                    if (!credentialType.isAssignableFrom(PasswordCredential.class) || algorithmName != null && !algorithmName.equals(password.getAlgorithm())) continue;
                    Credential credential = (Credential)credentialType.cast(new PasswordCredential(password));
                    return (C)credential;
                }
            }
            catch (InvalidKeySpecException | NamingException e) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("Getting user-password credential " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
            }
            finally {
                this.contextFactory.returnContext(context);
            }
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            PasswordCredential credential;
            if (evidence instanceof PasswordGuessEvidence && (credential = this.getCredential(PasswordCredential.class, null)) != null) {
                try {
                    char[] guess = ((PasswordGuessEvidence)evidence).getGuess();
                    Password password = credential.getPassword();
                    PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                    Password translated = passwordFactory.translate(password);
                    return passwordFactory.verify(translated, guess);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public boolean getCredentialPersistSupport(Class<? extends Credential> credentialType, String algorithmName) {
            return credentialType == PasswordCredential.class;
        }

        @Override
        public void persistCredential(Credential credential) throws RealmUnavailableException {
            DirContext context;
            try {
                context = this.contextFactory.obtainDirContext(null);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialPersistingFailed(credential.toString(), this.distinguishedName, e);
            }
            try {
                byte[] composedPassword = UserPasswordPasswordUtil.composeUserPassword((Password)((Object)credential));
                Assert.assertNotNull((Object)composedPassword);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(UserPasswordCredentialLoader.this.userPasswordAttributeName, composedPassword);
                context.modifyAttributes(this.distinguishedName, 1, (Attributes)attributes);
            }
            catch (IOException | NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialPersistingFailed(credential.toString(), this.distinguishedName, e);
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }

        @Override
        public void clearCredentials() throws RealmUnavailableException {
            DirContext context;
            try {
                context = this.contextFactory.obtainDirContext(null);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialClearingFailed(this.distinguishedName, e);
            }
            try {
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(new BasicAttribute(UserPasswordCredentialLoader.this.userPasswordAttributeName));
                context.modifyAttributes(this.distinguishedName, 3, (Attributes)attributes);
            }
            catch (NoSuchAttributeException attributes) {
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialClearingFailed(this.distinguishedName, e);
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }
    }
}

