/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.callback.PeerPrincipalCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.auth.callback.SocketAddressCallback;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.auth.server.event.RealmFailedAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmIdentityFailedAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmIdentitySuccessfulAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmSuccessfulAuthenticationEvent;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.SecurityIdentityEvidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public final class ServerAuthenticationContext {
    private final SecurityDomain domain;
    private final AtomicReference<State> stateRef = new AtomicReference<SimpleState>(INITIAL);
    private final MechanismConfiguration mechanismConfiguration;
    private static final int INITIAL_ID = 0;
    private static final int FAILED_ID = 1;
    private static final int REALM_ID = 2;
    private static final int ASSIGNED_ID = 3;
    private static final int AUTHORIZED_ID = 4;
    private static final int COMPLETE_ID = 5;
    private static final SimpleState INITIAL = new SimpleState(0, false, false);
    private static final SimpleState FAILED = new SimpleState(1, true, true);

    ServerAuthenticationContext(SecurityDomain domain, MechanismConfiguration mechanismConfiguration) {
        this.domain = domain;
        this.mechanismConfiguration = mechanismConfiguration;
    }

    public SecurityIdentity getAuthorizedIdentity() throws IllegalStateException {
        return this.stateRef.get().getAuthorizedIdentity();
    }

    public void anonymous() throws IllegalStateException {
        State oldState = this.stateRef.get();
        if (oldState.getId() > 2) {
            throw ElytronMessages.log.alreadyComplete();
        }
        CompleteState completeState = new CompleteState(this.domain.getAnonymousSecurityIdentity());
        while (!this.stateRef.compareAndSet(oldState, completeState)) {
            oldState = this.stateRef.get();
            if (oldState.getId() <= 2) continue;
            throw ElytronMessages.log.alreadyComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticationName(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Collection<String> mechanismRealmNames;
        Iterator<String> iterator;
        Assert.checkNotNullParam((String)"name", (Object)name);
        AtomicReference<State> stateRef = this.stateRef;
        State oldState = stateRef.get();
        if (oldState.isDone()) {
            throw ElytronMessages.log.alreadyComplete();
        }
        SecurityDomain domain = this.domain;
        MechanismConfiguration mechanismConfiguration = this.mechanismConfiguration;
        MechanismRealmConfiguration mechanismRealmConfiguration = oldState.getId() != 0 ? oldState.getMechanismRealmConfiguration() : ((iterator = (mechanismRealmNames = mechanismConfiguration.getMechanismRealmNames()).iterator()).hasNext() ? mechanismConfiguration.getMechanismRealmConfiguration(iterator.next()) : MechanismRealmConfiguration.NO_REALM);
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getPreRealmRewriter(), mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
        NamePrincipal principal = new NamePrincipal(name);
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getPostRealmRewriter(), mechanismConfiguration.getPostRealmRewriter(), domain.getPostRealmRewriter());
        String realmName = ServerAuthenticationContext.mapAll(name, mechanismRealmConfiguration.getRealmMapper(), mechanismConfiguration.getRealmMapper(), domain.getRealmMapper(), domain.getDefaultRealmName());
        RealmInfo realmInfo = domain.getRealmInfo(realmName);
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getFinalRewriter(), mechanismConfiguration.getFinalRewriter(), realmInfo.getNameRewriter());
        if (oldState.getId() == 3) {
            if (!oldState.getAuthenticationPrincipal().getName().equals(name) || oldState.getMechanismRealmConfiguration() != mechanismRealmConfiguration) {
                throw ElytronMessages.log.nameAlreadySet();
            }
            return;
        }
        SecurityRealm securityRealm = realmInfo.getSecurityRealm();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity(name, null, null);
        boolean ok = false;
        try {
            NameAssignedState newState = new NameAssignedState(principal, realmInfo, realmIdentity, mechanismRealmConfiguration);
            while (!stateRef.compareAndSet(oldState, newState)) {
                oldState = stateRef.get();
                if (oldState.isDone()) {
                    throw ElytronMessages.log.alreadyComplete();
                }
                if (oldState.getId() != 3) continue;
                if (!oldState.getAuthenticationPrincipal().equals(principal)) {
                    throw ElytronMessages.log.nameAlreadySet();
                }
                return;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                realmIdentity.dispose();
            }
        }
    }

    public void setAuthenticationPrincipal(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        String name = this.domain.getPrincipalDecoder().getName(principal);
        if (name == null) {
            throw ElytronMessages.log.unrecognizedPrincipalType(principal);
        }
        this.setAuthenticationName(name);
    }

    public boolean isSameName(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Collection<String> mechanismRealmNames;
        Iterator<String> iterator;
        Assert.checkNotNullParam((String)"name", (Object)name);
        SecurityDomain domain = this.domain;
        MechanismConfiguration mechanismConfiguration = this.mechanismConfiguration;
        State state = this.stateRef.get();
        MechanismRealmConfiguration mechanismRealmConfiguration = state.getId() != 0 ? state.getMechanismRealmConfiguration() : ((iterator = (mechanismRealmNames = mechanismConfiguration.getMechanismRealmNames()).iterator()).hasNext() ? mechanismConfiguration.getMechanismRealmConfiguration(iterator.next()) : MechanismRealmConfiguration.NO_REALM);
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getPreRealmRewriter(), mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
        String realmName = ServerAuthenticationContext.mapAll(name, mechanismRealmConfiguration.getRealmMapper(), mechanismConfiguration.getRealmMapper(), domain.getRealmMapper(), domain.getDefaultRealmName());
        RealmInfo realmInfo = domain.getRealmInfo(realmName);
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getPostRealmRewriter(), mechanismConfiguration.getPostRealmRewriter(), domain.getPostRealmRewriter());
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getFinalRewriter(), mechanismConfiguration.getFinalRewriter(), realmInfo.getNameRewriter());
        return state.getAuthenticationPrincipal().equals(new NamePrincipal(name));
    }

    public boolean exists() throws RealmUnavailableException, IllegalStateException {
        return this.stateRef.get().getRealmIdentity().exists();
    }

    public boolean isSamePrincipal(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        String name = this.domain.getPrincipalDecoder().getName(principal);
        return name != null && this.isSameName(name);
    }

    public void fail() throws IllegalStateException {
        State oldState;
        do {
            if ((oldState = this.stateRef.get()).isDone()) {
                throw ElytronMessages.log.alreadyComplete();
            }
            if (oldState.isStarted()) continue;
            throw ElytronMessages.log.noAuthenticationInProgress();
        } while (!this.stateRef.compareAndSet(oldState, FAILED));
        RealmIdentity realmIdentity = oldState.getRealmIdentity();
        SecurityRealm securityRealm = oldState.getRealmInfo().getSecurityRealm();
        SecurityRealm.safeHandleRealmEvent(securityRealm, new RealmFailedAuthenticationEvent(realmIdentity, null, null));
        if (oldState.getId() == 3) {
            realmIdentity.dispose();
        }
    }

    public boolean authorize() throws RealmUnavailableException, IllegalStateException {
        AuthorizationIdentity authorizationIdentity;
        State oldState = this.stateRef.get();
        if (oldState.isDone()) {
            throw ElytronMessages.log.alreadyComplete();
        }
        if (oldState.getId() == 4) {
            return true;
        }
        if (oldState.getId() < 3) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }
        RealmIdentity realmIdentity = oldState.getRealmIdentity();
        if (!realmIdentity.exists()) {
            return false;
        }
        RealmInfo realmInfo = oldState.getRealmInfo();
        Principal authenticationPrincipal = oldState.getAuthenticationPrincipal();
        SecurityIdentity securityIdentity = this.domain.transform(new SecurityIdentity(this.domain, authenticationPrincipal, realmInfo, authorizationIdentity = realmIdentity.getAuthorizationIdentity(), this.domain.getCategoryRoleMappers()));
        if (securityIdentity.implies(new LoginPermission())) {
            AuthorizedState authorizedState = new AuthorizedState(securityIdentity, authenticationPrincipal, realmInfo, realmIdentity, oldState.getMechanismRealmConfiguration());
            while (!this.stateRef.compareAndSet(oldState, authorizedState)) {
                oldState = this.stateRef.get();
                if (oldState.isDone()) {
                    throw ElytronMessages.log.alreadyComplete();
                }
                if (oldState.getId() == 4) {
                    return true;
                }
                if (oldState.getId() < 3) {
                    throw ElytronMessages.log.noAuthenticationInProgress();
                }
                assert (oldState.getId() == 3);
                assert (oldState.getRealmIdentity() == realmIdentity);
            }
            SecurityRealm.safeHandleRealmEvent(realmInfo.getSecurityRealm(), new RealmIdentitySuccessfulAuthorizationEvent(securityIdentity.getAuthorizationIdentity(), securityIdentity.getPrincipal(), authenticationPrincipal));
            oldState.getRealmIdentity().dispose();
            return true;
        }
        SecurityRealm.safeHandleRealmEvent(realmInfo.getSecurityRealm(), new RealmIdentityFailedAuthorizationEvent(securityIdentity.getAuthorizationIdentity(), securityIdentity.getPrincipal(), authenticationPrincipal));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        if (!this.authorize()) {
            return false;
        }
        while (true) {
            State oldState;
            if ((oldState = this.stateRef.get()).isDone()) {
                throw ElytronMessages.log.alreadyComplete();
            }
            if (!oldState.isStarted()) {
                throw ElytronMessages.log.noAuthenticationInProgress();
            }
            assert (oldState.getId() == 4);
            SecurityDomain domain = this.domain;
            MechanismConfiguration mechanismConfiguration = this.mechanismConfiguration;
            MechanismRealmConfiguration mechanismRealmConfiguration = oldState.getMechanismRealmConfiguration();
            name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getPreRealmRewriter(), mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
            NamePrincipal principal = new NamePrincipal(name);
            if (oldState.getAuthenticationPrincipal().equals(principal)) {
                this.succeed();
                return true;
            }
            if (!oldState.getAuthorizedIdentity().implies(new RunAsPrincipalPermission(principal.getName()))) {
                return false;
            }
            name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getPostRealmRewriter(), mechanismConfiguration.getPostRealmRewriter(), domain.getPostRealmRewriter());
            String realmName = ServerAuthenticationContext.mapAll(name, mechanismRealmConfiguration.getRealmMapper(), mechanismConfiguration.getRealmMapper(), domain.getRealmMapper(), domain.getDefaultRealmName());
            RealmInfo realmInfo = domain.getRealmInfo(realmName);
            name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getFinalRewriter(), mechanismConfiguration.getFinalRewriter(), realmInfo.getNameRewriter());
            SecurityRealm securityRealm = realmInfo.getSecurityRealm();
            RealmIdentity realmIdentity = securityRealm.getRealmIdentity(name, null, null);
            boolean ok = false;
            try {
                if (!realmIdentity.exists()) {
                    boolean bl = false;
                    return bl;
                }
                AuthorizationIdentity authorizationIdentity = realmIdentity.getAuthorizationIdentity();
                SecurityIdentity newIdentity = domain.transform(new SecurityIdentity(domain, principal, realmInfo, authorizationIdentity, domain.getCategoryRoleMappers()));
                if (!newIdentity.implies(new LoginPermission())) {
                    boolean bl = false;
                    return bl;
                }
                AuthorizedState newState = new AuthorizedState(newIdentity, principal, realmInfo, realmIdentity, mechanismRealmConfiguration);
                if (!this.stateRef.compareAndSet(oldState, newState)) continue;
                ok = true;
                oldState.getRealmIdentity().dispose();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ok) continue;
                realmIdentity.dispose();
                continue;
            }
            break;
        }
    }

    public void succeed() throws IllegalStateException, RealmUnavailableException {
        State oldState = this.stateRef.get();
        if (oldState.isDone()) {
            throw ElytronMessages.log.alreadyComplete();
        }
        if (!oldState.isStarted()) {
            this.anonymous();
            return;
        }
        RealmInfo realmInfo = oldState.getRealmInfo();
        RealmIdentity realmIdentity = oldState.getRealmIdentity();
        AuthorizationIdentity authorizationIdentity = realmIdentity.getAuthorizationIdentity();
        CompleteState newState = new CompleteState(this.domain.transform(new SecurityIdentity(this.domain, oldState.getAuthenticationPrincipal(), realmInfo, authorizationIdentity, this.domain.getCategoryRoleMappers())));
        while (!this.stateRef.compareAndSet(oldState, newState)) {
            oldState = this.stateRef.get();
            if (oldState.isDone()) {
                throw ElytronMessages.log.alreadyComplete();
            }
            if (oldState.isStarted()) continue;
            throw ElytronMessages.log.noAuthenticationInProgress();
        }
        SecurityRealm.safeHandleRealmEvent(realmInfo.getSecurityRealm(), new RealmSuccessfulAuthenticationEvent(realmIdentity, authorizationIdentity, null, null));
        realmIdentity.dispose();
    }

    public boolean isDone() {
        return this.stateRef.get().isDone();
    }

    public Principal getAuthenticationPrincipal() throws RealmUnavailableException {
        return this.stateRef.get().getAuthenticationPrincipal();
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        SupportLevel supportLevel = this.stateRef.get().getCredentialAcquireSupport(credentialType, algorithmName);
        return supportLevel != null ? supportLevel : this.domain.getCredentialAcquireSupport(credentialType, algorithmName);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType) throws RealmUnavailableException {
        return this.getCredentialAcquireSupport(credentialType, null);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        SupportLevel supportLevel = this.stateRef.get().getEvidenceVerifySupport(evidenceType, algorithmName);
        return supportLevel != null ? supportLevel : this.domain.getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType) throws RealmUnavailableException {
        return this.getEvidenceVerifySupport(evidenceType, null);
    }

    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
        return this.stateRef.get().getCredential(credentialType, algorithmName);
    }

    public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
        return this.stateRef.get().getCredential(credentialType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
        NameAssignedState newState;
        MechanismRealmConfiguration mechanismRealmConfiguration;
        AtomicReference<State> stateRef = this.stateRef;
        State oldState = stateRef.get();
        if (oldState.isDone()) {
            throw ElytronMessages.log.alreadyComplete();
        }
        MechanismConfiguration mechanismConfiguration = this.mechanismConfiguration;
        if (oldState.getId() == 2) {
            mechanismRealmConfiguration = oldState.getMechanismRealmConfiguration();
        } else if (oldState.getId() == 0) {
            Collection<String> mechanismRealmNames = mechanismConfiguration.getMechanismRealmNames();
            Iterator<String> iterator = mechanismRealmNames.iterator();
            mechanismRealmConfiguration = iterator.hasNext() ? mechanismConfiguration.getMechanismRealmConfiguration(iterator.next()) : MechanismRealmConfiguration.NO_REALM;
        } else {
            return this.checkEvidenceTrusted(evidence) ? true : stateRef.get().verifyEvidence(evidence);
        }
        Principal evidencePrincipal = evidence.getPrincipal();
        if (evidencePrincipal != null) {
            this.setAuthenticationPrincipal(evidencePrincipal);
            return this.verifyEvidence(evidence);
        }
        SecurityDomain domain = this.domain;
        RealmInfo realmInfo = null;
        RealmIdentity realmIdentity = null;
        Collection<RealmInfo> realmInfos = domain.getRealmInfos();
        for (RealmInfo info : realmInfos) {
            realmIdentity = info.getSecurityRealm().getRealmIdentity(null, null, evidence);
            if (realmIdentity.exists()) {
                realmInfo = info;
                break;
            }
            realmIdentity.dispose();
        }
        if (realmInfo == null) {
            return false;
        }
        assert (realmIdentity != null && realmIdentity.exists());
        Principal resolvedPrincipal = realmIdentity.getRealmIdentityPrincipal();
        if (resolvedPrincipal == null) {
            realmIdentity.dispose();
            return false;
        }
        boolean ok = false;
        try {
            newState = new NameAssignedState(resolvedPrincipal, realmInfo, realmIdentity, mechanismRealmConfiguration);
            if (!stateRef.compareAndSet(oldState, newState)) {
                boolean bl = this.verifyEvidence(evidence);
                return bl;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                realmIdentity.dispose();
            }
        }
        return newState.verifyEvidence(evidence);
    }

    private boolean checkEvidenceTrusted(Evidence evidence) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidence", (Object)evidence);
        if (!this.exists()) {
            return false;
        }
        if (evidence instanceof SecurityIdentityEvidence) {
            RealmIdentity realmIdentity = this.stateRef.get().getRealmIdentity();
            SecurityIdentity evidenceIdentity = ((SecurityIdentityEvidence)evidence).getSecurityIdentity();
            RealmInfo evidenceRealmInfo = evidenceIdentity.getRealmInfo();
            SecurityRealm evidenceSecurityRealm = evidenceRealmInfo.getSecurityRealm();
            return realmIdentity.createdBySecurityRealm(evidenceSecurityRealm);
        }
        return false;
    }

    public void setMechanismRealmName(String realmName) throws IllegalStateException, IllegalArgumentException {
        State oldState;
        MechanismConfiguration mechanismConfiguration = this.mechanismConfiguration;
        if (mechanismConfiguration.getMechanismRealmNames().isEmpty()) {
            return;
        }
        MechanismRealmConfiguration configuration = mechanismConfiguration.getMechanismRealmConfiguration(realmName);
        if (configuration == null) {
            throw ElytronMessages.log.invalidMechRealmSelection(realmName);
        }
        AtomicReference<State> stateRef = this.stateRef;
        RealmAssignedState newState = new RealmAssignedState(configuration);
        do {
            oldState = stateRef.get();
            switch (oldState.getId()) {
                case 0: {
                    break;
                }
                case 2: {
                    if (configuration == oldState.getMechanismRealmConfiguration()) {
                        return;
                    }
                }
                case 3: 
                case 4: {
                    throw ElytronMessages.log.mechRealmAlreadySelected();
                }
                case 1: 
                case 5: {
                    throw ElytronMessages.log.alreadyComplete();
                }
                default: {
                    throw Assert.impossibleSwitchCase((int)oldState.getId());
                }
            }
        } while (!stateRef.compareAndSet(oldState, newState));
    }

    CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                this.handleOne(callbacks, 0);
            }

            private void handleOne(Callback[] callbacks, int idx) throws IOException, UnsupportedCallbackException {
                if (idx == callbacks.length) {
                    return;
                }
                Callback callback = callbacks[idx];
                if (callback instanceof AnonymousAuthorizationCallback) {
                    ServerAuthenticationContext.this.anonymous();
                    ((AnonymousAuthorizationCallback)callback).setAuthorized(true);
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof AuthorizeCallback) {
                    AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                    ServerAuthenticationContext.this.setAuthenticationName(authorizeCallback.getAuthenticationID());
                    authorizeCallback.setAuthorized(ServerAuthenticationContext.this.authorize(authorizeCallback.getAuthorizationID()));
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof NameCallback) {
                    String name = ((NameCallback)callback).getDefaultName();
                    try {
                        ServerAuthenticationContext.this.setAuthenticationName(name);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof PeerPrincipalCallback) {
                    Principal principal = ((PeerPrincipalCallback)callback).getPrincipal();
                    try {
                        ServerAuthenticationContext.this.setAuthenticationPrincipal(principal);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else {
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        if (ServerAuthenticationContext.this.getCredentialAcquireSupport(PasswordCredential.class).mayBeSupported()) {
                            TwoWayPassword password;
                            PasswordCredential credential = ServerAuthenticationContext.this.getCredential(PasswordCredential.class);
                            if (credential != null && (password = credential.getPassword(TwoWayPassword.class)) != null) {
                                ClearPasswordSpec clearPasswordSpec;
                                try {
                                    PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                                    clearPasswordSpec = passwordFactory.getKeySpec(password, ClearPasswordSpec.class);
                                }
                                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                                    throw new FastUnsupportedCallbackException(callback);
                                }
                                passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                                this.handleOne(callbacks, idx + 1);
                                return;
                            }
                            throw new FastUnsupportedCallbackException(callback);
                        }
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    if (callback instanceof CredentialCallback) {
                        if (!((State)ServerAuthenticationContext.this.stateRef.get()).isStarted()) {
                            throw new FastUnsupportedCallbackException(callback);
                        }
                        CredentialCallback credentialCallback = (CredentialCallback)callback;
                        Credential credential = ServerAuthenticationContext.this.getCredential(credentialCallback.getCredentialType(), credentialCallback.getAlgorithm());
                        if (credential != null) {
                            credentialCallback.setCredential(credential);
                            this.handleOne(callbacks, idx + 1);
                            return;
                        }
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    if (callback instanceof ServerCredentialCallback) {
                        ServerCredentialCallback serverCredentialCallback = (ServerCredentialCallback)callback;
                        List<SecurityFactory<Credential>> serverCredentials = ServerAuthenticationContext.this.mechanismConfiguration.getServerCredentialFactories();
                        for (SecurityFactory<Credential> factory : serverCredentials) {
                            try {
                                Credential credential = factory.create();
                                if (!serverCredentialCallback.isCredentialSupported(credential)) continue;
                                serverCredentialCallback.setCredential(credential);
                                this.handleOne(callbacks, idx + 1);
                                return;
                            }
                            catch (GeneralSecurityException generalSecurityException) {
                            }
                        }
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    if (callback instanceof EvidenceVerifyCallback) {
                        EvidenceVerifyCallback evidenceVerifyCallback = (EvidenceVerifyCallback)callback;
                        evidenceVerifyCallback.setVerified(ServerAuthenticationContext.this.verifyEvidence(evidenceVerifyCallback.getEvidence()));
                    } else if (callback instanceof AuthenticationCompleteCallback) {
                        if (!ServerAuthenticationContext.this.isDone()) {
                            if (((AuthenticationCompleteCallback)callback).succeeded()) {
                                ServerAuthenticationContext.this.succeed();
                            } else {
                                ServerAuthenticationContext.this.fail();
                            }
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof SocketAddressCallback) {
                        SocketAddressCallback socketAddressCallback = (SocketAddressCallback)callback;
                        if (socketAddressCallback.getKind() == SocketAddressCallback.Kind.PEER) {
                            // empty if block
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof SecurityIdentityCallback) {
                        ((SecurityIdentityCallback)callback).setSecurityIdentity(ServerAuthenticationContext.this.getAuthorizedIdentity());
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof AvailableRealmsCallback) {
                        Collection<String> names = ServerAuthenticationContext.this.mechanismConfiguration.getMechanismRealmNames();
                        if (!names.isEmpty()) {
                            ((AvailableRealmsCallback)callback).setRealmNames(names.toArray(new String[names.size()]));
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)callback;
                        String mechanismRealm = rcb.getText();
                        if (mechanismRealm == null) {
                            mechanismRealm = rcb.getDefaultText();
                        }
                        ServerAuthenticationContext.this.setMechanismRealmName(mechanismRealm);
                        this.handleOne(callbacks, idx + 1);
                    } else {
                        CallbackUtil.unsupported(callback);
                    }
                }
            }
        };
    }

    private static String validatedRewrite(String name, NameRewriter rewriter) {
        String newName = rewriter.rewriteName(name);
        if (newName == null) {
            throw ElytronMessages.log.invalidName();
        }
        return newName;
    }

    static String rewriteAll(String name, NameRewriter r1, NameRewriter r2, NameRewriter r3) {
        if (r1 != null) {
            return ServerAuthenticationContext.validatedRewrite(name, r1);
        }
        if (r2 != null) {
            return ServerAuthenticationContext.validatedRewrite(name, r2);
        }
        if (r3 != null) {
            return ServerAuthenticationContext.validatedRewrite(name, r3);
        }
        return name;
    }

    static String mapAll(String name, RealmMapper r1, RealmMapper r2, RealmMapper r3, String defaultRealmName) {
        if (r1 != null) {
            return ServerAuthenticationContext.mapRealmName(name, r1, defaultRealmName);
        }
        if (r2 != null) {
            return ServerAuthenticationContext.mapRealmName(name, r2, defaultRealmName);
        }
        if (r3 != null) {
            return ServerAuthenticationContext.mapRealmName(name, r3, defaultRealmName);
        }
        return defaultRealmName;
    }

    private static String mapRealmName(String name, RealmMapper realmMapper, String defaultRealmName) {
        String realmName = realmMapper.getRealmMapping(name, null, null);
        return realmName != null ? realmName : defaultRealmName;
    }

    static final class RealmAssignedState
    extends State {
        private final MechanismRealmConfiguration mechanismRealmConfiguration;

        RealmAssignedState(MechanismRealmConfiguration mechanismRealmConfiguration) {
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        int getId() {
            return 2;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        boolean isDone() {
            return false;
        }

        @Override
        boolean isStarted() {
            return true;
        }
    }

    static final class NameAssignedState
    extends State {
        private final Principal authenticationPrincipal;
        private final RealmInfo realmInfo;
        private final RealmIdentity realmIdentity;
        private final MechanismRealmConfiguration mechanismRealmConfiguration;

        NameAssignedState(Principal authenticationPrincipal, RealmInfo realmInfo, RealmIdentity realmIdentity, MechanismRealmConfiguration mechanismRealmConfiguration) {
            this.authenticationPrincipal = authenticationPrincipal;
            this.realmInfo = realmInfo;
            this.realmIdentity = realmIdentity;
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        int getId() {
            return 3;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return this.authenticationPrincipal;
        }

        @Override
        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SecurityIdentityEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : this.realmIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getCredential(credentialType, algorithmName);
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.realmIdentity.verifyEvidence(evidence);
        }

        @Override
        RealmInfo getRealmInfo() {
            return this.realmInfo;
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return this.realmIdentity;
        }

        @Override
        boolean isDone() {
            return false;
        }

        @Override
        boolean isStarted() {
            return true;
        }
    }

    static final class AuthorizedState
    extends State {
        private final SecurityIdentity securityIdentity;
        private final Principal authenticationPrincipal;
        private final RealmInfo realmInfo;
        private final RealmIdentity realmIdentity;
        private final MechanismRealmConfiguration mechanismRealmConfiguration;

        AuthorizedState(SecurityIdentity securityIdentity, Principal authenticationPrincipal, RealmInfo realmInfo, RealmIdentity realmIdentity, MechanismRealmConfiguration mechanismRealmConfiguration) {
            this.securityIdentity = securityIdentity;
            this.authenticationPrincipal = authenticationPrincipal;
            this.realmInfo = realmInfo;
            this.realmIdentity = realmIdentity;
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        int getId() {
            return 4;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.securityIdentity;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return this.authenticationPrincipal;
        }

        @Override
        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SecurityIdentityEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : this.realmIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getCredential(credentialType, algorithmName);
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.realmIdentity.verifyEvidence(evidence);
        }

        @Override
        RealmInfo getRealmInfo() {
            return this.realmInfo;
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return this.realmIdentity;
        }

        @Override
        boolean isDone() {
            return false;
        }

        @Override
        boolean isStarted() {
            return true;
        }
    }

    static final class CompleteState
    extends State {
        private final SecurityIdentity identity;

        public CompleteState(SecurityIdentity identity) {
            this.identity = identity;
        }

        @Override
        int getId() {
            return 5;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.identity;
        }

        @Override
        boolean isDone() {
            return true;
        }

        @Override
        boolean isStarted() {
            return true;
        }
    }

    static final class SimpleState
    extends State {
        private final int id;
        private final boolean done;
        private final boolean started;

        SimpleState(int id, boolean done, boolean started) {
            this.id = id;
            this.done = done;
            this.started = started;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        boolean isDone() {
            return this.done;
        }

        @Override
        boolean isStarted() {
            return this.started;
        }
    }

    static abstract class State {
        State() {
        }

        abstract int getId();

        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        SecurityIdentity getAuthorizedIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        Principal getAuthenticationPrincipal() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return null;
        }

        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return null;
        }

        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        RealmInfo getRealmInfo() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        RealmIdentity getRealmIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        abstract boolean isDone();

        abstract boolean isStarted();
    }
}

