/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.HttpServerSession;
import org.wildfly.security.http.HttpSessionSpi;

public class HttpAuthenticator {
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final HttpExchangeSpi httpExchangeSpi;
    private final boolean required;
    private final boolean ignoreOptionalFailures;
    private final HttpSessionSpi httpSessionSpi;
    private volatile boolean authenticated = false;

    private HttpAuthenticator(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier, HttpExchangeSpi httpExchangeSpi, HttpSessionSpi httpSessionSpi, boolean required, boolean ignoreOptionalFailures) {
        this.mechanismSupplier = mechanismSupplier;
        this.httpExchangeSpi = httpExchangeSpi;
        this.httpSessionSpi = httpSessionSpi;
        this.required = required;
        this.ignoreOptionalFailures = ignoreOptionalFailures;
    }

    public boolean authenticate() throws HttpAuthenticationException {
        return new AuthenticationExchange().authenticate();
    }

    private boolean isAuthenticated() {
        return this.authenticated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        private HttpExchangeSpi httpExchangeSpi;
        private HttpSessionSpi httpSessionSpi = HttpSessionSpi.NOT_SUPPORTED;
        private boolean required;
        private boolean ignoreOptionalFailures;

        Builder() {
        }

        public Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        public Builder setHttpExchangeSpi(HttpExchangeSpi httpExchangeSpi) {
            this.httpExchangeSpi = httpExchangeSpi;
            return this;
        }

        public Builder setHttpSessionSpi(HttpSessionSpi httpSessionSpi) {
            this.httpSessionSpi = httpSessionSpi;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setIgnoreOptionalFailures(boolean ignoreOptionalFailures) {
            this.ignoreOptionalFailures = ignoreOptionalFailures;
            return this;
        }

        public HttpAuthenticator build() {
            return new HttpAuthenticator(this.mechanismSupplier, this.httpExchangeSpi, this.httpSessionSpi, this.required, this.ignoreOptionalFailures);
        }
    }

    private class AuthenticationExchange
    implements HttpServerRequest,
    HttpServerResponse {
        private volatile HttpServerAuthenticationMechanism currentMechanism;
        private volatile boolean authenticationAttempted = false;
        private volatile int responseCode = -1;
        private volatile boolean responseCodeAllowed = false;
        private volatile List<HttpServerMechanismsResponder> responders;
        private volatile HttpServerMechanismsResponder successResponder;

        private AuthenticationExchange() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean authenticate() throws HttpAuthenticationException {
            List authenticationMechanisms = (List)HttpAuthenticator.this.mechanismSupplier.get();
            this.responders = new ArrayList<HttpServerMechanismsResponder>(authenticationMechanisms.size());
            try {
                Iterator iterator = authenticationMechanisms.iterator();
                while (iterator.hasNext()) {
                    HttpServerAuthenticationMechanism nextMechanism;
                    this.currentMechanism = nextMechanism = (HttpServerAuthenticationMechanism)iterator.next();
                    nextMechanism.evaluateRequest(this);
                    if (!HttpAuthenticator.this.isAuthenticated()) continue;
                    if (this.successResponder != null) {
                        this.successResponder.sendResponse(this);
                    }
                    boolean bl = true;
                    return bl;
                }
                this.currentMechanism = null;
                if (HttpAuthenticator.this.required || this.authenticationAttempted && !HttpAuthenticator.this.ignoreOptionalFailures) {
                    this.responseCodeAllowed = true;
                    if (this.responders.size() > 0) {
                        this.responders.forEach(r -> r.sendResponse(this));
                        if (this.responseCode > 0) {
                            HttpAuthenticator.this.httpExchangeSpi.setResponseCode(this.responseCode);
                        } else {
                            HttpAuthenticator.this.httpExchangeSpi.setResponseCode(200);
                        }
                    } else {
                        HttpAuthenticator.this.httpExchangeSpi.setResponseCode(403);
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                authenticationMechanisms.forEach(m -> m.dispose());
            }
        }

        @Override
        public List<String> getRequestHeaderValues(String headerName) {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestHeaderValues(headerName);
        }

        @Override
        public String getFirstRequestHeaderValue(String headerName) {
            return HttpAuthenticator.this.httpExchangeSpi.getFirstRequestHeaderValue(headerName);
        }

        @Override
        public SSLSession getSSLSession() {
            return HttpAuthenticator.this.httpExchangeSpi.getSSLSession();
        }

        @Override
        public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void authenticationInProgress(HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void authenticationComplete(SecurityIdentity securityIdentity, HttpServerMechanismsResponder responder) {
            HttpAuthenticator.this.authenticated = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationComplete(securityIdentity, this.currentMechanism.getMechanismName());
            this.successResponder = responder;
        }

        @Override
        public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationFailed(message, this.currentMechanism.getMechanismName());
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            HttpAuthenticator.this.httpExchangeSpi.badRequest(failure, this.currentMechanism.getMechanismName());
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public String getRequestMethod() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestMethod();
        }

        @Override
        public String getRequestURI() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestURI();
        }

        @Override
        public Map<String, String[]> getParameters() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestParameters();
        }

        @Override
        public HttpServerCookie[] getCookies() {
            return HttpAuthenticator.this.httpExchangeSpi.getCookies();
        }

        @Override
        public InputStream getInputStream() {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestInputStream();
        }

        @Override
        public InetSocketAddress getSourceAddress() {
            return HttpAuthenticator.this.httpExchangeSpi.getSourceAddress();
        }

        @Override
        public void addResponseHeader(String headerName, String headerValue) {
            HttpAuthenticator.this.httpExchangeSpi.addResponseHeader(headerName, headerValue);
        }

        @Override
        public void setResponseCode(int responseCode) {
            if (!this.responseCodeAllowed) {
                throw ElytronMessages.log.responseCodeNotNow();
            }
            if (this.responseCode < 0 || responseCode != 200) {
                this.responseCode = responseCode;
            }
        }

        @Override
        public OutputStream getOutputStream() {
            return HttpAuthenticator.this.httpExchangeSpi.getResponseOutputStream();
        }

        @Override
        public void setResponseCookie(HttpServerCookie cookie) {
            HttpAuthenticator.this.httpExchangeSpi.setResponseCookie(cookie);
        }

        @Override
        public HttpServerSession getSession(boolean create) {
            return HttpAuthenticator.this.httpSessionSpi.getSession(create);
        }

        @Override
        public HttpServerSession getSession(String id) {
            return HttpAuthenticator.this.httpSessionSpi.getSession(id);
        }

        @Override
        public Set<String> getSessions() {
            return HttpAuthenticator.this.httpSessionSpi.getSessions();
        }
    }
}

