/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;

public class ClientCertAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private final CallbackHandler callbackHandler;

    ClientCertAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return "CLIENT_CERT";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        X509Certificate[] peerX509Certificates;
        SSLSession sslSession = request.getSSLSession();
        if (sslSession == null) {
            request.noAuthenticationInProgress();
            return;
        }
        SecurityIdentity securityIdentity = (SecurityIdentity)sslSession.getValue("org.wildfly.security.ssl.identity");
        if (securityIdentity != null) {
            request.authenticationComplete(securityIdentity);
            return;
        }
        try {
            Certificate[] peerCertificates = sslSession.getPeerCertificates();
            peerX509Certificates = new X509Certificate[peerCertificates.length];
            for (int i = 0; i < peerCertificates.length; ++i) {
                if (!(peerCertificates[i] instanceof X509Certificate)) {
                    request.noAuthenticationInProgress();
                    return;
                }
                peerX509Certificates[i] = (X509Certificate)peerCertificates[i];
            }
        }
        catch (SSLPeerUnverifiedException e) {
            ElytronMessages.log.trace("Peer not verified.");
            request.noAuthenticationInProgress();
            return;
        }
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(peerX509Certificates);
        EvidenceVerifyCallback evc = new EvidenceVerifyCallback(evidence);
        boolean authenticated = false;
        try {
            this.callbackHandler.handle(new Callback[]{evc});
            authenticated = evc.isVerified();
        }
        catch (IOException e) {
            throw new HttpAuthenticationException(e);
        }
        catch (UnsupportedCallbackException e) {
            // empty catch block
        }
        try {
            if (authenticated) {
                SecurityIdentityCallback securityIdentityCallback = new SecurityIdentityCallback();
                this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED, securityIdentityCallback});
                request.authenticationComplete(securityIdentityCallback.getSecurityIdentity());
                return;
            }
            this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.FAILED});
            request.authenticationFailed(ElytronMessages.log.authenticationFailed("CLIENT_CERT"));
            return;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new HttpAuthenticationException(e);
        }
    }
}

