/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.sasl.digest.AbstractDigestFactory;
import org.wildfly.security.sasl.digest.DigestSaslServer;

public class DigestServerFactory
extends AbstractDigestFactory
implements SaslServerFactory {
    public static final char REALM_DELIMITER = ' ';
    public static final char REALM_ESCAPE_CHARACTER = '\\';

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Boolean utf8;
        String realmList;
        if (!this.matches(props) || !this.matchesMech(mechanism)) {
            return null;
        }
        String[] realms = null;
        AvailableRealmsCallback availableRealmsCallback = new AvailableRealmsCallback();
        try {
            cbh.handle(new Callback[]{availableRealmsCallback});
            realms = availableRealmsCallback.getRealmNames();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(mechanism, e).toSaslException();
        }
        if (realms == null && (realmList = (String)props.get("com.sun.security.sasl.digest.realm")) != null) {
            realms = DigestServerFactory.realmsPropertyToArray(realmList);
        }
        if (realms == null) {
            realms = new String[]{serverName};
        }
        Charset charset = (utf8 = (Boolean)props.get("com.sun.security.sasl.digest.utf8")) == null || utf8 != false ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        String qopsString = (String)props.get("javax.security.sasl.qop");
        String[] qops = qopsString == null ? null : qopsString.split(",");
        String supportedCipherOpts = (String)props.get("org.jboss.security.sasl.digest.ciphers");
        String[] cipherOpts = supportedCipherOpts == null ? null : supportedCipherOpts.split(",");
        DigestSaslServer server = new DigestSaslServer(realms, mechanism, protocol, serverName, cbh, charset, qops, cipherOpts);
        server.init();
        return server;
    }

    public static String realmsArrayToProperty(String[] array) {
        StringBuilder realms = new StringBuilder();
        for (int j = 0; j < array.length; ++j) {
            if (j != 0) {
                realms.append(' ');
            }
            block5: for (int i = 0; i < array[j].length(); ++i) {
                switch (array[j].charAt(i)) {
                    case '\\': {
                        realms.append('\\');
                        realms.append('\\');
                        continue block5;
                    }
                    case ' ': {
                        realms.append('\\');
                        realms.append(' ');
                        continue block5;
                    }
                    default: {
                        realms.append(array[j].charAt(i));
                    }
                }
            }
        }
        return realms.toString();
    }

    static String[] realmsPropertyToArray(String property) {
        ArrayList<String> array = new ArrayList<String>();
        StringBuilder realm = new StringBuilder();
        boolean wasSlash = false;
        for (int i = 0; i < property.length(); ++i) {
            char c = property.charAt(i);
            if (wasSlash) {
                realm.append(property.charAt(i));
                wasSlash = false;
                continue;
            }
            if (c == '\\') {
                wasSlash = true;
                continue;
            }
            if (c == ' ') {
                array.add(realm.toString());
                realm = new StringBuilder();
                continue;
            }
            realm.append(property.charAt(i));
        }
        array.add(realm.toString());
        return array.toArray(new String[array.size()]);
    }
}

