/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.sasl.util.SaslFactories;

public final class SecurityProviderSaslClientFactory
implements SaslClientFactory {
    private static final String serviceType = SaslClientFactory.class.getSimpleName();
    private final Supplier<Provider[]> providerSupplier;

    public SecurityProviderSaslClientFactory(Supplier<Provider[]> providerSupplier) {
        this.providerSupplier = providerSupplier;
    }

    public SecurityProviderSaslClientFactory() {
        this(Security::getProviders);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        BiPredicate<String, Provider> mechFilter = SaslFactories.getProviderFilterPredicate(props);
        for (Provider currentProvider : this.providerSupplier.get()) {
            Set<Provider.Service> services;
            String[] filtered = SaslFactories.filterMechanismsByProvider(mechanisms, 0, 0, currentProvider, mechFilter);
            if (filtered.length <= 0 || (services = currentProvider.getServices()) == null) continue;
            for (Provider.Service service : currentProvider.getServices()) {
                if (!serviceType.equals(service.getType())) continue;
                try {
                    SaslClient saslClient = ((SaslClientFactory)service.newInstance(null)).createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
                    if (saslClient == null) continue;
                    return saslClient;
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException exception) {
                }
            }
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        BiPredicate<String, Provider> mechFilter = SaslFactories.getProviderFilterPredicate(props);
        LinkedHashSet names = new LinkedHashSet();
        for (Provider currentProvider : this.providerSupplier.get()) {
            Set<Provider.Service> services = currentProvider.getServices();
            if (services == null) continue;
            for (Provider.Service service : services) {
                if (!serviceType.equals(service.getType())) continue;
                try {
                    String[] mechanismNames = ((SaslClientFactory)service.newInstance(null)).getMechanismNames(props);
                    Collections.addAll(names, SaslFactories.filterMechanismsByProvider(mechanismNames, 0, 0, currentProvider, mechFilter));
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException exception) {}
            }
        }
        return names.toArray(new String[names.size()]);
    }
}

